/*
 * $Id: Alphacube.h,v 1.12 2003/12/15 15:10:16 Alphacubekl Exp $
 *
 * Alphacube KWin client (version 0.8)
 *
 * Copyright (C) 2002 Fredrik H�lund <fredrik@kde.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the license, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */


#ifndef __ALPHACUBE_H
#define __ALPHACUBE_H
//parameter and options---------------------

//#define RIGHTRISTATE
//#define AVATARENABLED
#define CUSTOMBUTTONS
//#define LARGEPAINTCENTER
//#define NOBTTLEFT
//#define NOBTTRIGHT
//#define ALLOWDISBTT
//#define ALLOWHUGETHEME
//#define DISABLEDOUBLEBUFFER
//end

//constants for adjustement------------------
//#define TOPSPACING 3
#define TOPSPACING 0
//#define HUGETOPSPACING 1
#define CAPTIONHEIGHTADJUSTEMENT 0
//#define HUGECAPTIONHEIGHTADJUSTEMENT 13
//end

#include <qbutton.h>
#include <kdecoration.h>
#include <kdecorationfactory.h>
#include <qimage.h>
#include <qpixmap.h>
#include <qlayout.h>
#include "tiles.h"
#include <qstring.h>
#include <qcolor.h>
#include <qbitmap.h>
#include <qdict.h>
#include <kpixmapio.h>
#include <qguardedptr.h>

class	QSpacerItem;

namespace Alphacube {
	//adjustement variables

	const int	buttonMargin			= 16;  // Margin between the window edge and the buttons (7)
	const int	hugeButtonMargin		= 12;
	const int	buttonSpacing			= 0;  // Spacing between the titlebar buttons (3)
	const int	hugeButtonSpacing		= 0;
	const int	iconSpacing				= 0;  // Spacing between the icon and the text label (4)
	const int	iconAppSpacing			= 0;  // Spacing between the icon and the border (1)
	const int	textSpacing				= 7;  // Spacing between the text and appicon (5)                            
	const char	default_left[]			= "H";
	const char	default_right[]			= "IAX";
	bool		Alphacube_initialized	= false;

	#ifdef RIGHTRISTATE

	enum TilePixmap {
		TitleLeft = 0,TitleCenter,TitleRight,TitleRight1,TitleRight2,TitleRight3,CaptionSmallLeft,
		CaptionSmallCenter,CaptionSmallRight,CaptionLargeLeft,CaptionLargeCenter,CaptionLargeRight,
		GrabBarLeft,GrabBarCenter,GrabBarRight,BorderLeft,BorderRight,NumTiles
	};
	#else

	enum TilePixmap {
		TitleLeft = 0,TitleCenter,TitleRight,CaptionSmallLeft,CaptionSmallCenter,CaptionSmallRight,
		CaptionLargeLeft,CaptionLargeCenter,CaptionLargeRight,GrabBarLeft,GrabBarCenter,
		GrabBarRight,BorderLeft,BorderRight,NumTiles
	};
	#endif

	#ifdef CUSTOMBUTTONS
	#ifdef ALLOWDISBTT

	enum Button {
		HelpButton = 0,MinButton,MaxButton,CloseButton,DisMinButton,DisMaxButton,DisCloseButton,
		Restore,NumButtons
	};
	#else

	enum Button {
		HelpButton = 0,MinButton,MaxButton,CloseButton,Restore,NumButtons
	};
	#endif

	#else
	#ifdef ALLOWDISBTT

	enum Button {
		MenuButton = 0,OnAllDesktopsButton,HelpButton,MinButton,MaxButton,CloseButton,DisMinButton,
		DisMaxButton,DisCloseButton,Restore,NotOnAllDesktops,NumButtons
	};
	#else

	enum Button {
		MenuButton = 0,OnAllDesktopsButton,HelpButton,MinButton,MaxButton,CloseButton,Restore,
		NotOnAllDesktops,NumButtons
	};
	#endif
	#endif

	struct {
		bool showIcons, shadowedText, largeGrabBars, smallCaptionBubbles, Transparency, tsize;
		int	shadowtype, effectvalues, bubbletype, topSpacing, btnposflag, numbuttons,
			LeftWidth, RightWidth, textpos, coloroption, effects, CaptionAdjustement,
			Colorize;
			QColor	ShadowColor, IconEffectColor, InShadowColor;
	} Settings_Param;

	#ifdef AVATARENABLED

	struct {
			QString	avatarfuncURL, avatarpix, avatarfunctype;
			int		avatarfunc, avatar;
	}
  Avatar_Params;
	#endif

	class AlphacubeHandler : public KDecorationFactory {
		public:
			AlphacubeHandler();
			~AlphacubeHandler();

			virtual QValueList< BorderSize > borderSizes() const;
			virtual bool reset(unsigned long changed);
			virtual KDecoration *createDecoration(KDecorationBridge *);

			bool showAppIcons() const {
				return Settings_Param.showIcons;
			}
			bool useShadowedText() const {
				return Settings_Param.shadowedText;
			}
			bool largeCaptionBubbles() const {
				return !Settings_Param.smallCaptionBubbles;
			}

			int titleBarHeight() const {
				#ifdef ALLOWHUGETHEME
				if (Settings_Param.tsize)
					return hugeActiveTiles[TitleCenter]->height();
				else
					return activeTiles[TitleCenter]->height();
				#else

				return activeTiles[TitleCenter]->height();
				#endif
			}

			int grabBarHeight() const {
				#ifdef ALLOWHUGETHEME
				if (Settings_Param.tsize)
					return hugeActiveTiles[GrabBarCenter]->height();
				else
					return activeTiles[GrabBarCenter]->height();
				#else

				return activeTiles[GrabBarCenter]->height();
				#endif
			}

			inline const QPixmap *tile(TilePixmap tilePix, bool active) const;

			#ifdef ALLOWDISBTT

			inline const QPixmap *btile(Button buttonPix, bool active, bool dis) const;
			#else

			inline const QPixmap *btile(Button buttonPix, bool active) const;
			#endif

			#ifdef LARGEPAINTCENTER

			QPixmap iTile(bool active, int w, int h);
			#endif

		protected:
			void readConfig();
			void createPixmaps(bool);
			void destroyPixmaps();

			void addWidth(int width, QPixmap *&pix, bool left, QPixmap *bottomPix);
			void addHeight(int height, QPixmap *&pix);
			void flip(QPixmap *&, QPixmap *&);
			void flip(QPixmap *&);
			void pretile(QPixmap *&, int, Qt::Orientation);
			QImage *loadImage(const QString &);//, const QColor & );
			QPixmap *loadPixmap(const QString &, bool);//, const QColor & );
			AlphacubeImageDb	   *imageDb;
			KPixmapIO			FastImageIO;
			QPixmap			   *activeTiles[NumTiles];
			QPixmap			   *inactiveTiles[NumTiles];
			QPixmap			   *activeButtons[NumButtons];
			QPixmap			   *inactiveButtons[NumButtons];
			#ifdef ALLOWDISBTT

			QPixmap			   *disabledButtons[NumButtons];
			#endif

			#ifdef ALLOWHUGETHEME

			QPixmap			   *hugeActiveTiles[NumTiles];
			QPixmap			   *hugeInactiveTiles[NumTiles];
			QPixmap			   *hugeActiveButtons[NumButtons];
			QPixmap			   *hugeInactiveButtons[NumButtons];
			#ifdef ALLOWDISBTT

			QPixmap			   *hugeDisabledButtons[NumButtons];
			#endif
			#endif

			#ifdef LARGEPAINTCENTER

			QImage				largecenter;

			#endif
	}
	; // class AlphacubeHandler

	class				AlphacubeClient;
	class AlphacubeButton : public QButton {
		public:
			AlphacubeButton(AlphacubeClient *, const char *, Button, const QString &, bool bttstate,
						   const int realizeBtns = LeftButton);
			~AlphacubeButton();

			inline const int lastButton() const {
				return lastbutton;
			}

		private:
			void enterEvent(QEvent *);
			void leaveEvent(QEvent *);
			void mousePressEvent(QMouseEvent *);
			void mouseReleaseEvent(QMouseEvent *);
			void drawButton(QPainter *);
		private:
			AlphacubeClient *client;
			Button			button;
			bool			hover;
			int				lastbutton;
			int				realizeButtons;
			int				sizebtt;
			int				sizeh;  	
			#ifdef ALLOWDISBTT

			bool			bttdis;
			#endif
	}
	; // class AlphacubeButton

	#ifdef AVATARENABLED

	class AlphacubeAvatarButton : public QButton {
		public:
			AlphacubeAvatarButton(AlphacubeClient *, const char *, const QString &);
			~AlphacubeAvatarButton();
			QImage LoadAvatar();
		private:
			void enterEvent(QEvent *);
			void leaveEvent(QEvent *);
			void drawButton(QPainter *);
			void updateMask();
			QImage FastScaleImage(const QString &, int, int);
		private:
			AlphacubeClient *client;
			bool			over;
	};
	#endif

	class AlphacubeClient : public KDecoration {
			Q_OBJECT

		public:

			AlphacubeClient(KDecorationBridge *bridge, KDecorationFactory *factory);
			~AlphacubeClient();

			#ifdef RIGHTRISTATE

			int ButtonsOnLeft();
			#else

			int BttWidthOnLeft();
			int BttWidthOnRight();
			#endif

			virtual void init();
			virtual void reset(unsigned long changed);
			virtual Position mousePosition(const QPoint &p) const;
			virtual void borders(int &left, int &right, int &top, int &bottom) const;
			virtual void resize(const QSize &s);
			virtual QSize minimumSize() const;
			virtual bool eventFilter(QObject *o, QEvent *e);
			virtual void activeChange();
			virtual void captionChange();
			virtual void maximizeChange();
			virtual void desktopChange();
			virtual void shadeChange() {
			}
			;

		private:
			void createLayout();
			void addButtons(QBoxLayout *, const QString &);
			#ifdef AVATARENABLED

			void addAvatar();
			#endif

			void updateMask(); // FRAME
			void iconChange();
			void drawAppIcon(QPainter &);
			void drawCaptionText(QPainter &);
			void drawTitlebar(QPainter &, QRect &);
			void drawFrame(QPainter &, QRect &, QPaintEvent *);
			void resizeEvent(QResizeEvent *); // FRAME
			void paintEvent(QPaintEvent *); // FRAME
			void mouseDoubleClickEvent(QMouseEvent *); // FRAME
			inline int width() const {
				return widget()->width();
			}

			inline int height() const {
				return widget()->height();
			}

			inline bool maximizedVertical() const {
				return (maximizeMode() & MaximizeVertical);
			}

		private slots:
			void menuButtonPressed();
			void slotMaximize();
			#ifdef AVATARENABLED

			//   void AvatarAction();
			#endif

		private:
			QSpacerItem			   *topSpacer, *titlebar;
			AlphacubeButton		   *button[NumButtons];
			QPixmap				   *activeIcon, *inactiveIcon;
			bool					maskDirty			: 1;
			bool					captionBufferDirty	: 1;
			bool					iconBufferDirty		: 1;
			bool					largeCaption		: 1;

			#ifdef RIGHTRISTATE

			int						ButtonsLeft;
			TilePixmap				pixNumBtt;
			#endif
			#ifdef AVATARENABLED

			AlphacubeAvatarButton   *btt ;
			#endif
			#ifdef CUSTOMBUTTONS

			AlphacubeButton		   *bttHelp ;
			#endif
	}
	; // class AlphacubeClient
} // namespace Alphacube

#endif // ___ALPHACUBE_H

// vim: set noet ts=4 sw=4:

