/***************************************************************************
 *   Copyright (C) 2006 by Tomasz Sałaciński   *
 *   distortion@vp.pl   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

//KDE Includes
#include <kiconloader.h>
#include <ktabwidget.h>
#include <kinputdialog.h>
#include <kmessagebox.h>

//QT Includes
#include <qlabel.h>

//kX Generator Includes
#include "AdvancedWidget.h"
#include "properties.h"


AdvancedWidget :: AdvancedWidget(QWidget *Parent, Xorg *Xorg)
    : QWidget( Parent, "Mouse Widget" )
{

X = Xorg;

//Setting  geometry
setGeometry(0, 0, 560, 351);

//Creating pixmap
    KIconLoader *Icons = new KIconLoader();
    QLabel *Pixmap = new QLabel(this);
    Pixmap->setGeometry(422, 10, 128, 128);
    Pixmap->setPixmap(Icons->loadIcon("system", KIcon::Desktop, KIcon::SizeEnormous));

//Information Label
   QLabel *InformationLabel = new QLabel(this);
    InformationLabel->setText(Locale(0));
    InformationLabel->setFont(QFont("sans", 19, QFont::Normal, FALSE));
    InformationLabel->setGeometry(10, 10, 400, 30);
//Horizontal Line
   QFrame *Line = new QFrame(this);
    Line->setGeometry(QRect(10, 45, 400, 5));
    Line->setFrameShape( QFrame::HLine );
    Line->setFrameShadow( QFrame::Sunken );
//Instructional label
   QLabel *InstructionalLabel = new QLabel(this);
    InstructionalLabel->setGeometry(10, 60, 400, 75);
    InstructionalLabel->setAlignment(QLabel::AlignTop | QLabel::WordBreak);
    InstructionalLabel->setText(Locale(1));

//Tab Widget

   KTabWidget *AdvancedTabWidget = new KTabWidget(this);

    QWidget *FilesTab = new QWidget();
    QWidget *ModulesTab = new QWidget();
    QWidget *ExtensionsTab = new QWidget();
    QWidget *OptionsTab = new QWidget();


    AdvancedTabWidget->setGeometry(10, 140, 550, 198);
    AdvancedTabWidget->insertTab(FilesTab, Icons->loadIcon("filefind", KIcon::Toolbar, KIcon::SizeSmall), Locale(2));
    AdvancedTabWidget->insertTab(ModulesTab, Icons->loadIcon("rebuild", KIcon::Toolbar, KIcon::SizeSmall), Locale(3));
    AdvancedTabWidget->insertTab(ExtensionsTab, Icons->loadIcon("run", KIcon::Toolbar, KIcon::SizeSmall), Locale(4));
   AdvancedTabWidget->insertTab(OptionsTab, Icons->loadIcon("gear", KIcon::Toolbar, KIcon::SizeSmall), Locale(19));
///Files tab

   RGBCheck = new QCheckBox(FilesTab);
    RGBCheck->setGeometry(10, 30, 160, 25);
    RGBCheck->setText(Locale(13));

   RGBPath = new KURLRequester(FilesTab);
    RGBPath->setMode(KFile::Directory);
    RGBPath->setGeometry(170, 30, 270, 25);


   ClearRGBButton = new KPushButton(FilesTab);
    ClearRGBButton->setGeometry(450, 30, 80, 25);
    ClearRGBButton->setText(Locale(16));
    ClearRGBButton->setIconSet(Icons->loadIcon("remove", KIcon::Toolbar, KIcon::SizeSmall));


   FontsCheck = new QCheckBox(FilesTab);
    FontsCheck->setGeometry(10, 70, 160, 25);
    FontsCheck->setText(Locale(14));


   FontsPath = new KURLComboRequester(FilesTab);
    FontsPath->setMode(KFile::Directory);
    FontsPath->setGeometry(170, 70, 270, 25);
    FontsPath->comboBox()->setAutoResize(FALSE);

   ClearFontsButton = new KPushButton(FilesTab);
    ClearFontsButton->setGeometry(450, 70, 80, 25);
    ClearFontsButton->setText(Locale(16));
    ClearFontsButton->setIconSet(Icons->loadIcon("remove", KIcon::Toolbar, KIcon::SizeSmall));


   ModulesCheck = new QCheckBox(FilesTab);
    ModulesCheck->setGeometry(10, 110, 160, 25);
    ModulesCheck->setText(Locale(15));

   ModulesPath = new KURLComboRequester(FilesTab);
    ModulesPath->setMode(KFile::Directory);
    ModulesPath->setGeometry(170, 110, 270, 25);
    ModulesPath->comboBox()->setAutoResize(FALSE);

   ClearModulesButton = new KPushButton(FilesTab);
    ClearModulesButton->setGeometry(450, 110, 80, 25);
    ClearModulesButton->setText(Locale(16));
    ClearModulesButton->setIconSet(Icons->loadIcon("remove", KIcon::Toolbar, KIcon::SizeSmall));


FontsCombo = FontsPath->comboBox();
ModulesCombo = ModulesPath->comboBox();
EnterFileFonts = FontsPath->button();
EnterFileModules = ModulesPath->button();
EnterFileRGB = RGBPath->button();
RGBLine = RGBPath->lineEdit();

FontsCombo->setMaximumSize(240, 25);
ModulesCombo->setMaximumSize(240, 25);


///Modules tab
   ModulesBox = new KListBox(ModulesTab);
    ModulesBox->setGeometry(10, 10, 390, 145);

   KPushButton *AddModuleButton = new KPushButton(ModulesTab);
         AddModuleButton->setText(Locale(5));
         AddModuleButton->setGeometry(410, 10, 130, 25);
         AddModuleButton->setIconSet(Icons->loadIcon("add", KIcon::Toolbar, KIcon::SizeSmall));

   KPushButton *RemoveModuleButton = new KPushButton(ModulesTab);
         RemoveModuleButton->setText(Locale(6));
         RemoveModuleButton->setGeometry(410, 40, 130, 25);
         RemoveModuleButton->setIconSet(Icons->loadIcon("remove", KIcon::Toolbar, KIcon::SizeSmall));


///Extensions tab

   Xinerama = new QCheckBox(ExtensionsTab);
    Xinerama->setGeometry(10, 20, 300, 25);
    Xinerama->setText(Locale(17));

   Composite = new QCheckBox(ExtensionsTab);
    Composite->setGeometry(10, 50, 300, 25);
    Composite->setText(Locale(18));



///Options tab

       DontZap = new QCheckBox(OptionsTab);
        DontZap->setGeometry(10, 10, 400, 25);
        DontZap->setText(Locale(20));

       DontVT = new QCheckBox(OptionsTab);
        DontVT->setGeometry(10, 35, 400, 25);
        DontVT->setText(Locale(21));

       DontZoom = new QCheckBox(OptionsTab);
        DontZoom->setGeometry(10, 60, 400, 25);
        DontZoom->setText(Locale(22));

       PC98 = new QCheckBox(OptionsTab);
        PC98->setGeometry(10, 85, 400, 25);
        PC98->setText(Locale(23));

       MouseFail = new QCheckBox(OptionsTab);
        MouseFail->setGeometry(10, 110, 400, 25);
        MouseFail->setText(Locale(24));

       KPushButton *AdvancedFlags = new KPushButton(OptionsTab);
        AdvancedFlags->setGeometry(380, 10, 150, 25);
        AdvancedFlags->setText(Locale(25));
        AdvancedFlags->setIconSet(Icons->loadIcon("pref", KIcon::Toolbar, KIcon::SizeSmall));







InitModules();
InitFiles();
InitExtensions();

connect (AddModuleButton, SIGNAL(clicked()), this, SLOT(AddModule()));
connect (RemoveModuleButton, SIGNAL(clicked()), this, SLOT(RemoveModule()));
connect (RGBCheck, SIGNAL(toggled(bool)), this, SLOT(RGBCheckBoxHandle(bool)));
connect (FontsCheck, SIGNAL(toggled(bool)), this, SLOT(FontsCheckBoxHandle(bool)));
connect (ModulesCheck, SIGNAL(toggled(bool)), this, SLOT(ModulesCheckBoxHandle(bool)));
connect (EnterFileFonts, SIGNAL(clicked()), this, SLOT(FontsUpdate()));
connect (EnterFileModules, SIGNAL(clicked()), this, SLOT(ModulesUpdate()));
connect (EnterFileRGB, SIGNAL(clicked()), this, SLOT(RGBUpdate()));
connect (RGBLine, SIGNAL(textChanged (const QString&)), this, SLOT(RGBUpdate()));
connect (ClearRGBButton, SIGNAL(clicked()), this, SLOT(ClearRGB()));
connect (ClearFontsButton, SIGNAL(clicked()), this, SLOT(ClearFonts()));
connect (ClearModulesButton, SIGNAL(clicked()), this, SLOT(ClearModules()));
connect (Xinerama, SIGNAL(toggled(bool)), this, SLOT(XineramaHandle(bool)));
connect (Composite, SIGNAL(toggled(bool)), this, SLOT(CompositeHandle(bool)));
}



void AdvancedWidget :: AddModule()
{
QString ModuleToAdd = KInputDialog::getText(Locale(7), Locale(8), QString::null);

if (ModuleToAdd == "") { return; }

if (ModulesBox->findItem(ModuleToAdd, Qt::ExactMatch) != 0)
  {
   KMessageBox::error(this, Locale(9).arg(ModuleToAdd), Locale(10));
   return;
  }

X->AppendValue(Xorg::Modules, 1, "Load", ModuleToAdd);
InitModules();

}

void AdvancedWidget :: RemoveModule()
{
QString CurrentModule = ModulesBox->text(ModulesBox->currentItem());
int Result = KMessageBox::questionYesNo(this, Locale(11).arg(CurrentModule), Locale(12));

if (Result == KMessageBox::No) { return; }
X->RemoveValue(Xorg::Modules, 1, "Load", CurrentModule);
InitModules();

}

void AdvancedWidget :: InitModules()
{
//Modules
ModulesBox->clear();
 for (int a = 1; a <= X->CountValues(Xorg::Modules, 1, "Load"); a++)
  {
   ModulesBox->insertItem(X->GetValue(Xorg::Modules, 1, "Load", a));
  }

ModulesBox->setSelected(0, TRUE);
}

void AdvancedWidget :: InitFiles()
{
RGBPath->setURL(X->GetValue(Xorg::Files, 1, "RGBPath",1));

FontsCombo->clear();
ModulesCombo->clear();
QString Fonts = "";

  for (int a = 1; a <= X->CountValues(Xorg::Files, 1, "FontPath"); a++)
   {
    Fonts = Fonts.append(X->GetValue(Xorg::Files, 1, "FontPath", a) + "|");
   }
Fonts = Fonts.replace("|", ",");
for (int x = 0; x <= Fonts.contains(","); x++)
{
if (Fonts.section(",", x, x) == "") { break; }
FontsCombo->insertItem(Fonts.section(",", x, x).simplifyWhiteSpace());
}


QString Modules = "";

  for (int a = 1; a <= X->CountValues(Xorg::Files, 1, "ModulePath"); a++)
   {
    Modules = Modules.append(X->GetValue(Xorg::Files, 1, "ModulePath", a) + "|");
   }
Modules = Modules.replace("|", ",");
for (int x = 0; x <= Modules.contains(","); x++)
{
if (Modules.section(",", x, x) == "") { break; }
ModulesCombo->insertItem(Modules.section(",", x, x).simplifyWhiteSpace());
}

if (RGBPath->url() == "") { RGBCheck->setChecked(FALSE); RGBCheckBoxHandle(FALSE); }
if (RGBPath->url() != "") { RGBCheck->setChecked(TRUE); RGBCheckBoxHandle(TRUE); }

if (FontsCombo->count() == 0)   { FontsCheck->setChecked(FALSE); FontsCheckBoxHandle(FALSE); }
if (FontsCombo->count() > 0)    { FontsCheck->setChecked(TRUE); FontsCheckBoxHandle(TRUE); }

if (ModulesCombo->count() == 0) { ModulesCheck->setChecked(FALSE); ModulesCheckBoxHandle(FALSE); }
if (ModulesCombo->count() > 0)  { ModulesCheck->setChecked(TRUE); ModulesCheckBoxHandle(TRUE); }


  for (int a = 0; a <= X->CountValues(Xorg::Files, 1, "FontPath"); a++)
   {
    X->RemoveValue(Xorg::Files, 1, "FontPath");
   }

  for (int a = 0; a <= X->CountValues(Xorg::Files, 1, "ModulePath"); a++)
   {
    X->RemoveValue(Xorg::Files, 1, "ModulePath");
   }

X->WriteValue(Xorg::Files, 1, "FontPath", Fonts.left(Fonts.length() - 1));
X->WriteValue(Xorg::Files, 1, "ModulePath", Modules.left(Modules.length() - 1));
}

void AdvancedWidget :: RGBCheckBoxHandle(bool Checked)
{
   if (Checked)
    {
     if (RGBPath->url() != "") { ClearRGBButton->setEnabled(TRUE); }
     RGBPath->setEnabled(TRUE);
    }
   else
    {
     ClearRGBButton->setEnabled(FALSE);
     RGBPath->setEnabled(FALSE);
     X->RemoveValue(Xorg::Files, 1, "RGBPath");
    }

}

void AdvancedWidget :: FontsCheckBoxHandle(bool Checked)
{
   if (Checked)
    {
     if (FontsCombo->count() != 0) { ClearFontsButton->setEnabled(TRUE); }
     FontsPath->setEnabled(TRUE);
    }
   else
    {
     ClearFontsButton->setEnabled(FALSE);
     FontsPath->setEnabled(FALSE);
     X->RemoveValue(Xorg::Files, 1, "FontPath");
    }

}

void AdvancedWidget :: ModulesCheckBoxHandle(bool Checked)
{
   if (Checked)
    {
     if (ModulesCombo->count() != 0) { ClearModulesButton->setEnabled(TRUE); }
     ModulesPath->setEnabled(TRUE);
    }
   else
    {
     ClearModulesButton->setEnabled(FALSE);
     ModulesPath->setEnabled(FALSE);
     X->RemoveValue(Xorg::Files, 1, "ModulePath");
    }

}

void AdvancedWidget :: FontsUpdate()
{
QString Fonts = "";
  for (int a = 0; a < FontsCombo->count(); a++) { Fonts = Fonts.append(FontsCombo->text(a) + ","); }

    X->WriteValue(Xorg::Files, 1, "FontPath", Fonts.left(Fonts.length() - 1));
    InitFiles();
}

void AdvancedWidget :: ModulesUpdate()
{
QString Modules = "";
  for (int a = 0; a < ModulesCombo->count(); a++) { Modules = Modules.append(ModulesCombo->text(a) + ","); }

    X->WriteValue(Xorg::Files, 1, "ModulePath", Modules.left(Modules.length() - 1));
    InitFiles();
}

void AdvancedWidget :: RGBUpdate()
{
if (RGBPath->url() != "") { ClearRGBButton->setEnabled(TRUE); }
if (RGBPath->url() == "") { ClearRGBButton->setEnabled(FALSE); }
    X->WriteValue(Xorg::Files, 1, "RGBPath", RGBPath->url());
}

void AdvancedWidget :: ClearRGB()
{
ClearRGBButton->setEnabled(FALSE);
RGBPath->clear();
}

void AdvancedWidget :: ClearFonts()
{
FontsCombo->removeItem(FontsCombo->currentItem());
if (FontsCombo->count() == 0) { ClearFontsButton->setEnabled(FALSE); }
FontsUpdate();
}

void AdvancedWidget :: ClearModules()
{
ModulesCombo->removeItem(ModulesCombo->currentItem());
if (ModulesCombo->count() == 0) { ClearModulesButton->setEnabled(FALSE); }
ModulesUpdate();
}

void AdvancedWidget :: CompositeHandle(bool Checked)
{
if (Checked)
 {
  X->WriteOption(Xorg::Extensions, 1, "Composite", BOOL_TRUE);
 }
else
 {
  X->RemoveOption(Xorg::Extensions, 1, "Composite");
 }

}

void AdvancedWidget :: XineramaHandle(bool Checked)
{
if (Checked)
 {
  X->WriteOption(Xorg::Extensions, 1, "Xinerama", BOOL_TRUE);
 }
else
 {
  X->RemoveOption(Xorg::Extensions, 1, "Xinerama");
 }
}

void AdvancedWidget :: InitExtensions()
{
if (X->GetBoolOption(Xorg::Extensions, 1, "Composite") == TRUE) { Composite->setChecked(TRUE); }
                                                                else
                                                                { Composite->setChecked(FALSE); }
if (X->GetBoolOption(Xorg::Extensions, 1, "Xinerama") == TRUE)  { Xinerama->setChecked(TRUE); }
                                                                else
                                                                { Xinerama->setChecked(FALSE); }
}
