/***************************************************************************
 *   Copyright (C) 2006 by Tomasz Sałaciński   *
 *   distortion@vp.pl   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

//KDE Includes
#include <kiconloader.h>
#include <kpushbutton.h>

//QT Includes
#include <qlabel.h>
#include <qtabwidget.h>

//kX Generator Includes
#include "MonitorWidget.h"
#include "ScreenModesEditor.h"
#include "ChangeEntriesDialog.h"

MonitorWidget :: MonitorWidget(QWidget *Parent, Xorg *Xorg)
    : QWidget( Parent, "Mouse Widget" )
{

X = Xorg;

//Setting  geometry
setGeometry(0, 0, 560, 351);

//Creating pixmap
    KIconLoader *Icons = new KIconLoader();
    QLabel *Pixmap = new QLabel(this);
    Pixmap->setGeometry(422, 10, 128, 128);
    Pixmap->setPixmap(Icons->loadIcon("background", KIcon::Desktop, KIcon::SizeEnormous));

//Information Label
   QLabel *InformationLabel = new QLabel(this);
    InformationLabel->setText(Locale(0));
    InformationLabel->setFont(QFont("sans", 19, QFont::Normal, FALSE));
    InformationLabel->setGeometry(10, 10, 400, 30);
//Horizontal Line
   QFrame *Line = new QFrame(this);
    Line->setGeometry(QRect(10, 45, 400, 5));
    Line->setFrameShape( QFrame::HLine );
    Line->setFrameShadow( QFrame::Sunken );


//Instructional label
   QLabel *InstructionalLabel = new QLabel(this);
    InstructionalLabel->setGeometry(10, 60, 400, 75);
    InstructionalLabel->setAlignment(QLabel::AlignTop | QLabel::WordBreak);
    InstructionalLabel->setText(Locale(1));

    QWidget *MonitorTab = new QWidget();
    QWidget *ScreenTab = new QWidget();

///Filling MONITOR tab

     QLabel *IdentifierLabel = new QLabel(MonitorTab);
      IdentifierLabel->setGeometry(10, 10, 380, 25);
      IdentifierLabel->setText(Locale(4));

      MonitorCombo = new KComboBox(MonitorTab);
      MonitorCombo->setGeometry(10, 35, 380, 25);

   KPushButton *ChangeNameButtonMonitor = new KPushButton(MonitorTab);
    ChangeNameButtonMonitor->setText(Locale(5));
    ChangeNameButtonMonitor->setGeometry(400, 35, 140, 25);
    ChangeNameButtonMonitor->setIconSet(Icons->loadIcon("edit", KIcon::Toolbar, KIcon::SizeSmall));

    QLabel *VendorLabel = new QLabel(MonitorTab);
     VendorLabel->setGeometry(10, 70, 100, 25);
     VendorLabel->setText(Locale(6));

    VendorNameLine = new KLineEdit(MonitorTab);
     VendorNameLine->setGeometry(120, 70, 270, 25);

    QLabel *ModelLabel = new QLabel(MonitorTab);
     ModelLabel->setGeometry(10, 100, 100, 25);
     ModelLabel->setText(Locale(7));

    ModelNameLine = new KLineEdit(MonitorTab);
     ModelNameLine->setGeometry(120, 100, 270, 25);

    DPMS = new QCheckBox(MonitorTab);
     DPMS->setGeometry(10, 135, 380, 25);
     DPMS->setText(Locale(8));
     DPMS->setEnabled(FALSE);


   KPushButton *ScreenModesButton = new KPushButton(MonitorTab);
    ScreenModesButton->setText(Locale(12));
    ScreenModesButton->setGeometry(400, 70, 140, 25);
    ScreenModesButton->setIconSet(Icons->loadIcon("looknfeel", KIcon::Toolbar, KIcon::SizeSmall));


///Filling SCREEN tab

    QLabel *ScreenLabel = new QLabel(ScreenTab);
     ScreenLabel->setGeometry(10, 10, 230, 25);
     ScreenLabel->setText(Locale(11));

     ScreenCombo = new KComboBox(ScreenTab);
      ScreenCombo->setGeometry(10, 35, 380, 25);

   KPushButton *ChangeNameButtonScreen = new KPushButton(ScreenTab);
    ChangeNameButtonScreen->setText(Locale(5));
    ChangeNameButtonScreen->setGeometry(400, 35, 140, 25);
    ChangeNameButtonScreen->setIconSet(Icons->loadIcon("edit", KIcon::Toolbar, KIcon::SizeSmall));


    QLabel *MonitorLabel = new QLabel(ScreenTab);
     MonitorLabel->setGeometry(10, 70, 100, 25);
     MonitorLabel->setText(Locale(9));

    SecondMonitorCombo = new KComboBox(ScreenTab);
     SecondMonitorCombo->setGeometry(120, 70, 270, 25);




    QLabel *DeviceLabel = new QLabel(ScreenTab);
     DeviceLabel->setGeometry(10, 100, 100, 25);
     DeviceLabel->setText(Locale(10));

    DeviceCombo = new KComboBox(ScreenTab);
     DeviceCombo->setGeometry(120, 100, 270, 25);

   QTabWidget *DisplayTab = new QTabWidget(this);
    DisplayTab->setGeometry(10, 140, 550, 198);
    DisplayTab->insertTab(MonitorTab, Icons->loadIcon("display", KIcon::Toolbar, KIcon::SizeSmall), Locale(2));
    DisplayTab->insertTab(ScreenTab, Icons->loadIcon("laptop", KIcon::Toolbar, KIcon::SizeSmall), Locale(3));




     connect (MonitorCombo, SIGNAL(activated(int)), this, SLOT(Init()));
     connect (ScreenCombo, SIGNAL(activated(int)), this, SLOT(Init()));
     connect (VendorNameLine, SIGNAL(textChanged(const QString&)), this, SLOT(SaveVendorName()));
     connect (ModelNameLine, SIGNAL(textChanged(const QString&)), this, SLOT(SaveModelName()));
     connect (SecondMonitorCombo, SIGNAL(activated(int)), this, SLOT(SaveScreenMonitor()));
     connect (DeviceCombo, SIGNAL(activated(int)), this, SLOT(SaveScreenDevice()));
     connect (ScreenModesButton, SIGNAL(clicked()), this, SLOT(ScreenModeEditor()));
     connect (ChangeNameButtonMonitor, SIGNAL(clicked()), this, SLOT(ChangeMonitors()));
     connect (ChangeNameButtonScreen, SIGNAL(clicked()), this, SLOT(ChangeScreens()));
   RefreshMonitorCombo();
}

void MonitorWidget :: Init()
{
VendorNameLine->setText(X->GetValue(Xorg::Monitor, MonitorCombo->currentItem() + 1, "VendorName", 1));
ModelNameLine->setText(X->GetValue(Xorg::Monitor, MonitorCombo->currentItem() + 1, "ModelName", 1));

QString CurrentMonitor = X->GetValue(Xorg::Screen, ScreenCombo->currentItem() + 1, "Monitor", 1);


  for (int a = 0; a < SecondMonitorCombo->count(); a++)
   {
    if (SecondMonitorCombo->text(a) == CurrentMonitor) { SecondMonitorCombo->setCurrentItem(a); break; }
   }

QString CurrentDevice = X->GetValue(Xorg::Screen, ScreenCombo->currentItem() + 1, "Device", 1);

  for (int a = 0; a < DeviceCombo->count(); a++)
   {
    if (DeviceCombo->text(a) == CurrentDevice) { DeviceCombo->setCurrentItem(a); break; }
   }


}

void MonitorWidget :: RefreshMonitorCombo()
{
   MonitorCombo->clear();
   SecondMonitorCombo->clear();
   DeviceCombo->clear();
   ScreenCombo->clear();
   for (int a = 1; a <= X->CountSections(Xorg::Monitor); a++)
    {
     MonitorCombo->insertItem(X->GetValue(Xorg::Monitor, a, "Identifier", 1));
     SecondMonitorCombo->insertItem(X->GetValue(Xorg::Monitor, a, "Identifier", 1));
    }
   for (int a = 1; a <= X->CountSections(Xorg::Device); a++)
    {
     DeviceCombo->insertItem(X->GetValue(Xorg::Device, a, "Identifier", 1));
    }

   for (int a = 1; a <= X->CountSections(Xorg::Screen); a++)
    {
     ScreenCombo->insertItem(X->GetValue(Xorg::Screen, a, "Identifier", 1));
    }

Init();

}

void MonitorWidget :: SaveVendorName()
{
X->WriteValue(Xorg::Monitor, MonitorCombo->currentItem() + 1, "VendorName", VendorNameLine->text());
}

void MonitorWidget :: SaveModelName()
{
X->WriteValue(Xorg::Monitor, MonitorCombo->currentItem() + 1, "ModelName", ModelNameLine->text());
}

void MonitorWidget :: SaveScreenMonitor()
{
X->WriteValue(Xorg::Screen, ScreenCombo->currentItem() + 1, "Monitor", SecondMonitorCombo->text(SecondMonitorCombo->currentItem()));
}

void MonitorWidget :: SaveScreenDevice()
{
X->WriteValue(Xorg::Screen, ScreenCombo->currentItem() + 1, "Device", DeviceCombo->text(DeviceCombo->currentItem()));
}

void MonitorWidget :: ScreenModeEditor()
{
ScreenModesEditor *Editor = new ScreenModesEditor(this, X, MonitorCombo->currentItem() + 1);
Editor->exec();
}

void MonitorWidget :: ChangeMonitors()
{
ChangeEntriesDialog *Change = new ChangeEntriesDialog(this, X, ChangeEntriesDialog::Monitor);
Change->exec();
Init();
RefreshMonitorCombo();
Init();
}

void MonitorWidget :: ChangeScreens()
{
ChangeEntriesDialog *Change = new ChangeEntriesDialog(this, X, ChangeEntriesDialog::Screen);
Change->exec();
RefreshMonitorCombo();
Init();
}
