/***************************************************************************
 *   Copyright (C) 2006 by Tomasz Sałaciński   *
 *   distortion@vp.pl   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

//QT Includes
#include <qfile.h>

//KDE Includes
#include <kapplication.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <kiconloader.h>


//kX Generator Includes
#include "kxgenerator.h"
#include "properties.h"
#include "LayoutWriter.h"


static const char description[] =
    I18N_NOOP("X Configuration Utilitty");

static const char version[] = APPVERSION;

static KCmdLineOptions options[] =
{
    { "config-path <file>", I18N_NOOP("Path to configuration file, eg. \"/etc/X11/xorg.conf\""), 0 },
    { "video-path <file>", I18N_NOOP("Path to video drivers, eg. \"/usr/lib/xorg/modules/drivers/\" (default)"), 0 },
    { "input-path <file>", I18N_NOOP("Path to input drivers, eg. \"/usr/lib/xorg/modules/input/\" (default)"), 0 },
    { "hwconf-path <file>", I18N_NOOP("Path to hwconf file, eg. \"/etc/sysconfig/hwconf\" (default)"), 0 },
    { "layout-only", I18N_NOOP("Show only default layout dialog (needs to be root)"), 0 },

    KCmdLineLastOption
};

int main(int argc, char **argv)
{

    KAboutData about("kX Generator", I18N_NOOP(APPNAME), version, description,
    KAboutData::License_GPL, "(C) 2006 Tomasz Sałaciński", 0, 0, "distortion@vp.pl");
    about.addAuthor( "Tomasz Sałaciński", "Programming", "distortion@vp.pl" );
    about.addAuthor( "Andres Demmer", "Logo design", "kx.generator@andreas-demmer.de" );


    KCmdLineArgs::init(argc, argv, &about);
    KCmdLineArgs::addCmdLineOptions( options );
    KApplication app;
    kXGeneratorMain *mainWin = 0;

        // no session.. just start up normally
        KCmdLineArgs *args = KCmdLineArgs::parsedArgs();

    QString PathToXorg = XORGPATH;
    QString PathToVideo = VIDEOPATH;
    QString PathToInput = INPUTPATH;
    QString PathToHwconf = HWCONFPATH;


bool LayoutOnly = false;
if (args->isSet("layout-only")) { LayoutOnly = true; }

if (!args->getOption("config-path").isEmpty()) { PathToXorg = args->getOption("config-path"); }
if (!args->getOption("video-path").isEmpty()) { PathToVideo = args->getOption("video-path"); }
if (!args->getOption("input-path").isEmpty()) { PathToInput = args->getOption("input-path"); }
if (!args->getOption("hwconf-path").isEmpty()) { PathToHwconf = args->getOption("hwconf-path"); }

if (!QFile::exists(PathToXorg)) 
{
   KMessageBox::error(0, QString("Configuration file %1 doesn't exist. Please use --config-path command line option to modify configuration file path.").arg (PathToXorg),  "Error!");
   return 255;
}



if (!LayoutOnly)
{
        mainWin = new kXGeneratorMain(PathToXorg, PathToVideo, PathToInput, PathToHwconf);
        app.setMainWidget( mainWin );
        mainWin->show();
        args->clear();
    return app.exec();

}
else
{
LayoutWriter *Lay = new LayoutWriter(PathToXorg, PathToVideo, PathToInput, PathToHwconf);

return Lay->ReturnCode();

}






}

