/***************************************************************************
 *   Copyright (C) 2005 by Roland Weigert   *
 *   roweigert@t-online.de   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

/*This is the interface to playerengines
 There is only one instance of this running, so this will be defined in globals on startup*/

using namespace std;

#ifndef _PLAYERINTERFACE_H_
#define _PLAYERINTERFACE_H_

#include <iostream>

#include <qstring.h>
#include <qstringlist.h>
#include <qdir.h>
#include <qwidget.h>
#include <qgroupbox.h>
#include <qpushbutton.h>
#include <qlabel.h>
#include <qslider.h>
#include <qimage.h>

#include <kiconloader.h>
#include <kprocess.h>
#include <klocale.h>
#include <kapp.h>

#include "mplayerinterface.h"
#include "rcdatei.h"

class playerinterface : public QWidget
{
    Q_OBJECT
public:
    playerinterface();
    ~playerinterface();
    int addTrack(QString);
    int createList(QString);
    bool isplaying;
    bool ispaused;
    QString playingatm;
private:
    QGroupBox *mainlayout;
    QGroupBox *buttonlayout;
    QLabel *nowplayinglabel;
    QLabel *songtimelabel;
    QSlider *songtimeslider;
    QPushButton *pausebutton;
    QPushButton *stopbutton;
    QPushButton *nextbutton;
    QStringList songlist;
    QStringList::Iterator playdtrack;
    KProcess *playerProcess;
    QImage pausepic;
    QImage playpic;
    QImage stoppic;
    QImage nextpic;
    int songtime;
    QString songlengthstring;
    void closeEvent(QCloseEvent*);
    mplayerinterface *mplayerlink;
public slots:
    bool pauseplaying();
    void completestop();
    bool nextsong();
private slots:
    void sliderchstart();
    void sliderchend();
    void getsonglength(int);
    void getplayertime(int);
    void songend();
};



#endif //_PLAYERINTERFACE_H_
