/***************************************************************************
 *   Copyright (C) 2005 by Roland Weigert   *
 *   roweigert@t-online.de   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
using namespace std;

#ifndef _PROGRESS_H_
#define _PROGRESS_H_

#include <iostream>

#include <qstring.h>
#include <qwidget.h>
#include <qprogressbar.h>
#include <qpushbutton.h>
#include <qgroupbox.h>
#include <qlabel.h>
#include <klocale.h>
#include <kapp.h>
#include <qvbox.h>
#include <qdialog.h>
#include <qlayout.h>
#include <qimage.h>
#include <qiconset.h>
#include <qtimer.h>

#include <kprocess.h>
#include <kiconloader.h>


class progressinfo;
class progressinfoonly;
class progresswithbar;

//Motherwidget for all running processes
class progressmainwindow :  public QDialog
  {
    Q_OBJECT
  public:
    progressmainwindow(bool);
    ~progressmainwindow();
    bool userabort;
    int runningprogresses;
    bool iscancelled;
    bool multimode;
  private:
    QVBox *progresslayout;
    QVBox *taskslayout;
    QPushButton *cancelallbutton;
    QTimer *refreshtimer;
  public slots:
    progresswithbar * startProgress(QString,long,KProcess *);
    progresswithbar * startProgress(QString,long);
    progressinfo * startInfo(QString);
    progressinfoonly * startInfoOnly(QString);
    void killProgress(progresswithbar *);
    void killProgress(progressinfo *);
    void killProgress(progressinfoonly *);
    void cancelAll();
    void closeEvent(QCloseEvent*);
    void resizeprogresswindow();
    void refreshdialog();
  signals:
    void cancelprogresses();
    void cancelled();
  }
;

//Processes with a countable result
class progresswithbar : public QWidget
  {
    Q_OBJECT
  public:
    progresswithbar(QString,long,QWidget *,KProcess *);
    progresswithbar(QString,long,QWidget *);
    ~progresswithbar();
    bool iscancelled;
    void setProgress(long);
    QGroupBox *barbox;
    QGroupBox *line1box;
    QLabel *barlabel;
    QPushButton *cancelbutton;
    QProgressBar *bar;
    KProcess *progressedProcess;
    QTimer *refreshtimer;
  public slots:
    void cancelProcess();
  signals:
    void cancelled();
  }
;

//Processes that can only be shown as active
class progressinfo : public QWidget
  {
    Q_OBJECT
  public:
    progressinfo(QString,QWidget *,progressmainwindow *);
    ~progressinfo();
    void setText(QString);
    progressmainwindow *progresswindow;
    QGroupBox *infobox;
    QLabel *infolabel;
    QPushButton *cancelbutton;
    bool iscancelled;
    QTimer *refreshtimer;
  public slots:
    void cancelProcess();
    void refreshwidget();
  signals:
    void cancelled();
  }
;

//Processes that can only be shown as active without cancelbutton
class progressinfoonly : public QWidget
  {
    Q_OBJECT
  public:
    progressinfoonly(QString,QWidget *,progressmainwindow *);
    ~progressinfoonly();
    void setText(QString);
    public slots:
    void refreshwidget();
    progressmainwindow *progresswindow;
    QGroupBox *infobox;
    QLabel *infolabel;
    QTimer *refreshtimer;
  }
;

#endif //_PROGRESS_H_

