#!/bin/bash
# build LabPlot RPM package on SuSE

if [ $# -ne 1 ]; then
	echo "Usage : ./build.SUSE.sh <version>"
	exit
fi

VERSION=$1
LVERSION=1.5.1.rc2
SPEC=LabPlot.SUSE-$VERSION.spec

export CFLAGS="-O2"
export CXXFLAGS="-O2"
################################
DIR=LabPlot-"$LVERSION"
SRC=LabPlot-"$LVERSION".tar.bz2

if [ ! -f "$SRC" ] ; then
	echo "$SRC not found!"
	exit
fi

if [ ! -f "$SPEC" ] ; then
	echo "$SPEC not found!"
	exit
fi

echo "%_topdir /tmp/build" > ~/.rpmmacros

mkdir -p /tmp/build/{SOURCES,SPECS,RPMS,SRPMS,BUILD} 

cp $SRC /tmp/build/SOURCES
cp $SPEC /tmp/build/SPECS

cd /tmp/build/SPECS/

rpmbuild -ba --buildroot /tmp/LabPlot $SPEC

