//LabPlot : CapabilityListDialog.h

#ifndef CAPABILITYLISTDIALOG_H
#define CAPABILITYLISTDIALOG_H

#include <qtextedit.h>
#include "ListDialog.h"

#ifdef HAVE_GSL
#include <gsl/gsl_multifit_nlin.h>
#endif

class CapabilityListDialog : public ListDialog
{
	Q_OBJECT
public:
	CapabilityListDialog(MainWin *mw, const char *name);
public slots:
	void setBins(int b) { binni->setValue(b); }
	void setLSL(double v) { lslle->setText(QString::number(v)); }
	void setUSL(double v) { uslle->setText(QString::number(v)); }
	void enableHistogram(bool e=true) { histcb->setChecked(e); }
	void enableFit(bool e=true) { fitcb->setChecked(e); }
	void enableLabel(bool e=true) { labelcb->setChecked(e); }
	QString Info() { return infote->text(); }
	int Apply() { return apply_clicked(); }
private:
#ifdef HAVE_GSL
        void print_state(int iter, gsl_multifit_fdfsolver * s);
#endif
	KIntNumInput *binni;
	KLineEdit *lslle, *uslle;
	QTextEdit *infote;
	QCheckBox *histcb, *fitcb, *labelcb;	
private slots:
	void saveSettings();
	int apply_clicked();
};

#endif // CAPABILITYLISTDIALOG_H
