//LabPlot : GraphList.cc

#include <stdio.h>
#include <iostream>
#include <kdebug.h>
#include "GraphList.h"

using namespace std;

GraphList::GraphList() {
	kdDebug()<<"GraphList()"<<endl;
	clear();
	kdDebug()<<"	NUMBER = "<<Number()<<endl;
}

void GraphList::clear() {
	nr2D = nr3D = nrM = nrGRASS = nr4D = nrIMAGE = nrL = 0;
	for (int i=0;i<7*MAX_NR;i++)
		id[i]=-1;
}

void GraphList::saveXML(QDomDocument doc, QDomElement root) {
	for (unsigned int i=0;i < Number();i++) {
		QDomElement tag = getGraph(i)->saveGraphXML(doc,getStruct(i));
   		root.appendChild( tag );
	}
}

/*void GraphList::openXML(QDomNode node, int type) {
	while(!node.isNull()) {
		QDomElement e = node.toElement();
		kdDebug()<<"GRAPH TAG = "<<e.tagName()<<endl;
		kdDebug()<<"GRAPH TEXT = "<<e.text()<<endl;

		// TODO : open graphs
		if(e.tagName() == "Graph")
			kdDebug()<<" GOT A GRAPH"<<endl;

		node = node.nextSibling();
	}
}*/

int GraphList::addGraph2D(Graph2D *g) {
//	kdDebug()<<"GraphList::addGraphX  Name = "<<g->Name()<<endl;
//	kdDebug()<<"GraphList::addGraphX : isNotFull() = "<<isNotFull()<<endl;
//	kdDebug()<<"GraphList::addGraphX : nr(2D,3D,M,GRASS,4D,IMAGE) = "<<endl;
//	kdDebug()<<nr2D<<' '<<nr3D<<' '<<nrM<<' '<<nrGRASS<<' '<<nr4D<<' '<<nrIMAGE<<endl;

	if(isNotFull() && nr2D<MAX_NR) {
		id[nr2D] = nr2D+nr3D+nrM+nr4D+nrIMAGE+nrL;
		list2D[nr2D++] = *g;

		//kdDebug()<<"GraphList::addGraph2D : nr2D = "<<nr2D<<endl;
		return 1;
	}
	return 0;
}

int GraphList::addGraph3D(Graph3D *g) {
	if(isNotFull() && nr3D<MAX_NR) {
		id[MAX_NR+nr3D]=nr2D+nr3D+nrM+nr4D+nrIMAGE+nrL;
		list3D[nr3D++] = *g;

		kdDebug()<<"GraphList::addGraph3D : id["<<MAX_NR+nr3D-1<<"] = "<<endl;
		kdDebug()<<id[MAX_NR+nr3D-1]<<endl;
		kdDebug()<<"Type = "<<g->Type()<<endl;
		kdDebug()<<"Type = "<<list3D[nr3D-1].Type()<<endl;

		return 1;
	}
	return 0;
}

int GraphList::addGraphM(GraphM *g) {
	if(isNotFull() && nrM<MAX_NR) {
		id[2*MAX_NR+nrM]=nr2D+nr3D+nrM+nr4D+nrIMAGE+nrL;
		listM[nrM++] = *g;

		kdDebug()<<"GraphList::addGraphM : id["<<2*MAX_NR+nrM-1<<"] = "<<id[2*MAX_NR+nrM-1]<<endl;
		kdDebug()<<"Type = "<<g->Type()<<endl;
		kdDebug()<<"Type = "<<listM[nrM-1].Type()<<endl;

		return 1;
	}
	return 0;
}

int GraphList::addGraph4D(Graph4D *g) {
	if(isNotFull() && nr4D<MAX_NR) {
		id[5*MAX_NR+nr4D]=nr2D+nr3D+nrM+nr4D+nrIMAGE+nrL;
		list4D[nr4D++] = *g;

		kdDebug()<<"GraphList::addGraph4D : id["<<5*MAX_NR+nr4D-1<<"] = "<<endl;
		kdDebug()<<id[5*MAX_NR+nr4D-1]<<endl;
		kdDebug()<<"Type = "<<g->Type()<<endl;
		kdDebug()<<"Type = "<<list4D[nr4D-1].Type()<<endl;

		return 1;
	}
	return 0;
}

int GraphList::addGraphIMAGE(GraphIMAGE *g) {
	if(isNotFull() && nrIMAGE<MAX_NR) {
		id[6*MAX_NR+nrIMAGE]=nr2D+nr3D+nrM+nr4D+nrIMAGE+nrL;
		listIMAGE[nrIMAGE++] = *g;

		kdDebug()<<"GraphList::addGraphIMAGE : id["<<6*MAX_NR+nrIMAGE-1<<"] = "<<endl;
		kdDebug()<<id[6*MAX_NR+nrIMAGE-1]<<endl;
		kdDebug()<<"Type = "<<g->Type()<<endl;
		kdDebug()<<"Type = "<<listIMAGE[nrIMAGE-1].Type()<<endl;

		return 1;
	}
	return 0;
}

int GraphList::addGraphL(GraphL *g) {
	if(isNotFull() && nrL < MAX_NR) {
		id[7*MAX_NR+nr4D]=nr2D+nr3D+nrM+nr4D+nrIMAGE+nrL;
		listL[nrL++] = *g;

		kdDebug()<<"GraphList::addGraphL : id["<<7*MAX_NR+nrL-1<<"] = "<<endl;
		kdDebug()<<id[7*MAX_NR+nrL-1]<<endl;
		kdDebug()<<"Type = "<<g->Type()<<endl;
		kdDebug()<<"Type = "<<listL[nrL-1].Type()<<endl;

		return 1;
	}
	return 0;
}

int GraphList::delGraph(unsigned int index) {
	unsigned int i=index, did;

	//kdDebug()<<"GraphList::delGraph : index = "<<index<<endl;

	if(index <= nr2D+nr3D+nrM+nr4D+nrIMAGE+nrL) {
		GRAPHType s = getStruct(index);
		did=((int)s)*MAX_NR+index;      // deleted index in id[]
		switch (s) {
		case GRAPH2D:
			nr2D--;
			while (i<nr2D) {
				list2D[i] = list2D[i+1];
				i++;
			}
			break;
		case GRAPH3D:
			nr3D--;
			while (i<nr3D) {
				list3D[i] = list3D[i+1];
				i++;
			}
			break;
		case GRAPHM:
			nrM--;
			while (i<nrM) {
				listM[i] = listM[i+1];
				i++;
			}
			break;
		case GRAPH4D:
			nr4D--;
			while (i<nr4D) {
				list4D[i] = list4D[i+1];
				i++;
			}
			break;
		case GRAPHIMAGE:
			nrIMAGE--;
			while (i<nrIMAGE) {
				listIMAGE[i] = listIMAGE[i+1];
				i++;
			}
			break;
		case GRAPHL:
			nrL--;
			while (i<nrL) {
				listL[i] = listL[i+1];
				i++;
			}
			break;
		default:
			break;
		}	

                // decrement all id values above the deleted id (did)
//              kdDebug()<<"    id[]="<<id[did]<<endl;
                for(int j=0;j<MAX_NR*NR_TYPES;j++) {
                        if(id[j]>id[did])
                                id[j]=id[j]-1;
                }

//		kdDebug()<<"GraphList::delGraph : nr(2D,3D,M,4D,IMAGE) = "<<endl;
//		kdDebug()<<nr2D<<' '<<nr3D<<' '<<nrM<<' '<<nr4D<<''<<nrIMAGE<<endl;

		return 1;
	}
	return 0;
}

GRAPHType GraphList::getStruct(int index) {
	for(int i=0;i<MAX_NR;i++) {
		//printf("\ti=%d, id[i]=%d,id[i+MAX_NR]=%d,id[i+2*MAX_NR]=%d\n",
		//		i,id[i],id[i+MAX_NR],id[i+2*MAX_NR]);

		if (id[i] == index) {
			return GRAPH2D;
		}
		else if (id[MAX_NR+i] == index) {
			return GRAPH3D;
		}
		else if (id[2*MAX_NR+i] == index) {
			return GRAPHM;
		}
		else if (id[3*MAX_NR+i] == index) {
			return GRAPH2D;	// was GRASS
		}
		else if (id[4*MAX_NR+i] == index) {
			return GRAPH2D;	// was VTK
		}
		else if (id[5*MAX_NR+i] == index) {
			return GRAPH4D;
		}
		else if (id[6*MAX_NR+i] == index) {
			return GRAPHIMAGE;
		}
		else if (id[7*MAX_NR+i] == index) {
			return GRAPHL;
		}
	}
	return GRAPH2D;	//default return
}

int GraphList::Index(int index) {
	for(int i=0;i<MAX_NR;i++) {
		if (id[i] == index || id[MAX_NR+i] == index || id[2*MAX_NR+i] == index || id[3*MAX_NR+i] == index ||
			id[4*MAX_NR+i] == index || id[5*MAX_NR+i] == index || id[6*MAX_NR+i] == index ||
			id[7*MAX_NR+i] == index	) {
			return i;
		}
	}
	return 0;
}

Graph *GraphList::getGraph(unsigned int i) {
	kdDebug()<<"GraphList::getGraph(i) i="<<i<<endl;
	if(i <= nr2D+nr3D+nrM+nr4D+nrIMAGE+nrL) {
		GRAPHType s = getStruct(i);
		kdDebug()<<"Graph Struct = "<<s<<endl;
		//kdDebug()<<"Index = "<<Index(i)<<endl;
		switch (s) {
		case GRAPH2D: return (Graph *) &list2D[Index(i)]; break;
		case GRAPH3D: return (Graph *) &list3D[Index(i)]; break;
		case GRAPHM: return (Graph *) &listM[Index(i)]; break;
		case GRAPH4D: return (Graph *) &list4D[Index(i)]; break;
		case GRAPHIMAGE: return (Graph *) &listIMAGE[Index(i)]; break;
		case GRAPHL: return (Graph *) &listL[Index(i)]; break;
		default: break;
		}
	}
	return 0;
}

Graph2D *GraphList::getGraph2D(int i) {
	if (i >= Index(i))
		return &list2D[Index(i)];
	return 0;
}	

Graph3D *GraphList::getGraph3D(int i) {
	if (i >= Index(i))
		return &list3D[Index(i)];
	return 0;
}	

GraphM *GraphList::getGraphM(int i) {
	if (i >= Index(i))
		return &listM[Index(i)];
	return 0;
}	

Graph4D *GraphList::getGraph4D(int i) {
	if (i >= Index(i))
		return &list4D[Index(i)];
	return 0;
}	

GraphIMAGE *GraphList::getGraphIMAGE(int i) {
	if (i >= Index(i))
		return &listIMAGE[Index(i)];
	return 0;
}	

GraphL *GraphList::getGraphL(int i) {
	if (i >= Index(i))
		return &listL[Index(i)];
	return 0;
}	

