//LabPlot : HistListDialog.h

#ifndef HISTLISTDIALOG_H
#define HISTLISTDIALOG_H

#include "ListDialog.h"

class HistListDialog : public ListDialog
{
	Q_OBJECT
public:
	HistListDialog(MainWin *mw, const char *name);
public slots:
	void setRange(double a, double b) {			//!< set range for histogram
		ale->setText(QString::number(a)); ble->setText(QString::number(b)); }
	void setFrom(double v) { ale->setText(QString::number(v)); }
	void setTo(double v) { ble->setText(QString::number(v)); }
	void setBins(int bin) { binni->setValue(bin); }		//!< set number of bins
	int Apply() { return apply_clicked(); }
private:
	KIntNumInput *binni;
private slots:
	void saveSettings();
	int apply_clicked();
};

#endif // HISTLISTDIALOG_H
