//LabPlot : IntegrationListDialog.cc

#include "IntegrationListDialog.h"

using namespace std;

IntegrationListDialog::IntegrationListDialog(MainWin *mw, const char *name)
	: ListDialog(mw, name)
{
	setCaption(i18n("Integration Dialog"));
	KConfig *config = mw->Config();
	config->setGroup( "Integration" );

	Plot *plot=0;
	if(p)
		plot = p->getPlot(p->API());

	// TODO : check for p==0

	QTabWidget *tw = new QTabWidget(vbox);
	QVBox *tab1 = new QVBox(tw);

	QHBox *hb = new QHBox(tab1);
	regioncb = new QCheckBox(i18n("use Region "),hb);
	if(plot && plot->RegionMin() != plot->RegionMax() )
		regioncb->setChecked(config->readBoolEntry("Region",true));
	else
		regioncb->setChecked(false);
	new QLabel(i18n("( From "),hb);
	double from, to;
	if (s) {
		from=0;
		to=s->Table()->numRows();
	}
	else {
		from = plot->RegionMin();
		to = plot->RegionMax();
	}
	regionminle = new KLineEdit(QString::number(from),hb);
	regionminle->setValidator(new QDoubleValidator(regionminle));
	new QLabel(i18n(" To "),hb);
	regionmaxle = new KLineEdit(QString::number(to),hb);
	regionmaxle->setValidator(new QDoubleValidator(regionmaxle));
	new QLabel(i18n(" )"),hb);

	hb = new QHBox(tab1);
	areacb = new QCheckBox(i18n("Sum absolute values (area)"),hb);
	areacb->setChecked(config->readBoolEntry("Sum",false));
	hb = new QHBox(tab1);
	baselinecb = new QCheckBox(i18n("Use Baseline @ y = "),hb);
	baselinecb->setChecked(config->readBoolEntry("Baseline",false));
	double baseline=0;
	if(p)
		baseline = plot->Baseline();
	baselinele = new KLineEdit(QString::number(baseline),hb);
	baselinele->setValidator(new QDoubleValidator(baselinele));

	hb = new QHBox(tab1);
	addgraph = new QCheckBox(i18n("Add Graph"),hb);
	addgraph->setChecked(config->readBoolEntry("AddGraph",true));
	infocb = new QCheckBox(i18n("Show Info"),hb);
	infocb->setChecked(config->readBoolEntry("ShowInfo",true));

	Style *style=0;
	Symbol *symbol=0;
	QVBox *styletab;
	if(p && p->getPlot(p->API())->Type() == PSURFACE)
		styletab = surfaceStyle(tw,true);
	else
		styletab = simpleStyle(tw, style, symbol);

	tw->addTab(tab1,i18n("Parameter"));
	tw->addTab(styletab,i18n("Style"));

	QObject::connect(ok,SIGNAL(clicked()),SLOT(ok_clicked()));
        QObject::connect(apply,SIGNAL(clicked()),SLOT(apply_clicked()));
	QObject::connect(save,SIGNAL(clicked()),SLOT(saveSettings()));

	setMinimumWidth(vbox->minimumSizeHint().width());
	setMinimumHeight(gbox->minimumSizeHint().height()+vbox->minimumSizeHint().height());
	resize(minimumSize());
}

void IntegrationListDialog::saveSettings() {
	KConfig *config = mw->Config();
	config->setGroup( "Integration" );

	config->writeEntry("Region",regioncb->isChecked());
	config->writeEntry("Sum",areacb->isChecked());
	config->writeEntry("Baseline",baselinecb->isChecked());
	config->writeEntry("AddGraph",addgraph->isChecked());
	config->writeEntry("ShowInfo",infocb->isChecked());
}

int IntegrationListDialog::apply_clicked() {
	double sum=0, baseline = baselinele->text().toDouble();
	
	if(s) {
		QTable *table = s->Table();
		int col = table->currentColumn();
		
		// add column if needed
		bool empty=true;
		for(int i=0;i<table->numRows();i++) {
			if(!table->text(i,table->numCols()-1).isEmpty())
				empty =false;
		}
		if (!empty)
			s->addColumn();

		int newcol = table->numCols()-1;
		for (int i = regionminle->text().toInt() ;i<regionmaxle->text().toInt() ;i++) {
			double y1 = table->text(i,col).toDouble(), y2 = table->text(i+1,col).toDouble();
			if (baselinecb->isChecked()) {
				y1 -= baseline;
				y2 -= baseline;
			}	

			double area = (y1+y2)/2.0;
			
			if (areacb->isChecked())
				sum += fabs(area);
			else
				sum += area;
				
			// insert into last column
			table->setText(i,newcol,QString::number(sum));
		}
		return 0;
	}
	
	GraphList *gl = p->getPlot(p->API())->getGraphList();
	if(gl->Number()==0) {
		KMessageBox::error(this,i18n("No graph found!"));
		return -2;
	}

	if (baselinecb->isChecked()) {
		p->getPlot(p->API())->setBaseline(baseline);
	}
	
	int item = (int) (lv->itemPos(lv->currentItem())/lv->currentItem()->height());

	GRAPHType st = gl->getStruct(item);
	
	Style *style=0;
	Symbol *symbol=0;
	if(st != GRAPHM) {
		style = new Style(cb2->currentItem(),color->color(),filled->isChecked(),fcolor->color(),
			width->value(),pencb->currentItem(),brushcb->currentItem());
		style->setBoxWidth(boxwidth->value());
		style->setAutoBoxWidth(autobox->isChecked());
		style->setPointsSorting(sortpointscb->isChecked());
		symbol = new Symbol((SType)symbolcb->currentItem(),scolor->color(),ssize->value(),
			(FType)symbolfillcb->currentItem(),sfcolor->color(),sbrushcb->currentItem());
	}

	double xmin=0, xmax=1, ymin=0, ymax=1, zmin=0, zmax=1, tmin=0, tmax=1;
	if (st == GRAPH2D) {
		Graph2D *g = gl->getGraph2D(item);
		int nx = g->Number();
		Point *ptr = new Point[nx];
		Point *a = g->Data();
		int n=0;

		for (int i = 0;i<nx-1;i++) {
			if (regioncb->isChecked() && (a[i].X()<regionminle->text().toDouble() ||
				a[i+1].X()>regionmaxle->text().toDouble() || a[i].Masked() )) {
				continue;
			}
			double y1 = a[i].Y(), y2 = a[i+1].Y();
			if (baselinecb->isChecked()) {
				y1 -= baseline;
				y2 -= baseline;
			}	
			double area = (y1+y2)/2.0*(a[i+1].X()-a[i].X());
			
			if (areacb->isChecked())
				sum += fabs(area);
			else
				sum += area;
			
			double x = (a[i].X()+a[i+1].X())/2;
			double y = sum;
			
			ptr[n++].setPoint(x,y);
		}

		if (addgraph->isChecked()) {
			mw->calculateRanges2D(ptr,n,&xmin,&xmax,&ymin,&ymax);
			
			LRange range[2];
			range[0] = LRange(xmin,xmax);
			range[1] = LRange(ymin,ymax);

			QString fun = QString(i18n("integration of")+QString(" ")+g->getLabel()->simpleTitle());

			Graph2D *ng = new Graph2D(fun,fun,range,SSPREADSHEET,P2D,style,symbol,ptr,n);
			mw->addGraph2D(ng,sheetcb->currentItem());
		}
	}
	else if (st == GRAPH3D) {
		Graph3D *g = gl->getGraph3D(item);
		int nx = g->Number();
		Point3D *ptr = new Point3D[nx];
		Point3D *a = g->Data();
		int n=0;

		for (int i = 0;i<nx-1;i++) {
			if (regioncb->isChecked() && (a[i].X()<regionminle->text().toDouble() ||
				a[i+1].X()>regionmaxle->text().toDouble() || a[i].Masked() )) {
				continue;
			}
			double y1 = a[i].Y(), y2 = a[i+1].Y();
			if (baselinecb->isChecked()) {
				y1 -= baseline;
				y2 -= baseline;
			}
			double area = (y1+y2)/2.0*(a[i+1].X()-a[i].X());
			
			if (areacb->isChecked())
				sum += fabs(area);
			else
				sum += area;
			
			double x = (a[i].X()+a[i+1].X())/2;
			double y = sum;
			double z = a[i].Z();
			
			ptr[n++].setPoint(x,y,z);
		}
		

		if (addgraph->isChecked()) {
			mw->calculateRanges3D(ptr,n,&xmin,&xmax,&ymin,&ymax,&zmin,&zmax);
			
			LRange range[3];
			range[0] = LRange(xmin,xmax);
			range[1] = LRange(ymin,ymax);
			range[2] = LRange(zmin,zmax);

			QString fun = QString(i18n("integration of")+QString(" ")+g->getLabel()->simpleTitle());

			Graph3D *ng = new Graph3D(fun,fun,range,SSPREADSHEET,type,style,symbol,ptr,n,1);
			ng->setNumberX(n);
			ng->setNumberY(g->NY());
			mw->addGraph3D(ng,sheetcb->currentItem(),type);
		}
	}
	else if (st == GRAPH4D) {
		Graph4D *g = gl->getGraph4D(item);
		int nx = g->Number();
		Point4D *ptr = new Point4D[nx];
		Point4D *a = g->Data();
		int n=0;

		for (int i = 0;i<nx-1;i++) {
			if (regioncb->isChecked() && (a[i].X()<regionminle->text().toDouble() ||
				a[i+1].X()>regionmaxle->text().toDouble() || a[i].Masked() )) {
				continue;
			}
			double y1 = a[i].Y(), y2 = a[i+1].Y();
			if (baselinecb->isChecked()) {
				y1 -= baseline;
				y2 -= baseline;
			}
			double area = (y1+y2)/2.0*(a[i+1].X()-a[i].X());
			
			if (areacb->isChecked())
				sum += fabs(area);
			else
				sum += area;
			
			double x = (a[i].X()+a[i+1].X())/2;
			double y = sum;
			double z = a[i].Z();
			double t = a[i].T();
			
			ptr[n++].setPoint(x,y,z,t);
		}

		if (addgraph->isChecked()) {
			mw->calculateRanges4D(ptr,n,&xmin,&xmax,&ymin,&ymax,&zmin,&zmax,&tmin,&tmax);
			
			LRange range[4];
			range[0] = LRange(xmin,xmax);
			range[1] = LRange(ymin,ymax);
			range[2] = LRange(zmin,zmax);
			range[3] = LRange(tmin,tmax);

			QString fun = QString(i18n("integration of")+QString(" ")+g->getLabel()->simpleTitle());

			Graph4D *ng = new Graph4D(fun,fun,range,SSPREADSHEET,type,style,symbol,ptr,n,g->GType());
			mw->addGraph4D(ng,sheetcb->currentItem());
		}
	}

	updateList();

	QString info(i18n(" cummulative sum : ")+QString::number(sum));
	if (baselinecb->isChecked())
		info += i18n("\nwith baseline y = ")+QString::number(baseline);
	if (regioncb->isChecked()) {
		double minx = regionminle->text().toDouble();
		double maxx = regionmaxle->text().toDouble();
		info += i18n("\nwith region x = ")+QString::number(minx)+QString(" .. ")+ QString::number(maxx);

		p->getPlot(p->API())->setRegionMin(minx);
		p->getPlot(p->API())->setRegionMax(maxx);
	}

	result = info;
	if (infocb->isChecked())
		KMessageBox::information(0,info);

	return 0;
}
