//LabPlot : PeakListDialog.h

#ifndef PEAKLISTDIALOG_H
#define PEAKLISTDIALOG_H

#include "ListDialog.h"

class PeakListDialog : public ListDialog
{
	Q_OBJECT
public:
	PeakListDialog(MainWin *mw, const char *name);
public slots:
	void setThreshold(double t) { thresholdle->setText(QString::number(t)); }	//!< set threshold for peaks
	void setAccuracy(int a) { accuni->setValue(a); }			//!< set accurary for peaks
	void searchNegative(bool n=true) { negativecb->setChecked(n); }		//!< search for negative peaks
	void enableNegativePeaks(bool e=true) { searchNegative(e); }
	int Apply() { return apply_clicked(); }
private:
	KLineEdit *thresholdle;
	KIntNumInput *accuni;
	QCheckBox *negativecb;
private slots:
	void saveSettings();
	int apply_clicked();
};

#endif // PEAKLISTDIALOG_H
