//LabPlot : SpreadsheetValuesDialog.cc

#include <stdlib.h>
#include <stdio.h>
#include <iostream>
#include <math.h>
#include <qlabel.h>
#include <qhbox.h>
#include <qfontdialog.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <kconfig.h>
#include "SpreadsheetValuesDialog.h"
#include "LTableItem.h"
#include "defs.h"

#include "parser_struct.h"
extern "C" con constants[];
extern "C" init arith_fncts[];

SpreadsheetValuesDialog::SpreadsheetValuesDialog(MainWin *mw, QTable *t, const char *name)
	: Dialog(mw, name), table(t)
{
	setCaption(QString("Spreadsheet")+i18n(" : ")+QString(name));

	QHBox *hb = new QHBox(vbox);
	columnlabel = new QLabel(i18n("Changing Column ") + i18n(" of ") + mw->activeSpreadsheet()->Title() + QString(" : "),hb);
	hb = new QHBox(vbox);

	// use selected range / max range
	int min=1,max = table->numRows();
	QTableSelection sel = table->selection(table->currentSelection());
	if (sel.isActive()) {
		min = sel.topRow()+1;
		max = sel.bottomRow()+1;
	}
	new QLabel(i18n("Range : "),hb);
	ani = new KIntNumInput(min,hb);
	ani->setRange(1,INF,1,false);
	new QLabel(i18n(" to "),hb);
	bni = new KIntNumInput(max,hb);
	bni->setRange(1,INF,1,false);
	
	hb = new QHBox(vbox);
	new QLabel(i18n("Columns :"),hb);
	colcb = new KComboBox(hb);
	for(int i=0; i < fmin(table->numCols(),MAX_COLS); i++) {
		if(i<26)
			colcb->insertItem(QString("col(")+QChar(65+i)+
				") ["+mw->activeSpreadsheet()->columnTitle(i)+"]");
		else
			colcb->insertItem(QString("col(")+QChar(65+i/26-1)+QString(QChar(65+i%26))+") [" +
				mw->activeSpreadsheet()->columnTitle(i)+"]");
	}
	QObject::connect(colcb,SIGNAL(activated(int)),SLOT(insertColumn(int)));

	hb = new QHBox(vbox);
	new QLabel(i18n("Constants :"),hb);
	concb = new KComboBox(hb);
	int f=0;
	QString tmp=0;
	while(true){
		tmp = constants[f++].name;
		if(tmp.isEmpty())
			break;
		concb->insertItem(tmp);
	};
	QObject::connect(concb,SIGNAL(activated(int)),SLOT(insertConstant(int)));
	
	hb = new QHBox(vbox);
	new QLabel(i18n("Functions :"),hb);
	selcb = new KComboBox(hb);
	f=0;
	while(true){
		tmp = arith_fncts[f++].fname;
		if(tmp.isEmpty())
			break;
		selcb->insertItem(tmp+"()");
	}
	QObject::connect(selcb,SIGNAL(activated(int)),SLOT(insertFunction(int)));

	hb = new QHBox(vbox);
	new QLabel(i18n(" Expression (index : i, col(A,i) = col(A)) : "),hb);
	
	hb = new QHBox(vbox);
	funcb = new KComboBox(hb);
	funcb->setEditable(true);
	
	int col = table->currentColumn();
	KConfig *config = mw->Config();
	config->setGroup( "Spreadsheet" );
	QString expr = config->readEntry(QString("expression%1").arg(col),"sin(col(A))");
	funcb->insertItem(expr);		// active expr
	for(int i=0;i<2000;i++) {	// 1000 columns+1000 old entries
		if(i==col) continue;	// already in first item

		QString entry = config->readEntry(QString("expression%1").arg(i),"");

		// check for duplicate items
		bool expr_found=false;
		for(int j=0;j<fmin(i,MAX_COLS);j++) {
			QString tmp = config->readEntry(QString("expression%1").arg(j),"");
			if (tmp==entry) {
				expr_found=true;
				break;
			}
		}

		if(!entry.isEmpty() && !expr_found)
			funcb->insertItem(entry);
        }

	QObject::connect(ok,SIGNAL(clicked()),SLOT(ok_clicked()));
	QObject::connect(apply,SIGNAL(clicked()),SLOT(apply_clicked()));
	cancel->setText(i18n("Close"));
	save->hide();

	updateDialog();
	
	setMinimumWidth(vbox->minimumSizeHint().width());
	setMinimumHeight(gbox->minimumSizeHint().height()+vbox->minimumSizeHint().height());
	resize(minimumSize());
}

void SpreadsheetValuesDialog::updateDialog() {
	columnlabel->setText(i18n("Changing Column ") + s->columnTitle(table->currentColumn()) + i18n(" of ") + s->Title() + QString(" : "));
}

void SpreadsheetValuesDialog::insertColumn(int i) {
	QLineEdit *le = funcb->lineEdit();
	QString text = le->text();
	int pos = le->cursorPosition();
	
	if(i>MAX_COLS)
		return;
	
	// col(A)
	QString tmp("col()");
	if(i<26)
		tmp.insert(tmp.length()-1,QChar(65+i));
	else
		tmp.insert(tmp.length()-2,QString(QChar(65+i/26-1)) + QString(QChar(65+i%26)));
	text.insert(pos,tmp);
	le->setText(text);
	le->setCursorPosition(pos+tmp.length());
}

void SpreadsheetValuesDialog::insertConstant(int i) {
	QLineEdit *le = funcb->lineEdit();
	QString text = le->text();
	int pos = le->cursorPosition();
	QString c = constants[i].name;
	text.insert(pos,c);
	le->setText(text);
	le->setCursorPosition(pos+c.length());
}

void SpreadsheetValuesDialog::insertFunction(int i) {
	QLineEdit *le = funcb->lineEdit();
	QString text = le->text();
	int pos = le->cursorPosition();
	QString c = arith_fncts[i].fname;
	text.insert(pos,c+"()");
	le->setText(text);
	le->setCursorPosition(pos+c.length()+2);
}

void SpreadsheetValuesDialog::apply_clicked() {
	QString expr = funcb->currentText();
		
	int startRow = ani->value(), endRow = bni->value();

	if(!expr.isEmpty())
		mw->activeSpreadsheet()->setValues(startRow,endRow,expr);
}
