/*
 *   LADCCA
 *    
 *   Copyright (C) 2002 Robert Ham <rah@bash.sh>
 *    
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __LADCCA_INTERNAL_H__
#define __LADCCA_INTERNAL_H__

#include <alsa/asoundlib.h>
#include <uuid/uuid.h>

#include <ladcca/types.h>

#define set_string_property(property, value) \
  \
  if (property) \
    free (property); \
  \
  if (value) \
    (property) = cca_strdup (value); \
  else \
    (property) = NULL;


typedef struct _cca_comm_event cca_comm_event_t;
typedef struct _cca_comm cca_comm_t;

enum CCA_Internal_Client_Flag
  {
    CCA_Saved              =  0x01000000,  /* client has been saved */
  };

struct _cca_config
{
  char * key;
  void * value;
  size_t value_size;
};

struct _cca_event
{
  enum CCA_Event_Type  type;
  char                *string;
  char                *project;
  uuid_t               client_id;
};

struct _cca_exec_params
{
  int    flags;
  int    argc;
  char **argv;
  char  *working_dir;
  char  *server;
  char  *project;
  uuid_t id;
};

struct _loader
{
  int   server_socket;
  int   loader_socket;
  pid_t loader_pid;
};

/*snd_seq_port_subscribe_t * cca_event_get_string_alsa_patch (cca_event_t * event);
cca_jack_patch_t *         cca_event_get_string_jack_patch (cca_event_t * event); */

void cca_config_init (struct _cca_config * config);
void cca_config_free (struct _cca_config * config);

void cca_event_init (struct _cca_event * event);
void cca_event_free (struct _cca_event * event);



#endif /* __LADCCA_INTERNAL_H__ */
