/*
 *   LADCCA
 *    
 *   Copyright (C) 2002 Robert Ham <rah@bash.sh>
 *    
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __LADCCAD_SERVER_EVENT_H__
#define __LADCCAD_SERVER_EVENT_H__

#include <uuid/uuid.h>

#include <ladcca/ladcca.h>
#include <ladcca/internal_headers.h>

enum Server_Event_Type
{
  Client_Connect = 1,
  Client_Disconnect,
  Client_Event,
  Client_Config,
  Client_Comm_Event
};

typedef struct _server_event server_event_t;

struct _server_event
{
  enum Server_Event_Type    type;
  unsigned long             conn_id;
  union
  {
    cca_connect_params_t *  cca_connect_params;
    cca_event_t *           cca_event;
    cca_config_t *          cca_config;
    cca_comm_event_t *      cca_comm_event;
  } data;
};

server_event_t * server_event_new ();
void             server_event_destroy ();

void server_event_set_type           (server_event_t * event, enum Server_Event_Type type);
void server_event_set_conn_id        (server_event_t * event, unsigned long id);
void server_event_set_cca_event      (server_event_t * event, cca_event_t * cca_event);
void server_event_set_cca_config     (server_event_t * event, cca_config_t * cca_config);
void server_event_set_cca_comm_event (server_event_t * event, cca_comm_event_t * cca_comm_event);
void server_event_set_cca_connect_params (server_event_t *, cca_connect_params_t * params);

cca_event_t *            server_event_take_cca_event          (server_event_t * event);
cca_config_t *           server_event_take_cca_config         (server_event_t * event);
cca_comm_event_t *       server_event_take_cca_comm_event     (server_event_t * event);
cca_connect_params_t *   server_event_take_cca_connect_params (server_event_t * event);

#endif /* __LADCCAD_SERVER_EVENT_H__ */
