<?php
/*
$Id: deletelink.php,v 1.1 2007/04/21 11:04:50 gruberroland Exp $

  This code is part of LDAP Account Manager (http://www.sourceforge.net/projects/lam)
  Copyright (C) 2007  Roland Gruber

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more detaexils.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

/**
* This page will redirect to delete.php if the given user is valid.
*
* It is called from the list views via the delete links.
*
* @package lists
* @author Roland Gruber
*/

/** security functions */
include_once("../../lib/security.inc");
/** Needed to find DNs of users */
include_once("../../lib/ldap.inc");
/** Used to display error messages */
include_once("../../lib/status.inc");

// start session
startSecureSession();

setlanguage();

// get account name and type
$dn = $_GET['DN'];
$type = $_GET['type'];

if (isset($dn) && isset($type)) {
	$dn = str_replace("\\", '',$dn);
	$dn = str_replace("'", '',$dn);
	$_SESSION['delete_dn'] = array($dn);
	// redirect to delete.php
	metaRefresh("../delete.php?type=" . $type);

}
else {
	// print error message if user was not found
	echo $_SESSION['header'];
	echo "<title>userlink</title>\n";
	echo "<link rel=\"stylesheet\" type=\"text/css\" href=\"../../style/layout.css\">\n";
	echo "</head><body>\n";
	StatusMessage("ERROR", "No account or type given.");
	echo ("</body></html>\n");
}

?>
