#!/bin/sh

led_ping () {
    if test "$USE_BACKGROUNDING" = YES -o "$USE_BACKGROUNDING" = yes; then
	# Use backgrounding:
	eval 'OLDPID=$LED_PING_PID_'$COUNT
	if test -z "$OLDPID" -o ! -e "/proc/$OLDPID" ; then
	    # Previous version has exited or none has been ever started yet.
	    (if ping -c 1 $1 1>/dev/null 2>/dev/null; then
		echo "$SUCCESS"
	    else
		echo "$FAILURE"
	    fi) &
	    OLDPID=$!
	    eval 'LED_PING_PID_'$COUNT'=$OLDPID'
	fi
	# Do nothing.
	SUCCESS="nop"
	return 0
    fi
    # Don't use backgrounding:
    ping -c 1 $1 1>/dev/null 2>/dev/null
}

