// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you want to add, delete, or rename functions or slots, use
** Qt Designer to update this file, preserving your code.
**
** You should not define a constructor or destructor in this file.
** Instead, write your code in functions called init() and destroy().
** These will automatically be called by the form's constructor and
** destructor.
*****************************************************************************/
// Author: Janusz SP9UMX <sp9umx@sr9zaa.ampr.org>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution

// QT
#include <qfontdialog.h>
#include <qcolordialog.h>
#include <qfile.h>
#include <qlineedit.h>
#include <qlabel.h>

#include "utils.h"
#include "newmsg.h"
//#include "readmsg.h"

// Classess
extern TAddrBook  *AddrBook;
extern TNewMsg    *NewMsg;

// Global variables
extern TAttrs FormAttrsTb[10];
extern QString PrgPath;

void TAddrBook::ColorBtnClick()
{
	QColor colorTmp = QColorDialog::getColor(AddrList->paletteBackgroundColor () );
	if (colorTmp.isValid() ) AddrList->setPaletteBackgroundColor( colorTmp );
    	UpdateFormAttrs();
}


void TAddrBook::FontBtnClick()
{
    	AddrList->setFont( QFontDialog::getFont( 0, AddrList->font() ) );
    	UpdateFormAttrs();
}



void TAddrBook::hideEvent( QHideEvent *e )
{
  QString tmp;
  int row;
  
  if ( ! e->spontaneous ()  )    UpdateFormAttrs();
  
  QFile fl ( PrgPath + "conf/Addrbook" );
  if ( fl.open( IO_WriteOnly ) )
  {
	  QTextStream stream ( &fl );
	  for (row = 0;row<=AddrList->numRows()-1;row++)
	  {
		  tmp =  AddrList->text(row, 0) + ";";
		  tmp += AddrList->text(row, 1) + ";";
		  tmp += AddrList->text(row, 2);
		  stream << tmp << "\n";
	  }
	  fl.close();   
  }
}


void TAddrBook::UpdateFormAttrs()
{
  QFontInfo fi (AddrList->font());
  QColor font_color(AddrList->foregroundColor());
  QColor background(AddrList->paletteBackgroundColor());
  
  FormAttrsTb[4].FontAttrs.Name      =  fi.family();
  FormAttrsTb[4].FontAttrs.Size      =  fi.pointSize();
  
  FormAttrsTb[4].FontAttrs.Color     =  font_color.name();
  FormAttrsTb[4].FontAttrs.Pitch     =  fi.fixedPitch();
  FormAttrsTb[4].FontAttrs.Bold      =  fi.bold();
  FormAttrsTb[4].FontAttrs.Italic    =  fi.italic();

  FormAttrsTb[4].FormAttrs.Color  =  AddrList->paletteBackgroundColor().name();
  FormAttrsTb[4].FormAttrs.x      =  AddrBook->x();
  FormAttrsTb[4].FormAttrs.y      =  AddrBook->y();
  FormAttrsTb[4].FormAttrs.height =  AddrBook->height();
  FormAttrsTb[4].FormAttrs.width  =  AddrBook->width();

}


void TAddrBook::showEvent( QShowEvent * e )
{
	
	QString tmp;
	int row,max_row;
	
	
  if ( ! e->spontaneous ()  )
  {
    QFont fi;
    QColor color; //(MsgList->paletteBackgroundColor());
  
  
    fi.setFamily(FormAttrsTb[4].FontAttrs.Name);
    fi.setPointSize(FormAttrsTb[4].FontAttrs.Size);
  
    fi.setFixedPitch(FormAttrsTb[4].FontAttrs.Pitch);
    fi.setBold(FormAttrsTb[4].FontAttrs.Bold);
    fi.setItalic(FormAttrsTb[4].FontAttrs.Italic);
    AddrList->setFont( fi );

    color.setNamedColor(FormAttrsTb[4].FormAttrs.Color);
    AddrList->setPaletteBackgroundColor(color);
    AddrList->setPaletteForegroundColor (FormAttrsTb[4].FontAttrs.Color); // Font Color
  
    move( FormAttrsTb[4].FormAttrs.x, FormAttrsTb[4].FormAttrs.y );
    resize( FormAttrsTb[4].FormAttrs.width, FormAttrsTb[4].FormAttrs.height );
  }

  
  if ( AddrList-> numRows() > 0 )
  {
	  AddrList->setCurrentCell(0,0);
	  max_row = AddrList->numRows();
	  for ( row=0; row <= max_row+1;row++)
		  AddrList->removeRow(0);
  }
 
  
  QFile fl ( PrgPath + "conf/Addrbook" );
  if ( fl.open( IO_ReadOnly ) )
  {
	  QTextStream stream ( &fl );
	  row = 0;

	  while ( ! stream.atEnd() )
	  {
		  tmp = stream.readLine();
		  if ( !tmp.isEmpty() )
		  {
		     	AddrList->insertRows(row,1);
			for (int p=0; p<=2 ; p++) AddrList->setText(row,p,tmp.section(';',p,p) ); 
		  	row++;
		  }
	  }
	  fl.close();
	  
	  for (int p=0; p<=2; p++) AddrList->adjustColumn(p);
  
  }
}


void TAddrBook::AddrListDblClick( int row, int , int  )
{
	NewMsg->ToEdt->setText( AddrList->text(row,1) );
	NewMsg->AtEdt->setText( AddrList->text(row,2) );
	AddrBook->close();
}


void TAddrBook::deleteRow( int row )
{

	//QMessageBox::information( this, "Title", "Delete row; " + QString::number(row) );
	AddrList->removeRow(row);
}


void TAddrBook::addRow( int row )
{
	//QMessageBox::information( this, "Title", "Add row: " + QString::number(row) );
	AddrList->insertRows(row,1);
}


void TAddrBook::contextMenuRequested( int row, int , const QPoint& )
{
	//AddrList->removeRow(row);
	int i;
	
	QPopupMenu* contextMenu = new QPopupMenu( this );
	Q_CHECK_PTR( contextMenu );
	QLabel *caption = new QLabel( "Address action", this );
	caption->setAlignment( Qt::AlignCenter );
	contextMenu->insertItem( caption );
	contextMenu->insertSeparator();
	i = contextMenu->insertItem( "&New address",  this, SLOT(addRow(int)) );
	contextMenu->setItemParameter ( i, row );
	i = contextMenu->insertItem( "&Delete address",  this, SLOT(deleteRow(int)));
	contextMenu->setItemParameter ( i, row );
	contextMenu->insertSeparator();
	contextMenu->insertItem( "Change Background &color",  this, SLOT(ColorBtnClick()) );
	contextMenu->insertItem( "Change &font",  this, SLOT(FontBtnClick()) );
	contextMenu->exec( QCursor::pos() );
	delete contextMenu;
}


