#include "mysql_backend.h"

#if HAVE_MYSQL

#include <syslog.h>

#include "global_vars.h"
#include "srv_def.h"

MYSQL *mysql_con = NULL;
char mysql_connected = 0; // bool
char mysql_available = 0; // bool

char sqlbe_query(const char *query_str)
{
	int tries;

	if ( !mysql_available ) return 1;
	if ( !mysql_connected ) sqlbe_reconnect();

	for ( tries = 2; tries--; )
	{
		if ( !mysql_query(mysql_con, query_str) )
			return 0; // success, finish.
		if ( mysql_errno(mysql_con) != CR_SERVER_GONE_ERROR )
		{
			#ifdef DEBUG
				syslog(LOG_WARNING, "mysql_backend: query '%s' failed: %s",
						query_str, mysql_error(mysql_con));
			#else
				syslog(LOG_WARNING, "mysql_backend: query failed: %s",
						mysql_error(mysql_con));
			#endif
			return 1; // failed
		}
		sqlbe_reconnect();
	}
	syslog(LOG_WARNING, "mysql_backend: query failed: %s",
					mysql_error(mysql_con));
	return 1;
}

char sqlbe_connected() { return mysql_connected; }
char sqlbe_available() { return mysql_available; }

char sqlbe_connect()
{
	#define CONS_WARN(s)	if ( !count ) fprintf(stderr, s);
	#define CONS_WARN2(s, a)	if ( !count ) fprintf(stderr, s, a);

	static int count = 0;

	if ( !count )
	{
		mysql_available = (*server->db_hostname != 0);

		if ( !mysql_available )
		{
			fprintf(stderr, "MySQL not configured!");
			return 1;
		}
	}

	if ( mysql_connected )
	{
		if ( mysql_con )
		{
			mysql_close(mysql_con);
			mysql_con = NULL;
		}
		mysql_connected = 0;
	}

	if ( !(mysql_con = mysql_init(NULL)) )
	{
		CONS_WARN("mysql_init(.) failed! MySQL logging not available.\n")
		count++;
		return 1;
	}
	
  	mysql_options(mysql_con,MYSQL_READ_DEFAULT_GROUP,LCS_MYSQL_DEFGROUP);

/* I get a segfault when using mysql_real_connect of libmysqlclient 10
 * Someone reported, that he got a segfault when using myslq_connect with
 * libmysqlclient version 12, but on my system this works. So if you experience
 * problems with libmysql, then just take the other of the two following code
 * lines and try again. Please report anything about that to S. Fuchs.
 */
/* 2.1.20: going to use mysql_real_connect by default as mysql_connect is not
 * supported any more by libmysqlclient of certain GNU/Linux distributions.
 */
	if ( !mysql_real_connect(mysql_con, server->db_hostname, server->db_user, server->db_pass, server->db_name, 0, NULL, 0) )
//	if ( !mysql_connect(mysql_con, server->db_hostname, server->db_user, server->db_pass) )
	{
		CONS_WARN2("Could not connect to the mysql database: %s\n", mysql_error(mysql_con))
		count++;
		return 1;
	}

	if ( mysql_select_db(mysql_con, server->db_name) )
	{
		CONS_WARN2("mysql_select_db('%s') failed!", server->db_name)
		syslog(LOG_ERR, "mysql_select_db('%s') failed! MySQL backend switched off.", server->db_name);
		sqlbe_cleanup();
		mysql_available = 0;
		// disable mysql completely:
		*server->db_hostname = 0;
	}

	CONS_WARN("MySQL logging initialised.\n")
	mysql_connected++;

	count++;
	return !mysql_connected;
}

char sqlbe_reconnect()
{
	if ( mysql_connected )
	{
		mysql_close(mysql_con);
		mysql_con = NULL;
		mysql_connected = 0;
	}
	return sqlbe_connect();
}

void sqlbe_cleanup()
{
	if ( mysql_connected )
	{
		mysql_close(mysql_con);
		mysql_con = NULL;
		mysql_connected = 0;
	}
}

#endif // HAVE_MYSQL
