/* Generated by GOB (v2.0.15)   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 15

#define selfp (self->_priv)

#include <string.h> /* memset() */

#include "lm-preferences-dialog.h"

#include "lm-preferences-dialog-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 34 "src/lm-preferences-dialog.gob"

#include <glib/gi18n.h>
#include "lm-util.h"
#include "lm-host-view.h"
#include "lm-non-linear-range.h"

#define MSECS(n)	(n)
#define SECS(n)		((n) * 1000)
#define MINS(n)		((n) * 60000)
#define HOURS(n)	((n) * 3600000)
#define DAYS(n)		((n) * 86400000)

static const LMNonLinearRangeBlock delay_blocks[] = {
  { MSECS(200),	MSECS(1000),	MSECS(100)	},
  { SECS(2),	SECS(10),	SECS(1)		}
};

static const LMNonLinearRangeBlock scale_blocks[] = {
  { MSECS(1),	MSECS(10),	MSECS(1)	},
  { MSECS(20),	MSECS(100),	MSECS(10)	},
  { MSECS(200),	MSECS(1000),	MSECS(100)	},
  { SECS(2),	SECS(5),	SECS(1)		}
};

const LMNonLinearRangeBlock lm_preferences_dialog_tooltip_graph_span_blocks[] = {
  { SECS(10),	SECS(60),	SECS(10)	},
  { MINS(2),	MINS(10),	MINS(1)		},
  { MINS(15),	MINS(60),	MINS(5)		},
  { HOURS(2),	HOURS(24),	HOURS(1)	},
  { DAYS(2),	DAYS(7),	DAYS(1)		}
};

const int lm_preferences_dialog_num_tooltip_graph_span_blocks = G_N_ELEMENTS(lm_preferences_dialog_tooltip_graph_span_blocks);

#line 61 "lm-preferences-dialog.c"
/* self casting macros */
#define SELF(x) LM_PREFERENCES_DIALOG(x)
#define SELF_CONST(x) LM_PREFERENCES_DIALOG_CONST(x)
#define IS_SELF(x) LM_IS_PREFERENCES_DIALOG(x)
#define TYPE_SELF LM_TYPE_PREFERENCES_DIALOG
#define SELF_CLASS(x) LM_PREFERENCES_DIALOG_CLASS(x)

#define SELF_GET_CLASS(x) LM_PREFERENCES_DIALOG_GET_CLASS(x)

/* self typedefs */
typedef LMPreferencesDialog Self;
typedef LMPreferencesDialogClass SelfClass;

/* here are local prototypes */
static void ___object_set_property (GObject *object, guint property_id, const GValue *value, GParamSpec *pspec);
static void ___object_get_property (GObject *object, guint property_id, GValue *value, GParamSpec *pspec);
#line 0 "src/lm-preferences-dialog.gob"
static void lm_preferences_dialog_init (LMPreferencesDialog * o);
#line 80 "lm-preferences-dialog.c"
#line 0 "src/lm-preferences-dialog.gob"
static void lm_preferences_dialog_class_init (LMPreferencesDialogClass * c);
#line 83 "lm-preferences-dialog.c"
#line 88 "src/lm-preferences-dialog.gob"
static void lm_preferences_dialog_constructor (LMPreferencesDialog * self);
#line 86 "lm-preferences-dialog.c"
#line 174 "src/lm-preferences-dialog.gob"
static void lm_preferences_dialog_update_selected_label (LMPreferencesDialog * self);
#line 89 "lm-preferences-dialog.c"
#line 197 "src/lm-preferences-dialog.gob"
static void lm_preferences_dialog_update_sensitivity (LMPreferencesDialog * self);
#line 92 "lm-preferences-dialog.c"
#line 217 "src/lm-preferences-dialog.gob"
static void lm_preferences_dialog_response_h (GtkDialog * dialog, int response, gpointer user_data);
#line 95 "lm-preferences-dialog.c"
#line 234 "src/lm-preferences-dialog.gob"
static gboolean lm_preferences_dialog_configure_event_h (GtkWidget * widget, GdkEventConfigure * event, gpointer user_data);
#line 98 "lm-preferences-dialog.c"

enum {
	PROP_0,
	PROP_APPLET
};

/* pointer to the class of our parent */
static LMDialogClass *parent_class = NULL;

/* Short form macros */
#define self_update_selected_label lm_preferences_dialog_update_selected_label
#define self_update_sensitivity lm_preferences_dialog_update_sensitivity
#define self_response_h lm_preferences_dialog_response_h
#define self_configure_event_h lm_preferences_dialog_configure_event_h
#define self_add_clicked_h lm_preferences_dialog_add_clicked_h
#define self_remove_clicked_h lm_preferences_dialog_remove_clicked_h
#define self_up_clicked_h lm_preferences_dialog_up_clicked_h
#define self_down_clicked_h lm_preferences_dialog_down_clicked_h
#define self_delay_scale_value_changed_h lm_preferences_dialog_delay_scale_value_changed_h
#define self_scale_scale_value_changed_h lm_preferences_dialog_scale_scale_value_changed_h
#define self_tooltip_graph_span_scale_value_changed_h lm_preferences_dialog_tooltip_graph_span_scale_value_changed_h
#define self_scale_format_value_h lm_preferences_dialog_scale_format_value_h
GType
lm_preferences_dialog_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (LMPreferencesDialogClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) lm_preferences_dialog_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (LMPreferencesDialog),
			0 /* n_preallocs */,
			(GInstanceInitFunc) lm_preferences_dialog_init,
			NULL
		};

		type = g_type_register_static (LM_TYPE_DIALOG, "LMPreferencesDialog", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((LMPreferencesDialog *)g_object_new(lm_preferences_dialog_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static LMPreferencesDialog * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static LMPreferencesDialog *
GET_NEW_VARG (const char *first, ...)
{
	LMPreferencesDialog *ret;
	va_list ap;
	va_start (ap, first);
	ret = (LMPreferencesDialog *)g_object_new_valist (lm_preferences_dialog_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static GObject *
___constructor (GType type, guint n_construct_properties, GObjectConstructParam *construct_properties)
{
#define __GOB_FUNCTION__ "LM:Preferences:Dialog::constructor"
	GObject *obj_self;
	LMPreferencesDialog *self;
	obj_self = G_OBJECT_CLASS (parent_class)->constructor (type, n_construct_properties, construct_properties);
	self = LM_PREFERENCES_DIALOG (obj_self);
#line 88 "src/lm-preferences-dialog.gob"
	lm_preferences_dialog_constructor (self);
#line 174 "lm-preferences-dialog.c"
	return obj_self;
}
#undef __GOB_FUNCTION__


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "LM:Preferences:Dialog::finalize"
	LMPreferencesDialog *self G_GNUC_UNUSED = LM_PREFERENCES_DIALOG (obj_self);
	gpointer priv G_GNUC_UNUSED = self->_priv;
	if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(obj_self);
}
#undef __GOB_FUNCTION__

static void 
lm_preferences_dialog_init (LMPreferencesDialog * o G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "LM:Preferences:Dialog::init"
	o->_priv = G_TYPE_INSTANCE_GET_PRIVATE(o,LM_TYPE_PREFERENCES_DIALOG,LMPreferencesDialogPrivate);
}
#undef __GOB_FUNCTION__
static void 
lm_preferences_dialog_class_init (LMPreferencesDialogClass * c G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "LM:Preferences:Dialog::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) c;

	g_type_class_add_private(c,sizeof(LMPreferencesDialogPrivate));

	parent_class = g_type_class_ref (LM_TYPE_DIALOG);

	g_object_class->constructor = ___constructor;
	g_object_class->finalize = ___finalize;
	g_object_class->get_property = ___object_get_property;
	g_object_class->set_property = ___object_set_property;
    {
	GParamSpec   *param_spec;

	param_spec = g_param_spec_pointer
		("applet" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (g_object_class,
		PROP_APPLET,
		param_spec);
    }
}
#undef __GOB_FUNCTION__

static void
___object_set_property (GObject *object,
	guint property_id,
	const GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "LM:Preferences:Dialog::set_property"
{
	LMPreferencesDialog *self G_GNUC_UNUSED;

	self = LM_PREFERENCES_DIALOG (object);

	switch (property_id) {
	case PROP_APPLET:
		{
#line 72 "src/lm-preferences-dialog.gob"
self->_priv->applet = g_value_get_pointer (VAL);
#line 243 "lm-preferences-dialog.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__

static void
___object_get_property (GObject *object,
	guint property_id,
	GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "LM:Preferences:Dialog::get_property"
{
	LMPreferencesDialog *self G_GNUC_UNUSED;

	self = LM_PREFERENCES_DIALOG (object);

	switch (property_id) {
	case PROP_APPLET:
		{
#line 72 "src/lm-preferences-dialog.gob"
g_value_set_pointer (VAL, self->_priv->applet);
#line 274 "lm-preferences-dialog.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__



#line 88 "src/lm-preferences-dialog.gob"
static void 
lm_preferences_dialog_constructor (LMPreferencesDialog * self)
{
#line 295 "lm-preferences-dialog.c"
#define __GOB_FUNCTION__ "LM:Preferences:Dialog::constructor"
{
#line 89 "src/lm-preferences-dialog.gob"
	
    GtkSizeGroup *size_group;
    GtkTreeSelection *selection;

    lm_container_create_interface(GTK_CONTAINER(self),
				  PKGDATADIR G_DIR_SEPARATOR_S "preferences-dialog.glade",
				  "vbox",
				  "lm_preferences_dialog_",
				  "scrolled", &selfp->scrolled,
				  "selected_label", &selfp->selected_label,
				  "add", &selfp->add,
				  "remove", &selfp->remove,
				  "up", &selfp->up,
				  "down", &selfp->down,
				  "delay_label", &selfp->delay_label,
				  "delay_scale", &selfp->delay_scale,
				  "scale_label", &selfp->scale_label,
				  "scale_scale", &selfp->scale_scale,
				  "tooltip_graph_span_label", &selfp->tooltip_graph_span_label,
				  "tooltip_graph_span_scale", &selfp->tooltip_graph_span_scale,
				  NULL);

    /* translators: header capitalization */
    gtk_window_set_title(GTK_WINDOW(self), _("Link Monitor Preferences"));
    gtk_dialog_add_buttons(GTK_DIALOG(self),
			   GTK_STOCK_HELP, GTK_RESPONSE_HELP,
			   GTK_STOCK_CLOSE, GTK_RESPONSE_CLOSE,
			   NULL);

    selfp->list = lm_host_view_new(selfp->applet);
    gtk_container_add(GTK_CONTAINER(selfp->scrolled), selfp->list);
    gtk_widget_show(selfp->list);

    selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(selfp->list));
    g_signal_connect_swapped(selection, "changed", G_CALLBACK(self_update_selected_label), self);

    g_object_connect(selfp->list,
		     "swapped-signal::notify::editing-host", self_update_sensitivity, self,
		     "swapped-signal::notify::can-go-up", self_update_sensitivity, self,
		     "swapped-signal::notify::can-go-down", self_update_sensitivity, self,
		     NULL);

    lm_g_object_connect(self, lm_shell,
			"swapped-signal::notify::host-count", self_update_sensitivity, self,
			NULL);

    size_group = gtk_size_group_new(GTK_SIZE_GROUP_HORIZONTAL);
    gtk_size_group_add_widget(size_group, selfp->delay_label);
    gtk_size_group_add_widget(size_group, selfp->scale_label);
    gtk_size_group_add_widget(size_group, selfp->tooltip_graph_span_label);
    g_object_unref(size_group);

    /* set the options */

    gtk_window_set_default_size(GTK_WINDOW(self),
				selfp->applet->preferences_width,
				selfp->applet->preferences_height);

    lm_non_linear_range_setup_static(GTK_RANGE(selfp->delay_scale), delay_blocks, G_N_ELEMENTS(delay_blocks));
    lm_non_linear_range_set_value(GTK_RANGE(selfp->delay_scale), selfp->applet->delay);

    lm_non_linear_range_setup_static(GTK_RANGE(selfp->scale_scale), scale_blocks, G_N_ELEMENTS(scale_blocks));
    lm_non_linear_range_set_value(GTK_RANGE(selfp->scale_scale), selfp->applet->scale);

    lm_non_linear_range_setup_static(GTK_RANGE(selfp->tooltip_graph_span_scale), lm_preferences_dialog_tooltip_graph_span_blocks, G_N_ELEMENTS(lm_preferences_dialog_tooltip_graph_span_blocks));
    lm_non_linear_range_set_value(GTK_RANGE(selfp->tooltip_graph_span_scale), selfp->applet->tooltip_graph_span * 1000);

    self_update_selected_label(self);
    self_update_sensitivity(self);

    g_object_connect(self,
		     "signal::response", self_response_h, NULL,
		     "signal::configure-event", self_configure_event_h, NULL,
		     NULL);

    /*
     * HIG chapter 3:
     * "When opening a dialog, provide initial keyboard focus to the
     * component that you expect users to operate first. This focus is
     * especially important for users who must use a keyboard to
     * navigate your application."
     */
    gtk_widget_grab_focus(selfp->add);
  }}
#line 383 "lm-preferences-dialog.c"
#undef __GOB_FUNCTION__

#line 174 "src/lm-preferences-dialog.gob"
static void 
lm_preferences_dialog_update_selected_label (LMPreferencesDialog * self)
{
#line 390 "lm-preferences-dialog.c"
#define __GOB_FUNCTION__ "LM:Preferences:Dialog::update_selected_label"
#line 174 "src/lm-preferences-dialog.gob"
	g_return_if_fail (self != NULL);
#line 174 "src/lm-preferences-dialog.gob"
	g_return_if_fail (LM_IS_PREFERENCES_DIALOG (self));
#line 396 "lm-preferences-dialog.c"
{
#line 176 "src/lm-preferences-dialog.gob"
	
    GtkTreeSelection *selection;
    int n_rows;

    selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(selfp->list));
    n_rows = gtk_tree_selection_count_selected_rows(selection);

    if (n_rows == 0)
      gtk_label_set_text(GTK_LABEL(selfp->selected_label), _("No host selected."));
    else
      {
	char *str;

	str = g_strdup_printf(ngettext("%i host selected.",
				       "%i hosts selected.",
				       n_rows), n_rows);
	gtk_label_set_text(GTK_LABEL(selfp->selected_label), str);
	g_free(str);
      }
  }}
#line 419 "lm-preferences-dialog.c"
#undef __GOB_FUNCTION__

#line 197 "src/lm-preferences-dialog.gob"
static void 
lm_preferences_dialog_update_sensitivity (LMPreferencesDialog * self)
{
#line 426 "lm-preferences-dialog.c"
#define __GOB_FUNCTION__ "LM:Preferences:Dialog::update_sensitivity"
#line 197 "src/lm-preferences-dialog.gob"
	g_return_if_fail (self != NULL);
#line 197 "src/lm-preferences-dialog.gob"
	g_return_if_fail (LM_IS_PREFERENCES_DIALOG (self));
#line 432 "lm-preferences-dialog.c"
{
#line 199 "src/lm-preferences-dialog.gob"
	
    GtkTreeSelection *selection;
    int n_rows;
    gboolean editing;
    int host_count;

    selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(selfp->list));
    n_rows = gtk_tree_selection_count_selected_rows(selection);
    editing = LM_HOST_VIEW(selfp->list)->editing_host;

    host_count = lm_shell_get_host_count(lm_shell);

    gtk_widget_set_sensitive(selfp->add, ! editing && host_count < LM_MAX_HOSTS);
    gtk_widget_set_sensitive(selfp->remove, ! editing && n_rows > 0);
    gtk_widget_set_sensitive(selfp->up, ! editing && LM_HOST_VIEW(selfp->list)->can_go_up);
    gtk_widget_set_sensitive(selfp->down, ! editing && LM_HOST_VIEW(selfp->list)->can_go_down);
  }}
#line 452 "lm-preferences-dialog.c"
#undef __GOB_FUNCTION__

#line 217 "src/lm-preferences-dialog.gob"
static void 
lm_preferences_dialog_response_h (GtkDialog * dialog, int response, gpointer user_data)
{
#line 459 "lm-preferences-dialog.c"
#define __GOB_FUNCTION__ "LM:Preferences:Dialog::response_h"
{
#line 221 "src/lm-preferences-dialog.gob"
	
    switch (response)
      {
      case GTK_RESPONSE_HELP:
	lm_show_help("preferences");
	break;

      case GTK_RESPONSE_CLOSE:
	gtk_widget_destroy(GTK_WIDGET(dialog));
	break;
      }
  }}
#line 475 "lm-preferences-dialog.c"
#undef __GOB_FUNCTION__

#line 234 "src/lm-preferences-dialog.gob"
static gboolean 
lm_preferences_dialog_configure_event_h (GtkWidget * widget, GdkEventConfigure * event, gpointer user_data)
{
#line 482 "lm-preferences-dialog.c"
#define __GOB_FUNCTION__ "LM:Preferences:Dialog::configure_event_h"
{
#line 238 "src/lm-preferences-dialog.gob"
	
    Self *self = SELF(widget);

    lm_applet_set_preferences_width(selfp->applet, event->width);
    lm_applet_set_preferences_height(selfp->applet, event->height);

    return FALSE;			/* propagate event */
  }}
#line 494 "lm-preferences-dialog.c"
#undef __GOB_FUNCTION__

#line 249 "src/lm-preferences-dialog.gob"
void 
lm_preferences_dialog_add_clicked_h (LMPreferencesDialog * self, GtkButton * button)
{
#line 501 "lm-preferences-dialog.c"
#define __GOB_FUNCTION__ "LM:Preferences:Dialog::add_clicked_h"
#line 249 "src/lm-preferences-dialog.gob"
	g_return_if_fail (self != NULL);
#line 249 "src/lm-preferences-dialog.gob"
	g_return_if_fail (LM_IS_PREFERENCES_DIALOG (self));
#line 507 "lm-preferences-dialog.c"
{
#line 251 "src/lm-preferences-dialog.gob"
	
    lm_host_view_activate_add(LM_HOST_VIEW(selfp->list));
  }}
#line 513 "lm-preferences-dialog.c"
#undef __GOB_FUNCTION__

#line 255 "src/lm-preferences-dialog.gob"
void 
lm_preferences_dialog_remove_clicked_h (LMPreferencesDialog * self, GtkButton * button)
{
#line 520 "lm-preferences-dialog.c"
#define __GOB_FUNCTION__ "LM:Preferences:Dialog::remove_clicked_h"
#line 255 "src/lm-preferences-dialog.gob"
	g_return_if_fail (self != NULL);
#line 255 "src/lm-preferences-dialog.gob"
	g_return_if_fail (LM_IS_PREFERENCES_DIALOG (self));
#line 526 "lm-preferences-dialog.c"
{
#line 257 "src/lm-preferences-dialog.gob"
	
    lm_host_view_activate_remove(LM_HOST_VIEW(selfp->list));
  }}
#line 532 "lm-preferences-dialog.c"
#undef __GOB_FUNCTION__

#line 261 "src/lm-preferences-dialog.gob"
void 
lm_preferences_dialog_up_clicked_h (LMPreferencesDialog * self, GtkButton * button)
{
#line 539 "lm-preferences-dialog.c"
#define __GOB_FUNCTION__ "LM:Preferences:Dialog::up_clicked_h"
#line 261 "src/lm-preferences-dialog.gob"
	g_return_if_fail (self != NULL);
#line 261 "src/lm-preferences-dialog.gob"
	g_return_if_fail (LM_IS_PREFERENCES_DIALOG (self));
#line 545 "lm-preferences-dialog.c"
{
#line 263 "src/lm-preferences-dialog.gob"
	
    lm_host_view_activate_move(LM_HOST_VIEW(selfp->list), -1);
  }}
#line 551 "lm-preferences-dialog.c"
#undef __GOB_FUNCTION__

#line 267 "src/lm-preferences-dialog.gob"
void 
lm_preferences_dialog_down_clicked_h (LMPreferencesDialog * self, GtkButton * button)
{
#line 558 "lm-preferences-dialog.c"
#define __GOB_FUNCTION__ "LM:Preferences:Dialog::down_clicked_h"
#line 267 "src/lm-preferences-dialog.gob"
	g_return_if_fail (self != NULL);
#line 267 "src/lm-preferences-dialog.gob"
	g_return_if_fail (LM_IS_PREFERENCES_DIALOG (self));
#line 564 "lm-preferences-dialog.c"
{
#line 269 "src/lm-preferences-dialog.gob"
	
    lm_host_view_activate_move(LM_HOST_VIEW(selfp->list), +1);
  }}
#line 570 "lm-preferences-dialog.c"
#undef __GOB_FUNCTION__

#line 273 "src/lm-preferences-dialog.gob"
void 
lm_preferences_dialog_delay_scale_value_changed_h (LMPreferencesDialog * self, GtkRange * range)
{
#line 577 "lm-preferences-dialog.c"
#define __GOB_FUNCTION__ "LM:Preferences:Dialog::delay_scale_value_changed_h"
#line 273 "src/lm-preferences-dialog.gob"
	g_return_if_fail (self != NULL);
#line 273 "src/lm-preferences-dialog.gob"
	g_return_if_fail (LM_IS_PREFERENCES_DIALOG (self));
#line 583 "lm-preferences-dialog.c"
{
#line 275 "src/lm-preferences-dialog.gob"
	
    lm_applet_set_delay(selfp->applet, lm_non_linear_range_get_value(range));
  }}
#line 589 "lm-preferences-dialog.c"
#undef __GOB_FUNCTION__

#line 279 "src/lm-preferences-dialog.gob"
void 
lm_preferences_dialog_scale_scale_value_changed_h (LMPreferencesDialog * self, GtkRange * range)
{
#line 596 "lm-preferences-dialog.c"
#define __GOB_FUNCTION__ "LM:Preferences:Dialog::scale_scale_value_changed_h"
#line 279 "src/lm-preferences-dialog.gob"
	g_return_if_fail (self != NULL);
#line 279 "src/lm-preferences-dialog.gob"
	g_return_if_fail (LM_IS_PREFERENCES_DIALOG (self));
#line 602 "lm-preferences-dialog.c"
{
#line 281 "src/lm-preferences-dialog.gob"
	
    lm_applet_set_scale(selfp->applet, lm_non_linear_range_get_value(range));
  }}
#line 608 "lm-preferences-dialog.c"
#undef __GOB_FUNCTION__

#line 285 "src/lm-preferences-dialog.gob"
void 
lm_preferences_dialog_tooltip_graph_span_scale_value_changed_h (LMPreferencesDialog * self, GtkRange * range)
{
#line 615 "lm-preferences-dialog.c"
#define __GOB_FUNCTION__ "LM:Preferences:Dialog::tooltip_graph_span_scale_value_changed_h"
#line 285 "src/lm-preferences-dialog.gob"
	g_return_if_fail (self != NULL);
#line 285 "src/lm-preferences-dialog.gob"
	g_return_if_fail (LM_IS_PREFERENCES_DIALOG (self));
#line 621 "lm-preferences-dialog.c"
{
#line 287 "src/lm-preferences-dialog.gob"
	
    lm_applet_set_tooltip_graph_span(selfp->applet, lm_non_linear_range_get_value(range) / 1000);
  }}
#line 627 "lm-preferences-dialog.c"
#undef __GOB_FUNCTION__

#line 291 "src/lm-preferences-dialog.gob"
char * 
lm_preferences_dialog_scale_format_value_h (LMPreferencesDialog * self, double arg, GtkScale * scale)
{
#line 634 "lm-preferences-dialog.c"
#define __GOB_FUNCTION__ "LM:Preferences:Dialog::scale_format_value_h"
#line 291 "src/lm-preferences-dialog.gob"
	g_return_val_if_fail (self != NULL, (char * )0);
#line 291 "src/lm-preferences-dialog.gob"
	g_return_val_if_fail (LM_IS_PREFERENCES_DIALOG (self), (char * )0);
#line 640 "lm-preferences-dialog.c"
{
#line 293 "src/lm-preferences-dialog.gob"
	
    int v;

    v = lm_non_linear_range_get_value(GTK_RANGE(scale));

    if (v < SECS(1))
      return g_strdup_printf(ngettext("%i millisecond", "%i milliseconds", v), v);
    else if (v < MINS(1))
      {
	int secs = v / SECS(1);
	return g_strdup_printf(ngettext("%i second", "%i seconds", secs), secs);
      }
    else if (v < HOURS(1))
      {
	int mins = v / MINS(1);
	return g_strdup_printf(ngettext("%i minute", "%i minutes", mins), mins);
      }
    else if (v < DAYS(1))
      {
	int hours = v / HOURS(1);
	return g_strdup_printf(ngettext("%i hour", "%i hours", hours), hours);
      }
    else if (v < DAYS(7))
      {
	int days = v / DAYS(1);
	return g_strdup_printf(ngettext("%i day", "%i days", days), days);
      }
    else
      {
	g_return_val_if_fail(v == DAYS(7), NULL);
	return g_strdup(_("1 week"));
      }
  }}
#line 676 "lm-preferences-dialog.c"
#undef __GOB_FUNCTION__
