# vim: ts=4
###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###

import sys
import gobject, gtk, pango
from time import time
from bisect import bisect_left

import utils, config, const

from widget.view import MultiDragTreeview
from widget.misc import ScrolledWindow
from widget.cover import PopupWindowCoverButton, CoverButton

try: import sexy
except: has_sexy = False
else: has_sexy = True

from helper import helper

class FailedRemoveSong(Exception):
    pass

UNKNOWN = "<i>"+utils.xmlescape(_("Unknown"))+"</i>"

class Browser(gtk.VBox):
    def __init__(self,pl,conf_prefix,cover=False,edit_cover=True):
        gtk.VBox.__init__(self)
        
        self.conf_prefix = conf_prefix
        
        self.pane = gtk.VPaned()
        
        self.pl = pl
        
        self.label = {}
        self.label["artist"] = _("artist")
        self.label["genre"] = _("genre")
        self.label["album"] = _("album")
        
        self.labels = {}
        self.labels["artist"] = _("artists")
        self.labels["genre"] = _("genres")
        self.labels["album"] = _("albums")

        #songs,sort name,name,user data
        self.model = {}
        self.model["genre"] = gtk.ListStore(object,str,str,object)
        self.model["artist"] = gtk.ListStore(object,str,str,object)
        self.model["album"] = gtk.ListStore(object,str,str,gtk.gdk.Pixbuf)

        class ColumnText(gtk.TreeViewColumn):
            def __init__(self,name,ncol):
                r = gtk.CellRendererText()
                r.set_property("ellipsize",pango.ELLIPSIZE_END)
                gtk.TreeViewColumn.__init__(self,name,r,markup=ncol)
                self.set_expand(True)
                self.set_sizing(gtk.TREE_VIEW_COLUMN_AUTOSIZE)


        class ColumnInt(gtk.TreeViewColumn):
            def __init__(self,name,ncol):
                r = gtk.CellRendererText()
                r.set_property("xalign",1)
                gtk.TreeViewColumn.__init__(self,name,r,text=ncol)
                
        class ColumnPixbuf(gtk.TreeViewColumn):
            def __init__(self,name,ncol):
                r = gtk.CellRendererPixbuf()
                gtk.TreeViewColumn.__init__(self,name,r,pixbuf=ncol)
                #self.set_alignment(1)
                
        class ColumnAll(gtk.TreeViewColumn):
            def __init__(self,name):
                gtk.TreeViewColumn.__init__(self,name)
                r = gtk.CellRendererText()
                r.set_property("xalign",0)
                r.set_property("ellipsize",pango.ELLIPSIZE_END)    
                self.pack_start(r, expand=True)
                self.add_attribute(r,"markup",2)

        if cover and edit_cover:
            self.info_supp_box = gtk.HBox(False,6)
            self.info_supp_box.pack_start(CoverButton("bottom"),False,False)
            l = gtk.Label("")
            l.set_use_markup(True)
            l.set_alignment(0,0)
            self.info_supp_box.pack_start(l,True,True)
            self.info_supp_box.show_all()
            self.info_supp_box.set_no_show_all(True)
            self.info_supp_box.hide()
            self.pack_end(self.info_supp_box,False,False)
        else:
            self.info_supp_box = None

        self.treeviews = {}
        self.treeviews["genre"] = MultiDragTreeview()
        self.treeviews["genre"].append_column(ColumnAll(_("Genres")))

        self.treeviews["artist"] = MultiDragTreeview()
        self.treeviews["artist"].append_column(ColumnAll(_("Artists")))

        self.treeviews["album"] = MultiDragTreeview()
        if cover:
            self.treeviews["album"].append_column(ColumnPixbuf(" ",3))
        self.treeviews["album"].append_column(ColumnAll(_("Albums")))
         
        targets = [("text/listen-songs", gtk.TARGET_SAME_APP, 1),("text/uri-list", 0, 2)]
        self.__id_changed_signal = {}
        for type, treeview in self.treeviews.iteritems():
            treeview.set_search_equal_func(self.on_interactive_search,type)
            treeview.get_selection().set_mode(gtk.SELECTION_MULTIPLE)
            self.__id_changed_signal[type] = treeview.get_selection().connect("changed", self.on_row_selected,type)
            treeview.connect("row-activated",self.on_row_activated,type)
            treeview.drag_source_set(
                gtk.gdk.BUTTON1_MASK, targets,
                gtk.gdk.ACTION_COPY)

            treeview.connect("drag-data-get", self.on_drag_data_get)
            treeview.set_model(self.model[type])
            def save_adjustement(treeview, hadjustment, vadjustment):
                if vadjustment:
                    self.scroll_adjustement[type] = vadjustment.get_value()
            treeview.connect("set-scroll-adjustments",save_adjustement)
            treeview.connect("popup-menu",self.__popup_menu,type)
            treeview.connect("popup-empty-menu",self.__popup_empty_menu,type)
            treeview.set_rules_hint(True)

        self.scroll_adjustement = {"genre":None,"artist":None,"album":None}
        hbox = gtk.HBox(True,4)
        hbox.pack_start(ScrolledWindow(self.treeviews["genre"]))
        hbox.pack_start(ScrolledWindow(self.treeviews["artist"]))
        hbox.pack_start(ScrolledWindow(self.treeviews["album"]))
        hbox.show_all()
        hbox.set_no_show_all(True)
        self.pane.pack1(hbox,False,True)

        self.expander = gtk.Expander()
        self.expander.connect("notify::expanded",self.on_browser_expand)

        l = gtk.Label(_("Hide browser"))
        l.set_alignment(0,0.5)
        l.set_size_request(-1,22)
        self.expander.set_label_widget(l)

        label_search = gtk.Label(_("Search")+" : ")
        label_search.set_alignment(1,0.5)
        label_search.show()
        
        if has_sexy:
            self.search_entry = sexy.IconEntry()
            self.search_entry.set_icon(sexy.ICON_ENTRY_PRIMARY,gtk.image_new_from_stock(gtk.STOCK_FIND,gtk.ICON_SIZE_BUTTON))
            self.search_entry.add_clear_button()
        else:
            self.search_entry = gtk.Entry()
            
        self.search_entry.connect("changed",self.on_search_changed)
        self.box_search = gtk.HBox(False,6)
        
        if not has_sexy:
            self.box_search.pack_start(label_search,False,False)
        self.box_search.pack_start(self.search_entry,True,True)
        if not has_sexy:
            btn_clear = gtk.Button()
            btn_clear.add(gtk.image_new_from_stock(gtk.STOCK_CLEAR, gtk.ICON_SIZE_MENU))
            btn_clear.set_size_request(28,28)
            btn_clear.set_relief(gtk.RELIEF_NONE)
            btn_clear.connect("clicked",lambda widget:self.search_entry.set_text(""))    
            self.box_search.pack_start(btn_clear,False,False)
        

        top_box = gtk.HBox(False,50)
        top_box.pack_start(self.expander,False,False)
        top_box.pack_start(self.box_search,True,True)
        self.pack_start(top_box,False,False)
        self.pack_start(self.pane,True,True)
        self.set_spacing(6)

        self.songs_cache = []
        self.filter_array = []
        self.__id_search = None
        self.__id_idle_add = None
        self.__id_idle_fill = {"genre":None,"artist":None,"album":None}

        self.selected = {"genre":[],"artist":[],"album":[]}
        self.cache_model = {"genre":{},"artist":{},"album":{}}
        self.iter_to_select = {"genre":[],"artist":[],"album":[]}

        self.event_pending = {"genre":[],"artist":[],"album":[]}

        self.treeviews["songs"] = None

        self.set_visible_pane(False)
        
        helper.connect("deleted",self.remove_songs)
        helper.connect("changed",self.change_songs)
        helper.connect("pl-add-songs",self.add_songs)
        

        """ LOAD CONF """

        artists = config.get("browser",self.conf_prefix+"_last_selected_artist")
        if artists != "":
            self.selected["artist"] = artists.split("<#>")
        albums = config.get("browser",self.conf_prefix+"_last_selected_album")
        if albums != "":
            self.selected["album"] = albums.split("<#>")
        genres = config.get("browser",self.conf_prefix+"_last_selected_genre")
        if genres != "":
            self.selected["genre"] = genres.split("<#>")
        
        if config.get("browser",self.conf_prefix) == "true":
            self.expander.set_expanded(True)
        else:
            self.expander.set_expanded(False)
        self.on_browser_expand(self.expander)
        
        self.search_entry.set_text(config.get("browser",self.conf_prefix+"_last_search"))
        
        rc_style = self.search_entry.rc_get_style()
        self.entry_active_style = rc_style.copy()
        self.entry_active_style.base[ gtk.STATE_NORMAL] = rc_style.base[gtk.STATE_SELECTED] 
        self.entry_active_style.text[ gtk.STATE_NORMAL] = rc_style.text[gtk.STATE_SELECTED]
        self.entry_active_style.base[ gtk.STATE_ACTIVE] = rc_style.base[gtk.STATE_NORMAL]
        self.entry_active_style.text[ gtk.STATE_ACTIVE] = rc_style.text[gtk.STATE_NORMAL]
        self.entry_active_style.base[ gtk.STATE_SELECTED] = rc_style.base[gtk.STATE_ACTIVE]
        self.entry_active_style.text[ gtk.STATE_SELECTED] = rc_style.text[gtk.STATE_ACTIVE]
            
        self.menu = None
        self.empty_menu = None
        
        if cover and edit_cover and False:
            self.preview_album_win = PopupWindowCoverButton()
            self.treeviews["album"].connect("motion-notify-event",self.show_preview_album_old)
            self.treeviews["album"].connect("leave-notify-event",self.preview_album_win.timeout_hide_cover)
        
            
            
    def set_menu(self,menu,empty_menu=None):
        self.menu = menu
        self.empty_menu = empty_menu
        
        
    def clear(self,type,selected = True):
        self.block()
        for event in self.event_pending[type]:
            try: gobject.source_remove(event)
            except: pass
        self.event_pending[type] = []
        model = self.model[type]
        model.clear()
        if type=="album":
            pixbuf = const.DEFAULT_COVER_PIXBUF_BROWSER
        else:
            pixbuf = None
        model.append(([],"<##ALL##>","<b>"+"0 " + utils.xmlescape(self.label[type])+" (0)</b>",pixbuf))
        self.unblock()
        
    """ save browser configuration """
    def save_config(self):
        config.set("browser",self.conf_prefix+"_last_selected_artist","<#>".join(self.selected["artist"]))
        config.set("browser",self.conf_prefix+"_last_selected_album","<#>".join(self.selected["album"]))
        config.set("browser",self.conf_prefix+"_last_selected_genre","<#>".join(self.selected["genre"]))

    def __on_pane_move(self,widget,property_spec):
        config.set("browser",self.conf_prefix+"_pos","%d"%self.pane.get_position())
        
    """ add the song view to use with the browser """
    def set_song_treeview(self,treeview):
        self.treeviews["songs"] = treeview
        self.pane.pack2(ScrolledWindow(self.treeviews["songs"]),True,False)
        self.pane.compute_position(-1,200,250)
        self.pane.set_position(int(config.get("browser",self.conf_prefix+"_pos")))
        self.pane.connect("notify::position",self.__on_pane_move)


    def config_watcher(self,helper,section,option,value):
        if section=="browser" and option == "view":
            self.set_visible_pane()
            
    def set_visible_pane(self,refill=True):
        types = self.get_list_type()
        for type, tree in self.treeviews.iteritems():
            if type!="songs":
                if type in types:
                    tree.get_parent().show()
                else:
                    tree.get_parent().hide()
        if refill:
            self.on_search_changed_cb(self.search_entry)

    def get_list_type(self):
        view = int(config.get("browser","view"))
        if view==0:
            return ["artist","album"]
        if view==1:
            return ["genre","artist"]
        if view==2:
            return ["genre","artist","album"]

    def get_next_type(self,previous_type):
        types = self.get_list_type()
        for i,type in enumerate(types):
            if type==previous_type and i+1<len(types):
                return types[i+1]
        return None
    
    def get_next_types(self,previous_type):
        types = self.get_list_type()
        type = types.pop(0)
        while type!=previous_type:
            type = types.pop(0)    
            continue
        return types

    def __popup_empty_menu(self,widget,type):
         if self.empty_menu:
            self.empty_menu.popup([])    
            
    def __popup_menu(self,widget,type):
        model,rows = self.treeviews[type].get_selection().get_selected_rows()
        if len(rows)<0:
            return
        else:
            songs = []
            for row in rows: 
                songs.extend(model[row[0]][0])
            songs.sort()
            if self.menu and songs:
                self.menu.popup(songs)
            if self.empty_menu and not songs:
                self.empty_menu.popup([])
            
    """ Refill all pane and song view"""
    def populate(self,*param):
        helper.connect("config-changed",self.config_watcher)    
        if self.treeviews["songs"]==None:
            raise "No song treeview set in the browser"

        self.on_search_changed(self.search_entry,True)
        
    
    def block(self):
        for type in self.get_list_type():
            self.treeviews[type].get_selection().handler_block(self.__id_changed_signal[type])
        
    def unblock(self):
        for type in self.get_list_type():
            treeselection = self.treeviews[type].get_selection()
            self.on_row_selected(treeselection,type,True)
            treeselection.handler_unblock(self.__id_changed_signal[type])
    
    """ remove a list of song in all view """
    def remove_songs(self,helper,songs_to_remove,by_uri=False):
        self.block()
        
        songs_to_remove = filter(self.match_filter,songs_to_remove)
        self.treeviews["songs"].get_model().remove_songs(None,songs_to_remove)
        for type in self.get_list_type():
            #self.treeviews[type].set_model(None)   
            model = self.model[type]
             
            iter_to_delete =[]
            
            #Simple for method 31sec 2229/9460
            if by_uri: #used only for change song because it need check each to cmp song
                def find_iter(model, path, iter):
    
                    songs = model[iter][0]
                    songs = filter(lambda s: s not in songs_to_remove,songs)
                    
                    if len(model[iter][0]) != len(songs):
                        model[iter][0] = songs
                        if len(songs)>0 or path[0]==0:
                            name = model[iter][1]
                            if name == "<##ALL##>":
                                pass
                            elif name == UNKNOWN:
                                model[iter][2] = UNKNOWN+" (%d)"%len(songs)
                            else:
                                model[iter][2] = utils.xmlescape(songs[0].get_str(type))+" (%d)"%len(songs)
                                
                        else:
                            iter_to_delete.append(iter)
    
                model.foreach(find_iter)
            
            else:
                #bisect method 14sec 229/9463 best method but need reimplemente change song to use
                
                del_songs_list = [(s.get_sortable(type),pos,s) for pos,s in enumerate(songs_to_remove)]
                del_songs_list.sort()
                songs_list = [row[1] for row in model ]
                lo = 1
                iter = None
                for key,pos,song in del_songs_list:
                    if iter!=None and iter >= len(songs_list): break
                    if iter==None or songs_list[iter] != key: iter = bisect_left(songs_list,key,lo)
                    if iter!=None and iter >= len(songs_list): break
                    if songs_list[iter] == key or (key=="" and songs_list[iter]==UNKNOWN):
                        model[iter][0] = [s for s in model[iter][0] if s!=song]
                        current_songs = model[iter][0]
                        nb_songs = len(current_songs)
                        if nb_songs>0:
                            name = model[iter][1]    
                            if name == "<##ALL##>":
                                pass
                            elif name == UNKNOWN:
                                model[iter][2] = UNKNOWN+" (%d)"%nb_songs
                            else:
                                model[iter][2] = utils.xmlescape(current_songs[0].get_str(type))+" (%d)"%nb_songs
                        else:
                            iter_to_delete.append(iter)
                        if key=="": lo = 1
                        else:lo = iter
                    else:
                        lo = iter
            
            iter_to_delete.reverse()
            for iter in iter_to_delete:
                del model[iter]
                
            total = len(model)-1
            if total>1: l = self.labels[type]
            else: l = self.label[type]
            #print self.conf_prefix,type,len(model)
            #print model[0]
            model[0][0] = filter(lambda s: s not in songs_to_remove,model[0][0])
            model[0][1] = "<##ALL##>"
            l_all =  "<b>"+"%d "%total + utils.xmlescape(_(l))+" (%d)"%len(model[0][0])+"</b>"
            model[0][2] = l_all
            #self.treeviews[type].set_model(self.model[type])
            
        self.unblock()

    def change_songs(self,helper,songs):
        self.remove_songs(helper,songs,True)
        songs = filter(lambda s: self.pl.have_song(s),songs)
        if len(songs)>0 : self.add_songs(helper,self.pl,songs)
        
    def add_songs(self,helper,pl,songs,types=None):
        if pl!=self.pl: return

        if types==None: types = self.get_list_type()
            
        songs = filter(self.match_filter,songs)
        
        songs_by_type = {}
        keys_by_type = {}
        previous_type = ""
        first = True
        keeped_song = []
        for type in types:
            songs_by_type[type] = {}
            for song in songs:
                if first or not self.selected[previous_type] or "<##ALL##>" in self.selected[previous_type] or song.get_sortable(previous_type) in self.selected[previous_type]:
                    songs_by_type[type].setdefault(song.get_sortable(type),[]).append(song)
                    keeped_song.append(song)
            keys_by_type[type] = songs_by_type[type].keys()
            keys_by_type[type].sort()
            
            if not helper:
                if not self.selected[type] or not [i for i in self.selected[type]  if i in keys_by_type[type] ]:
                    self.selected[type].insert(0,"<##ALL##>")
            
            songs = keeped_song
            keeped_song = []
            previous_type = type
            first = False
                
                    
        songs_by_type["songs"] = filter(lambda song:first or  not self.selected[previous_type] or "<##ALL##>" in self.selected[previous_type] or song.get_sortable(previous_type) in self.selected[previous_type],songs)

        self.treeviews["songs"].get_model().append_songs(songs_by_type["songs"])

        self.deb = {}
        for type in types:
            self.deb[type] = time()
            #self.treeviews[type].set_model(None)
            #while gtk.events_pending():gtk.main_iteration()
            #self.event_pending[type].append(gobject.idle_add(self.fill,type,keys_by_type[type],songs_by_type[type]))
            self.fill(type,keys_by_type[type],songs_by_type[type],helper)
        
        #gobject.idle_add(self.treeviews["songs"].get_model().append_songs,songs_by_type["songs"])

    def fill(self,un_type,keys,songs,helper,index = 1):
        model = self.model[un_type]
        unknown = []
        all_song = []
        
        if model[len(model)-1][1] == UNKNOWN :
            have_unknown_row = True
        else:
            have_unknown_row = False
        path_to_select = set()
        for key in keys[:const.BROWSER_POPULATE]:
             
            all_song.extend(songs[key])
            if not key or key == "":
                unknown.extend(songs[key])
                continue
            if un_type=="album":
                pixbuf = songs[key][0].get_cover_pixbuf(const.BROWSER_COVER_SIZE["x"],const.BROWSER_COVER_SIZE["y"],False)
            else:
                pixbuf = None
                
            if (len(model)==1 and not have_unknown_row) or (len(model)==[1] and have_unknown_row):
                model.append((songs[key],key,songs[key][0].get_str(un_type,True)+" (%d)"%len(songs[key]),pixbuf))
                if key in self.selected[un_type]: path_to_select.add(len(model)-1)
            else:
                while True:
                    if (index>=len(model) and not have_unknown_row):
                        model.append((songs[key],key,songs[key][0].get_str(un_type,True)+" (%d)"%len(songs[key]),pixbuf)) 
                        if key in self.selected[un_type]: path_to_select.add(len(model)-1)              
                        break
                    else:
                        cur_un_type_value = model[index][1]
                        if key == cur_un_type_value:
                            model[index][0].extend(songs[key])
                            model[index] = (model[index][0],key,songs[key][0].get_str(un_type,True)+" (%d)"%len(model[index][0]),pixbuf)
                            if key in self.selected[un_type]: path_to_select.add(index)              
                            break

                        if key < cur_un_type_value or cur_un_type_value == UNKNOWN: 
                            model.insert(index,(songs[key],key,songs[key][0].get_str(un_type,True)+" (%d)"%len(songs[key]),pixbuf))
                            if key in self.selected[un_type]: path_to_select.add(index)              
                            break
                        index += 1

            continue
        
        # set the unknown items
        if len(unknown)>0:
            index_unknown = len(model)-1  
            label = model[index_unknown][1]
            if un_type=="album":
                pixbuf = const.DEFAULT_COVER_PIXBUF_BROWSER
            else:
                pixbuf = None    
            if label == UNKNOWN :
                model[index_unknown][0].extend(unknown)
                model[index_unknown] = [model[index_unknown][0],UNKNOWN,UNKNOWN+" (%d)"%len(model[index_unknown][0]),pixbuf ]
            else:
                model.append((unknown,UNKNOWN,UNKNOWN+" (%s)"%len(unknown),pixbuf))
        
        model[0][0].extend(all_song)
        total = len(model)-1
        if total>1: l = self.labels[un_type]
        else: l = self.label[un_type]
        l_all =  "<b>"+"%d "%total + utils.xmlescape(_(l))+ " (%d)</b>"%len(model[0][0])
        model[0][1] = "<##ALL##>"
        model[0][2] = l_all 
        
        if len(keys[const.BROWSER_POPULATE:])>0:
            self.event_pending[un_type].append(gobject.idle_add(self.fill,un_type,keys[const.BROWSER_POPULATE:],songs,helper, index))
        else:
            """self.treeviews[un_type].set_model(self.model[un_type])"""
            if not helper:
                self.block()
                tmp_selected = []
                for path in path_to_select:
                    if model[path][1] in self.selected[un_type]:
                        tmp_selected.append(model[path][1])
                    self.treeviews[un_type].get_selection().select_path(path)
                    
                if "<##ALL##>" in self.selected[un_type]:
                    tmp_selected.insert(0,"<##ALL##>")
                self.selected[un_type] = tmp_selected
                if len(path_to_select)>0:
                    self.treeviews[un_type].scroll_to_cell(list(path_to_select)[0])
                    if "<##ALL##>" not in self.selected[un_type]: 
                        self.treeviews[un_type].get_selection().unselect_path(0)
                else:
                    self.treeviews[un_type].get_selection().select_path(0)
                
                self.unblock()
                #print "fill",un_type,"in",time() - self.deb[un_type]
                    

    """ filter browser with text in entry """
    def on_search_changed(self,entry,selected_last_selected = False):
        if self.treeviews["songs"]==None:
            return

        self.filter_array =  [ s.strip().lower() for s in entry.get_text().split(" ") if s.strip()!=""]

        if self.filter_array:
            entry.set_style(self.entry_active_style.copy())
        else: 
            entry.set_style(None)

        config.set("browser",self.conf_prefix+"_last_search",entry.get_text())
        
        if self.__id_search!=None:  gobject.source_remove(self.__id_search)
        self.__id_search = gobject.timeout_add(500,self.on_search_changed_cb,entry,selected_last_selected)



    """ filter browser with text in entry """
    def match_filter(self,song):
        if len(self.filter_array)==0: return True
        else:
            match = True
            for f in self.filter_array:
                if f.strip() == "" : continue
                if song.get_filter().rfind(f)==-1:
                    match = False
                    break
            return match
        
    def on_search_changed_cb(self,entry,selected_last_selected=False):
        songs = self.pl.get_songs()
            
        types = self.get_list_type()
        for type in types:
            self.clear(type,not selected_last_selected)
        self.treeviews["songs"].get_model().clear()
        self.add_songs(None,self.pl,songs)
        return False

    """
    Browser manipulation
    """
    def on_interactive_search(self,model, column, key, iter,type):
        value = model.get_value(iter, 1)
        if value.lower().find( key.lower()) == 0:
          return False
        return True

    def on_row_activated(self,treeview, path, view_column,type):
        songs = treeview.get_model()[path][0]
        if len(songs)>0:
            songs.sort()
            helper.cur_playlist_play(songs)

    def on_row_selected(self,treeselection,type,only_refresh=False):
        model,rows = treeselection.get_selected_rows()
        if len(rows)<=0:
            if self.info_supp_box:
                self.info_supp_box.hide_all()
            return

        setsongs = [model[row[0]][0] for row in rows]
        del self.selected[type]
        self.selected[type] = [model[row[0]][1] for row in rows]
        songs = []
        for setsong in setsongs:
            songs.extend(setsong)

        if self.info_supp_box and type == "album" :
            len_songs=len(songs)
            if len(rows) == 1 and rows[0] != (0,) and len_songs>0:
                self.info_supp_box.get_children()[0].update_cover(None,songs[0])
                text_info="\n<span size=\"large\"><b>"
                if songs[0].get("album"):
                    text_info+=songs[0].get_str("album",True)+" - "
                text_info+="<i>"+songs[0].get_str("artist",True)+"</i>"
                text_info+="</b></span>\n"
                if len_songs == 1:
                    text_info+="1 "+_("song")
                else:
                    text_info+=str(len_songs)+" "+_("songs")
                len_album = 0
                for s in songs: len_album += s.get("#duration")
                text_info+=" - "+utils.duration_to_string(len_album)
                self.info_supp_box.get_children()[1].set_markup(text_info)
                self.info_supp_box.show()
            else:
                self.info_supp_box.hide()
        
        if not only_refresh:
            next_types = self.get_next_types(type)
            for type in next_types:
                self.clear(type)
            model = self.treeviews["songs"].get_model()
            if model:
                model.clear()
                self.add_songs(None,self.pl,songs,next_types)


    def on_drag_data_get(self,treeview, context, selection, info, timestamp):
        model,rows = treeview.get_selection().get_selected_rows()
        if len(rows)<0:
            return
        else:
            songs = []
            for row in rows: 
                songs.extend(model[row[0]][0])
        songs.sort()
        list_uri = list([ song.get("uri") for song in songs])
        selection.set("text/listen-songs", 8, "\n".join(list_uri))
        selection.set_uris(list_uri)

    def on_browser_expand(self,expander,*param):
        if expander.get_expanded():
            config.set("browser",self.conf_prefix,"true")
        else:
            config.set("browser",self.conf_prefix,"False")

        if expander.get_expanded():
            expander.get_label_widget().set_text(_("Hide browser"))
            self.pane.get_child1().show()
        else:
            expander.get_label_widget().set_text(_("Show browser"))
            self.pane.get_child1().hide()
    
