# vim: ts=4
###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###


import os
import gobject, gtk

import config, const, utils

from helper import helper

try: 
    import dbus
    if getattr(dbus, 'version', (0,0,0)) >= (0,41,0):
        import dbus.glib
except: dbus_imported = False
else: dbus_imported=True

class Notify:
    timeout = 10000
    current_song = None
    dbus_notify = None    
    title = "\xe2\x99\xaa "+_("Listen now playing")+" \xe2\x99\xaa"
    action = ""
    #action = ["previous","Previous","next","Next"]
    hints = []
    last_id = 0
    __id_tray = None
    def __init__(self,player,tray):
        interface = 'org.freedesktop.Notifications' 
        path = '/org/freedesktop/Notifications'    
        self.tray = tray
        self.player = player
        if dbus_imported:
            try: bus = dbus.SessionBus()
            except: bus = None
            
        if dbus_imported and bus and utils.dbus_service_available(bus,interface,True):
            
            obj = bus.get_object(interface, path) 
            self.dbus_notify = dbus.Interface(obj, interface)
            
            #self.dbus_notify.connect_to_signal("ActionInvoked",self.action_cb)
            #self.dbus_notify.connect_to_signal("NotificationClosed",self.on_notificationclosed)
            
            player.connect("instant-new-song",self.on_new_song)
            
            self.tray.eventbox.connect("enter-notify-event", self.on_mouse_over)
            self.tray.eventbox.connect("leave-notify-event", self.on_mouse_out)
            
        else:
            self.dbus_notify = None
            gobject.timeout_add(1000, self.tray.update_tooltips)
            print "No Notify support"
            
    def on_notificationclosed(self,id,reason):
        print "Closed",id,reason
        self.last_id = 0
        
    def on_mouse_over(self,*args):
        if self.dbus_notify!=None and config.get("setting","notification")=="true":      
            self.__id_tray = gobject.timeout_add(1000,self.show_mouse_over)
            
    def show_mouse_over(self):
        value = self.player.get_position()
        song = self.player.song
        if song!=None:
            text = []    
            title = ""
            if song.get_str("title"):
                title += "<b>"+song.get_str("title",True)
                title += "</b>"
            if self.player.paused:
                title += " - <i>"+_("Paused")+"</i>"
            text.append(title)
            if song.get("artist"):
                text.append("<i>"+song.get_str("artist",True)+"</i>")
            if song.get("album"):
                text.append(song.get_str("album",True))
            text.append(utils.duration_to_string(value,"00:00")+" "+_("of")+" "+utils.duration_to_string(self.player.get_length(),"00:00"))
            
            text = "\n".join(text)
        else:
            text = _("No Playing")
            
        self.close_notification()
        self.display_notification(self.player.song,text,0,self.last_id)
        
        #refresh do a ugly things
        #self.__id_tray = gobject.timeout_add(5000,self.on_mouse_over)
        return False
        
    def on_mouse_out(self,*args):
        if self.__id_tray:
            try:gobject.source_remove(self.__id_tray)
            except:pass
            self.__id_tray==None
        self.close_notification()
        
    
    def action_cb(self,id,action):
        print "I:widget/notify:action_cb",id,action
        helper.control(action)
        
    def on_new_song(self,player,song):
        if self.dbus_notify!=None and config.get("setting","notification")=="true":
            
            text = []
            if song.get_str("title"):
                title = "<b>"+song.get_str("title",True)
                if song.get("#duration"):
                    title += " ("+song.get_str("#duration",True)+")"
                title += "</b>"
                text.append(title)
            if song.get("artist"):
                text.append("<i>"+song.get_str("artist",True)+"</i>")
            if song.get("album"):
                text.append(song.get_str("album",True))
            
            text = "\n".join(text)
            self.close_notification()
            self.display_notification(song,text,self.timeout)

            
    def display_notification(self,song,text,timeout,id=0):
        if self.dbus_notify!=None:  
            icon = ""  
            if song:
                cover = song.get_cover_path()
                if os.path.exists(cover):
                    pixbuf = gtk.gdk.pixbuf_new_from_file_at_size(cover,40,40)
                    w, h = pixbuf.get_width(), pixbuf.get_height()
                    line = gtk.gdk.Pixbuf(gtk.gdk.COLORSPACE_RGB, True, 8, w + 2, h + 2)
                    line.fill(0x000000ff)
                    pixbuf.copy_area(0, 0, w, h, line, 1, 1)
                    icon = os.path.join(const.TMP_PATH+"/cover.png")
                    line.save(icon, "png", {})
                
            self.hints = self.get_hints()
            self.last_id = self.dbus_notify.Notify("Listen", id, icon,self.title, text,self.action, self.hints, timeout)
            return self.last_id
        return 0
            
    def close_notification(self):
        if self.dbus_notify!=None:
            self.dbus_notify.CloseNotification(self.last_id)   
            self.last_id = 0 
        
        
    #FROM GAJIM
    def get_hints(self):
        hints = {}
        if self.tray.tray:
           x, y = self.tray.tray.window.get_origin()
           w, h = self.tray.tray.size_request()
           x += w/2
           if y < 100:
              # top-panel
              y += h
           else:
              # bottom-panel
              y -= h
           hints['x'] = x
           hints['y'] = y
        hints['desktop-entry'] = "listen"
         
        return hints

        
