/* Copyright (C) 2000-2003 Markus Lausser (sgop@users.sf.net)
   This is free software distributed under the terms of the
   GNU Public License.  See the file COPYING for details. */

extern const int StatusInfo[S_NUMBER];

void transfer_init(transfer_t* trans, int status);
void transfer_destroy(transfer_t* data);
int transfer_in_progress(transfer_t *trans);
long upload_calc_max(user_info_t* userinfo);
int transfer_status_dist(int s1, int s2);
GdkPixmap*
transfer_draw_progress(GtkCList * clist, GdkPixmap * pixmap,
		       long start, long pos, long stop,
		       long size, int mark, int width);

char *status_names(int status);
char *_status_names(int status);

upload_t *upload_new(net_t* net, char* filename, char* user,
		     int offline);
void upload_destroy(upload_t *upload);
void upload_hide(socket_t *socket);
void upload_status_set(socket_t * socket, int status);
socket_t *upload_search_mapable(net_t* net, char *user, 
				char *winname);
int upload_to_destroy(socket_t * socket, int mode);
void upload_show(socket_t * socket);
void upload_start(socket_t * socket);
void upload_end(socket_t * socket, int mode);
gint upload_get_info(gpointer data, gint source,
		     GdkInputCondition condition);
gint upload_fw_get_info(gpointer data, gint source,
		     GdkInputCondition condition);
void uploads_disable();
void uploads_enable();
void upload_update(socket_t * socket);
void upload_remove_dead();
void upload_update_speed(user_info_t* userinfo);
GdkPixmap *resume_draw_progress(GtkCList * clist, GdkPixmap * pixmap,
				resume_t* resume, int width);

download_t *download_new(file_t* file);
void download_destroy(download_t *download);
void download_hide(socket_t * socket);
void download_queued_update(socket_t* socket);
void download_status_set(socket_t * socket, int status);
socket_t *download_search_mapable(net_t* net, char *user, 
				  char *winname);
int download_to_destroy(socket_t * socket, int mode);
int download_grab_resume(socket_t * socket, resume_t * resume);
void download_ungrab_resume(socket_t * socket);
int download_search_queued(resume_t * resume);
void download_update(socket_t * socket);
GList *download_search_all(char *user, char *winname);
void download_file(file_t * file, char* search_string, char* dir);
void download_show(socket_t * socket);
void download_start(socket_t * socket, int force);
void download_end(socket_t * socket, int mode);
gint download_get_info(gpointer data, gint source,
		       GdkInputCondition condition);
gint download_fw_get_info(gpointer data, gint source,
			  GdkInputCondition condition);
int download_timeout(gpointer data);
void downloads_disable();
void downloads_enable();
void download_remove_dead();
int download_to_retry(download_t* download, int mode);
int download_real_allowed();

int transfer_remove_dead(gpointer data);
void transfer_connect_and_start(socket_t * socket);
int global_timer(gpointer data);

GtkWidget *create_upload_popup(upload_t * upload, share_t* share);
GtkWidget *create_dl_remove_popup(int val);
GtkWidget *create_retry_popup(int val);
GtkWidget *create_ul_remove_popup(int val);
void retry_timeout_check();
GtkWidget *create_advanced_popup();
GtkWidget *create_download_popup();
void create_bandwidth_win(user_info_t* userinfo, int download);
void create_bandman_win();
GtkWidget* create_bandwidth_popup(user_info_t* userinfo);

void dcc_send_file(char *nick, char *file, net_t* net);
void dcc_select_file(char *nick, net_t* net);
int dcc_check_message(char *from, char *message, net_t* net);
socket_t*
dcc_create(net_t* net, char* nick, char* filename, unsigned long ip, 
	   short port, unsigned long size, int speed);

file_segment_t* file_segment_new(long start, long stop);
void file_segment_destroy(file_segment_t* part);
void file_segment_valid(file_segment_t* part);
void file_segment_invalid(file_segment_t* part);
void file_segment_start(file_segment_t* part);
void file_segment_stop(file_segment_t* part);
file_segment_t* file_segment_find_free(resume_t* resume,
				       long* stop);
file_segment_t* file_segment_create_after(resume_t* resume, 
					  file_segment_t* segment,
					  long stop);
void file_segment_attach_to_download(socket_t* socket,
				     file_segment_t* segment);
void file_segment_remove(resume_t* resume, file_segment_t* segment);
void file_segment_merge(resume_t *resume, GList* segment);
char* file_segment_print(GList* parts);
net_user_t* download_find_net(download_t* download, net_t* net);
void download_add_net(download_t* download, net_t* net, char* user);
void transfer_cancel_running();
socket_t *download_create(file_t * file, resume_t* resume,
			  char* search, char* dir, int dcc);
void download_file_without_check(file_t* file,
				 char* search, char* dir);
GtkWidget *create_advanced_popup2();

void check_uploads_again();
