from kdeemul import *
import paths

from dragobjects import *
from importsession import *
import os, errno
import copy

def cmpRect(r1,r2):
        if r1.x()!=r2.x(): return False
        if r1.y()!=r2.y(): return False
        if r1.width()!=r2.width(): return False
        if r1.height()!=r2.height(): return False
        return True

class LAlbumListView(QListView):
	def __init__(self, container, name, mainWindow):
		QListView.__init__(self, container, name)
		self.addColumn(i18n("Albums"))
		self.header().setStretchEnabled(True, self.columns()-1)
		self.setDefaultRenameAction(QListView.Accept)
		self.setRootIsDecorated(True)
		QObject.connect( self, SIGNAL("contextMenuRequested(QListViewItem *, const QPoint &, int)"), self.slotContextMenu)
		#--drag highlighting init
		self.setAcceptDrops(True)
		self.viewport().setAcceptDrops(True)
		self.dropItem = 0
		self.autoopenTime = 750
		self.openTimer = QTimer(self)
		self.flashTimer = QTimer(self)
		QObject.connect(self.openTimer, SIGNAL("timeout()"), self.openFolder)
		QObject.connect(self.flashTimer, SIGNAL("timeout()"), self.flashFunc)
		self.flashing = False
		self.flashCount = 0
		self.flashItem = None
		
	def initPopupMenu(self, ac):
		self.actions = ac

	def openFolder( self ):
		self.openTimer.stop()
		if self.dropItem and not self.dropItem.isOpen():
			self.dropItem.setOpen( True )
			self.dropItem.repaint()
			
	def flashFunc( self ):
		if self.flashCount == 6:
			self.flashTimer.stop()
			self.flashCount = 0
			return 
		elif self.flashCount == 0:
			self.flashTimer.start(50)
		
		self.flashCount = self.flashCount + 1
		if self.flashing:
			self.flashing = False
			self.flashItem.setBackgroundColor(None)
			self.flashItem.repaint()
		else:
			self.flashing = True
			self.flashItem.setBackgroundColor(QColor(0,0,255))
			self.flashItem.repaint()

	def contentsDragEnterEvent( self, e ):
		self.contentsDragMoveEvent(e)
		
	def contentsDragMoveEvent( self, e ) :
		vp = self.contentsToViewport( e.pos() )
		i = self.itemAt( vp )
		if i :
			if i.acceptDrag(e):
				e.accept()
				if i != self.dropItem:
					if self.dropItem:
						self.dropItem.setBackgroundColor(None)
						self.dropItem.repaint()
					i.setBackgroundColor(QColor(200,215,255))
					i.repaint()
					self.openTimer.stop()
					self.dropItem = i
					self.openTimer.start( self.autoopenTime )
			else:
				if self.dropItem:
					self.dropItem.setBackgroundColor(None)
					self.dropItem.repaint()
					self.dropItem = 0
				e.ignore()
		else :
			if self.dropItem:
				self.dropItem.setBackgroundColor(None)
				self.dropItem.repaint()
			e.accept()
			self.openTimer.stop()
			self.dropItem = 0

	def contentsDragLeaveEvent( self, QDragLeaveEvent ) :
		self.openTimer.stop()
		if self.dropItem:
			self.dropItem.setBackgroundColor(None)
			self.dropItem.repaint()
		self.dropItem = 0
		
	def contentsDropEvent( self, e ):
		self.openTimer.stop()
		if self.dropItem:
			self.dropItem.setBackgroundColor(None)
			self.dropItem.repaint()
			self.dropItem = 0
		item = self.itemAt( self.contentsToViewport(e.pos()) )
		if item and item.acceptDrag(e):
			if item.dropped(e):
				self.flashItem = item
				self.flashFunc()
		elif self.acceptDrag(e):
			self.dropped(e)
		
	def setLibrary(self, lib):
		self.lib = lib
		QObject.connect(self.lib, PYSIGNAL("newAlbum"), self.slotNewAlbum)
		QObject.connect(self.lib, PYSIGNAL("delAlbum"), self.slotDelAlbum)
		QObject.connect(self.lib, PYSIGNAL("moveAlbum"), self.slotMoveAlbum)
		QObject.connect(self.lib, PYSIGNAL("addAlbum"), self.slotAddAlbum)
		QObject.connect(self, PYSIGNAL("createAlbum"), self.lib.slotNewAlbumWithKeys)
		QObject.connect(self, PYSIGNAL("trashKeyList"), self.lib.trashKeyList)
		QObject.connect(self, PYSIGNAL("trashAlbum"), self.lib.trashAlbum)
		QObject.connect(self, PYSIGNAL("addPhotos"), self.lib.slotAddPhotosToAlbum)
		QObject.connect(self, PYSIGNAL("moveAlbum"), self.lib.moveAlbum)
		
		self.loadValues()

	def loadValues(self):
		self.clear()
		albums = self.lib.getAlbumList()
		for album in albums:
			if album['Type'] == "Master":
				lvi = LMasterAlbumItem(self, [], album['AlbumName'])
			elif album['Type'] == "Trash":
				lvi = LTrashAlbumItem(self)
			elif album['Type'] == "Roll":
				lvi = LRollAlbumItem(self, [], album['AlbumName'])
				self.loadChildAlbums(lvi, album['AlbumList'])
			else:
				lvi = LPhotoAlbumItem(self, [], album['AlbumName'])
				self.loadChildAlbums(lvi, album['AlbumList'])
			lvi.writeable = album['W']

	def loadChildAlbums(self, parent, albumList):
		for album in albumList:
			lvi = LPhotoAlbumItem(parent, parent.path, album['AlbumName'])
			self.loadChildAlbums(lvi, album['AlbumList'])

	def acceptDrag(self, event):
		pos = self.contentsToViewport(event.pos())
		item = self.itemAt(pos)
		if item:
			return item.acceptDrag(event)
		else:
			return LPhotoKeysDrag.canDecode(event) or LAlbumDrag.canDecode(event) or QUriDrag.canDecode(event)

	def dropped(self, event):
		# create new album and add these images
		if LPhotoKeysDrag.canDecode(event):
##~ 			print "NonItem drop"
			keys = LPhotoKeysDrag.getKeys(event)
			srcPath = LPhotoKeysDrag.getAlbumPath(event)
			self.emit(PYSIGNAL("createAlbum"), (keys, srcPath))
		elif LAlbumDrag.canDecode(event):
##~ 			print "dropped album on main list"
			path = LAlbumDrag.decode(event)
			self.emit(PYSIGNAL("moveAlbum"),([], path))
		elif QUriDrag.canDecode(event):
##~ 			print "dropped URI on main list"
			files = QStringList()
			QUriDrag.decodeLocalFiles(event, files)
			self.emit(PYSIGNAL("dragImportNewAlbum"), (files, None))

	def dragObject(self):
##~ 		print "Album List Drag Object",self.currentItem().path
		return LAlbumDrag(self.currentItem().path, self)

	def slotNewAlbum(self, path):
		self.loadValues()
		# select new album and put in edit mode
		lvi = self.getItemFromPath(path)
		lvi.startRename(0)
		
	def slotRenameAlbum(self):
		lvi = self.currentItem()
		if lvi:
			lvi.startRename(0)

	def slotDelAlbum(self, name):
		self.loadValues()
		
	def slotAddAlbum(self, name):
		self.loadValues()

	def slotMoveAlbum(self, dstPath, srcPath):
		self.loadValues()
		i = self.getItemFromPath(dstPath)
		if i:
			self.ensureItemVisible(i)
			self.setSelected(i, True)
			
	def selectFromPath(self, path):
		self.loadValues()
		i = self.getItemFromPath(path)
		if i:
			self.ensureItemVisible(i)
			self.setSelected(i, True)
			
	def removeAlbum(self, path):
		name = path[len(path)-1]
		result = QMessageBox.warning(None, i18n("Lphoto: Remove Album"), i18n("Do you want to remove %s?"%(name)), i18n("Yes, remove the album."), i18n("No"),  None,  1, 1)
		if result == 0:
			self.emit(PYSIGNAL("trashAlbum"),(path, None))
	
	def slotRemoveAlbum(self):
		lvi = self.currentItem()
		if lvi:
			self.removeAlbum(lvi.path)
					
	def getItemFromPath(self, path):
		item = self.firstChild()
		while item:
			if item.path == path[0:len(item.path)]:
				if item.path == path:
					return item
				else:
					item = item.firstChild()
			else:
				item = item.nextSibling()
		return None
		
	def slotContextMenu(self, item, pos, col):
		popup = QPopupMenu()
		self.actions.action("newAlbum").plug(popup)
		if item:
			popup.insertSeparator()
			item.loadPopupMenu(popup, self.actions)
		popup.exec_loop(pos)

class LBaseListViewItem(QListViewItem):
	def __init__(self, parent, path, name):
		QListViewItem.__init__(self, parent, name)
		self.setDropEnabled(True)
		self.master = False
		self.setRenameEnabled(0, True)
		self.path = copy.copy(path)#[0:(len(path)-1)]
		self.path.append(name)
		ifn = self.iconFileName()
		if ifn:
			pixmap = QPixmap(paths.art(ifn))
			self.setPixmap(0,pixmap)
		self.bgColor = None

	def paintCell(self,p,cg,column,width,alignment):
		if self.bgColor:
			_cg = QColorGroup(cg)
			_cg.setColor(QColorGroup.Background,self.bgColor)
			_cg.setColor(QColorGroup.Base,self.bgColor)
			QListViewItem.paintCell(self,p,_cg,column,width,alignment)
		else:
			QListViewItem.paintCell(self,p,cg,column,width,alignment)
			
	def setBackgroundColor(self, color):
		self.bgColor = color
		
	def compare(self, i , col, ascending):
		key1 = self.key(col, ascending)
		key2 = i.key(col, ascending)
		return cmp(key1, key2)

	def key(self, column, ascending):
		return "M"+str(self.text(column))

	def acceptDrag(self, event): return False

	def okRename(self, column):
		oldText = self.text(column)
		QListViewItem.okRename(self, column)
		newText = self.text(column)
		self.listView().lib.renameAlbum(self.path, newText) # need to send item and new text now
		#update path to new value
		self.path[len(self.path)-1] = str(newText)
		
	def iconFileName(self): return #override this
		
	def loadPopupMenu(self, popup, actions):
		actions.action("burnAlbum").plug(popup)


class LPhotoAlbumItem(LBaseListViewItem):
	def __init__(self, parent, path, name):
		LBaseListViewItem.__init__(self, parent, path, name)
		self.setDragEnabled(True)
		self.setDropEnabled(True)

	def acceptDrag(self, event):
		return (self != self.listView().currentItem() and LPhotoKeysDrag.canDecode(event)) or  LAlbumDrag.canDecode(event) or QUriDrag.canDecode(event)

	def dropped(self, event):
		if LPhotoKeysDrag.canDecode(event):
			keys = LPhotoKeysDrag.getKeys(event)
			srcPath = LPhotoKeysDrag.getAlbumPath(event)
			self.listView().emit(PYSIGNAL("addPhotos"), (self.path, keys, srcPath))
			return True
		elif LAlbumDrag.canDecode(event):
			# dropped an album on this album.  Add this album to its children
			path = LAlbumDrag.decode(event)
##~ 			print "MoveSub Album",path,"->",self.path
			self.listView().emit(PYSIGNAL("moveAlbum"),(self.path, path))
			return False
		elif QUriDrag.canDecode(event):
			files = QStringList()
			QUriDrag.decodeLocalFiles(event, files)
			source = LDragImport(files, self.path)
			self.listView().emit(PYSIGNAL("dragImport"), (source, None))

	def iconFileName(self): 
		if self.childCount():
			return "sourcelibrary2.png"
		else:
			return "sourcealbum2.png"
			
	def loadPopupMenu(self, popup, actions):
		actions.action("renameAlbum").plug(popup)
		actions.action("removeAlbum").plug(popup)
		actions.action("burnAlbum").plug(popup)
		

class LMasterAlbumItem(LBaseListViewItem):
	def __init__(self, parent, path, name):
		LBaseListViewItem.__init__(self, parent, path, i18n("Photo Library"))
		self.setRenameEnabled(0, False)
		self.master = True

	def key(self, column, ascending):
		if ascending:
			return " "
		else:
			return "Z"

	def acceptDrag(self, event):
		#accept file or trash drags
		return QUriDrag.canDecode(event) or (LPhotoKeysDrag.canDecode(event) and LPhotoKeysDrag.getAlbumPath(event)[0] == "Trash")

	def dropped(self, event):
		if QUriDrag.canDecode(event):
			files = QStringList()
			QUriDrag.decodeLocalFiles(event, files)
		elif LPhotoKeysDrag.canDecode(event):
			keys = LPhotoKeysDrag.getKeys(event)
			srcPath = LPhotoKeysDrag.getAlbumPath(event)
			self.listView().emit(PYSIGNAL("addPhotos"), (self.path, keys, srcPath))

	def iconFileName(self): return "sourcelibrary0.png"

class LTrashAlbumItem(LBaseListViewItem):
	def __init__(self, parent):
		LBaseListViewItem.__init__(self, parent, [], i18n("Trash"))
		self.setRenameEnabled(0, False)

	def key(self, column, ascending):
		if ascending:
			return "Z"
		else:
			return " "

	def acceptDrag(self, event):
		return LPhotoKeysDrag.canDecode(event) or LAlbumDrag.canDecode(event)

	def dropped(self, event):
		if LPhotoKeysDrag.canDecode(event):
			keys = LPhotoKeysDrag.getKeys(event)
			albumName = LPhotoKeysDrag.getAlbumPath(event)
##~ 			print "Dropped",albumName,":",keys
			#self.listView().lib.trashKeyList(self.listView().currentItem().text(0), keys) # better method for getting library
			self.listView().emit(PYSIGNAL("trashKeyList"),(albumName, keys))

		elif LAlbumDrag.canDecode(event):
			path = LAlbumDrag.decode(event)
			self.listView().removeAlbum(path)

	def iconFileName(self): return "sourcetrash.png"

	def loadPopupMenu(self, popup, actions):
		actions.action("emptyTrash").plug(popup)


class LRollAlbumItem(LBaseListViewItem):
	def __init__(self, parent, path, name):
		LBaseListViewItem.__init__(self, parent, path, i18n("Latest Import"))
		self.setRenameEnabled(0, False)

	def key(self, column, ascending):
		if ascending:
			return "2"
		else:
			return "X"

	def acceptDrag(self, event): return False

	def iconFileName(self):  return "sourceimport.png"

class LSmartAlbumItem(LBaseListViewItem):
	def __init__(self, parent, text):
		LBaseListViewItem.__init__(self, parent, text)

	def key(self, column, ascending):
		if ascending:
			return "3"
		else:
			return "W"

	def acceptDrag(self, event): return False

	def iconFileName(self): return "sourcesmartalbum.png"
