#ifndef _LIBXML2_LIBXML_XMLSCHEMASTYPES_H_
#define _LIBXML2_LIBXML_XMLSCHEMASTYPES_H_

#include <libxml2/libxml/xmlstring.h>
#include <libxml2/libxml/tree.h>
#include <libxml2/libxml/xmlregexp.h>

#ifdef __cplusplus
extern "C" {
#endif




    typedef struct _xmlSchemaType xmlSchemaType;

    typedef xmlSchemaType *xmlSchemaTypePtr;

    typedef struct _xmlSchemaVal xmlSchemaVal;

    typedef xmlSchemaVal *xmlSchemaValPtr;

    typedef enum {
	XML_SCHEMAS_UNKNOWN = 0,
	XML_SCHEMAS_STRING = 1,
	XML_SCHEMAS_NORMSTRING = 2,
	XML_SCHEMAS_DECIMAL = 3,
	XML_SCHEMAS_TIME = 4,
	XML_SCHEMAS_GDAY = 5,
	XML_SCHEMAS_GMONTH = 6,
	XML_SCHEMAS_GMONTHDAY = 7,
	XML_SCHEMAS_GYEAR = 8,
	XML_SCHEMAS_GYEARMONTH = 9,
	XML_SCHEMAS_DATE = 10,
	XML_SCHEMAS_DATETIME = 11,
	XML_SCHEMAS_DURATION = 12,
	XML_SCHEMAS_FLOAT = 13,
	XML_SCHEMAS_DOUBLE = 14,
	XML_SCHEMAS_BOOLEAN = 15,
	XML_SCHEMAS_TOKEN = 16,
	XML_SCHEMAS_LANGUAGE = 17,
	XML_SCHEMAS_NMTOKEN = 18,
	XML_SCHEMAS_NMTOKENS = 19,
	XML_SCHEMAS_NAME = 20,
	XML_SCHEMAS_QNAME = 21,
	XML_SCHEMAS_NCNAME = 22,
	XML_SCHEMAS_ID = 23,
	XML_SCHEMAS_IDREF = 24,
	XML_SCHEMAS_IDREFS = 25,
	XML_SCHEMAS_ENTITY = 26,
	XML_SCHEMAS_ENTITIES = 27,
	XML_SCHEMAS_NOTATION = 28,
	XML_SCHEMAS_ANYURI = 29,
	XML_SCHEMAS_INTEGER = 30,
	XML_SCHEMAS_NPINTEGER = 31,
	XML_SCHEMAS_NINTEGER = 32,
	XML_SCHEMAS_NNINTEGER = 33,
	XML_SCHEMAS_PINTEGER = 34,
	XML_SCHEMAS_INT = 35,
	XML_SCHEMAS_UINT = 36,
	XML_SCHEMAS_LONG = 37,
	XML_SCHEMAS_ULONG = 38,
	XML_SCHEMAS_SHORT = 39,
	XML_SCHEMAS_USHORT = 40,
	XML_SCHEMAS_BYTE = 41,
	XML_SCHEMAS_UBYTE = 42,
	XML_SCHEMAS_HEXBINARY = 43,
	XML_SCHEMAS_BASE64BINARY = 44,
	XML_SCHEMAS_ANYTYPE = 45,
	XML_SCHEMAS_ANYSIMPLETYPE = 46
    } xmlSchemaValType;








    extern int xmlSchemaValPredefTypeNode(xmlSchemaTypePtr,
					  const xmlChar *,
					  xmlSchemaValPtr *, xmlNodePtr);
    extern xmlChar *xmlSchemaCollapseString(const xmlChar *);
    extern void xmlSchemaCleanupTypes(void);
    extern xmlSchemaValType xmlSchemaGetValType(xmlSchemaValPtr);
    extern void xmlSchemaFreeValue(xmlSchemaValPtr);
    extern void xmlSchemaInitTypes(void);
    extern int xmlSchemaGetCanonValue(xmlSchemaValPtr, const xmlChar * *);
    extern int xmlSchemaCompareValues(xmlSchemaValPtr, xmlSchemaValPtr);
    extern xmlSchemaTypePtr xmlSchemaGetBuiltInType(xmlSchemaValType);
#ifdef __cplusplus
}
#endif
#endif
