/*
 * proto.h -- common function protoypes for lslk
 *
 * V. Abell
 * Purdue University Computing Center
 */


/* $Id: proto.h,v 1.5 99/11/10 14:56:35 abe Exp $ */


/*
 * Copyright 1996 Purdue Research Foundation, West Lafayette, Indiana
 * 47907.  All rights reserved.
 *
 * Written by Victor A. Abell.
 *
 * This software is not subject to any license of the American Telephone
 * and Telegraph Company or the Regents of the University of California.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Neither the authors nor Purdue University are responsible for any
 *    consequences of the use of this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to the authors and Purdue
 *    University must appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */


/*
 * The _PROTOTYPE macro provides strict ANSI C prototypes if __STDC__
 * is defined, and old-style K&R prototypes otherwise.
 *
 * (With thanks to Andy Tanenbaum)
 */

#if	defined(__STDC__)
#define	_PROTOTYPE(function, params)	function params
#else
#define	_PROTOTYPE(function, params)	function()
#endif /* defined(__STDC__) */
 


/*
 * Local function prototypes
 */

_PROTOTYPE(extern int comppid,(COMP_P *a1, COMP_P *a2));
_PROTOTYPE(extern struct in_addr *alloc_in_addr,(void));
_PROTOTYPE(extern void alloc_llock,(void));
_PROTOTYPE(extern void Exit,(int xv));
_PROTOTYPE(extern int enter_inum,(char *opt));
_PROTOTYPE(extern int enter_nwad,(char *opt));
_PROTOTYPE(extern int enter_pid,(char *opt));
_PROTOTYPE(extern void gather_lock_info,(void));
_PROTOTYPE(extern char *get_cmdnm,(struct llock_info *lp));
_PROTOTYPE(extern struct lhaddr *get_haddr,(int t, char *h, unsigned long a, int *e));
_PROTOTYPE(extern void initialize,(void));
_PROTOTYPE(extern int is_lock_sel,(void));
_PROTOTYPE(extern int is_readable,(char *path, int msg));
_PROTOTYPE(extern int kread,(KA_T addr, char *buf, int len));
_PROTOTYPE(extern char *print_dev,(struct llock_info *lp));
_PROTOTYPE(extern void print_lock_info,(struct llock_info **sp));
_PROTOTYPE(extern char *Readlink,(char *arg));
_PROTOTYPE(extern int readmnt,(void));
_PROTOTYPE(extern int statsafely,(char *path, struct stat *buf));
_PROTOTYPE(extern void usage,(int xv));

#if	defined(WILLDROPGID)
_PROTOTYPE(extern void dropgid,(void));
#endif	/* defined(WILLDROPGID) */
