/* vi: set sw=4 ts=4: */
/*
 * gtkchinesecalendar.h: This file is part of lunar-applet.
 *
 * Copyright (C) 2007 yetist <yetist@gmail.com>
 *
 * Copyright (C) 1998 Cesar Miquel and Shawn T. Amundson
 * 
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 * */

 /* This file is a modified version of the gtk/gtkcalendar.c file
  * in gtk+ at ftp://ftp.gtk.org/pub/gtk/
  * */

#ifndef __GTKCHINESECALENDAR_H__ 
#define __GTKCHINESECALENDAR_H__  1

G_BEGIN_DECLS

#include <gtk/gtk.h>

#define GTK_TYPE_CHINESE_CALENDAR                  (gtk_chinese_calendar_get_type ())
#define GTK_CHINESE_CALENDAR(obj)                  (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_CHINESE_CALENDAR, GtkChineseCalendar))
#define GTK_CHINESE_CALENDAR_CLASS(klass)          (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_CHINESE_CALENDAR, GtkChineseCalendarClass))
#define GTK_IS_CHINESE_CALENDAR(obj)               (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_CHINESE_CALENDAR))
#define GTK_IS_CHINESE_CALENDAR_CLASS(klass)       (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_CHINESE_CALENDAR))
#define GTK_CHINESE_CALENDAR_GET_CLASS(obj)        (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_CHINESE_CALENDAR, GtkChineseCalendarClass))


typedef struct _GtkChineseCalendar	      GtkChineseCalendar;
typedef struct _GtkChineseCalendarClass       GtkChineseCalendarClass;

typedef struct _GtkChineseCalendarPrivate     GtkChineseCalendarPrivate;

typedef enum
{
  GTK_CHINESE_CALENDAR_SHOW_HEADING		= 1 << 0,
  GTK_CHINESE_CALENDAR_SHOW_DAY_NAMES		= 1 << 1,
  GTK_CHINESE_CALENDAR_NO_MONTH_CHANGE		= 1 << 2,
  GTK_CHINESE_CALENDAR_SHOW_WEEK_NUMBERS	= 1 << 3,
  GTK_CHINESE_CALENDAR_WEEK_START_MONDAY	= 1 << 4,
  GTK_CHINESE_CALENDAR_SHOW_LUNAR_DATE          = 1 << 5
} GtkChineseCalendarDisplayOptions;

struct _GtkChineseCalendar
{
  GtkWidget widget;
  
  GtkStyle  *header_style;
  GtkStyle  *label_style;
  
  gint month;
  gint year;
  gint selected_day;
  
  gint day_month[6][7];
  gint day[6][7];
  
  gint num_marked_dates;
  gint marked_date[31];
  GtkChineseCalendarDisplayOptions  display_flags;
  GdkColor marked_date_color[31];
  
  GdkGC *gc;			/* unused */
  GdkGC *xor_gc;		/* unused */

  gint focus_row;
  gint focus_col;

  gint highlight_row;
  gint highlight_col;
  
  GtkChineseCalendarPrivate *priv;
  gchar grow_space [32];

  /* Padding for future expansion */
  void (*_gtk_reserved1) (void);
  void (*_gtk_reserved2) (void);
  void (*_gtk_reserved3) (void);
  void (*_gtk_reserved4) (void);
};

struct _GtkChineseCalendarClass
{
  GtkWidgetClass parent_class;
  
  /* Signal handlers */
  void (* month_changed)		(GtkChineseCalendar *calendar);
  void (* day_selected)			(GtkChineseCalendar *calendar);
  void (* day_selected_double_click)	(GtkChineseCalendar *calendar);
  void (* prev_month)			(GtkChineseCalendar *calendar);
  void (* next_month)			(GtkChineseCalendar *calendar);
  void (* prev_year)			(GtkChineseCalendar *calendar);
  void (* next_year)			(GtkChineseCalendar *calendar);
  
};


GType	   gtk_chinese_calendar_get_type	(void) G_GNUC_CONST;
GtkWidget* gtk_chinese_calendar_new		(void);

gboolean   gtk_chinese_calendar_select_month	(GtkChineseCalendar *calendar, 
					 guint	      month,
					 guint	      year);
void	   gtk_chinese_calendar_select_day	(GtkChineseCalendar *calendar,
					 guint	      day);

gboolean   gtk_chinese_calendar_mark_day	(GtkChineseCalendar *calendar,
					 guint	      day);
gboolean   gtk_chinese_calendar_unmark_day	(GtkChineseCalendar *calendar,
					 guint	      day);
void	   gtk_chinese_calendar_clear_marks	(GtkChineseCalendar *calendar);


void	   gtk_chinese_calendar_set_display_options (GtkChineseCalendar    	      *calendar,
					     GtkChineseCalendarDisplayOptions flags);
GtkChineseCalendarDisplayOptions
           gtk_chinese_calendar_get_display_options (GtkChineseCalendar   	      *calendar);
#ifndef GTK_DISABLE_DEPRECATED
void	   gtk_chinese_calendar_display_options (GtkChineseCalendar		  *calendar,
					 GtkChineseCalendarDisplayOptions flags);
#endif

void	   gtk_chinese_calendar_get_date	(GtkChineseCalendar *calendar, 
					 guint	     *year,
					 guint	     *month,
					 guint	     *day);
#ifndef GTK_DISABLE_DEPRECATED
void	   gtk_chinese_calendar_freeze		(GtkChineseCalendar *calendar);
void	   gtk_chinese_calendar_thaw		(GtkChineseCalendar *calendar);
#endif

G_END_DECLS

#endif /* __GTKCHINESECALENDAR_H__ */

/*
vi:ts=4:wrap:ai:expandtab
*/
