<?php
/*
    LWAT, LDAP Webbased Administration Tool
    Copyright (C) 2007 Finn-Arne Johansen <faj@bzz.no> BzzWare AS, Norway

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/


require_once ('functions.php') ;
loadConfig () ; 
session_start() ;
ob_start () ; 

loadLocale () ;
$authenticated = ($_COOKIE['Authenticated'] == "True") ;
$key = $_SESSION['key'] ;
if ($key == "") {
    $key = crypt(sprintf (gettimeofday (true))) ;
    $_SESSION['key'] = $key ; 
    if ($authenticated) {
	setcookie ("Authenticated", "False") ;
    }
    $authenticated = false ; 
} 
$ldap=ldap_connect ($ldaphost); 
ldap_set_option($ldap, LDAP_OPT_PROTOCOL_VERSION, 3);
@ldap_start_tls($ldap) ; 
if ($authenticated) {
    $admindn = $_COOKIE['admindn'] ; 
    $adminpw = xorstring ($key, $_COOKIE['xorstring']) ; 
    $authenticated = ($adminpw <> "") ;
}
if ($authenticated) 
    $bind = @ldap_bind ($ldap, $admindn, $adminpw); 
else 
    $bind = @ldap_bind ($ldap) ;

unset ($admindn, $adminpw, $key) ; 
echo "<html>\n" ; 
echo "    <head>\n" ;
header('Content-type: text/html; charset=UTF-8');
echo "        <title>lwat Debian-Edu fixup</title>\n" ; 
echo "    </head>\n" ;
echo "    <body>\n" ; 
echo "<form name=fixup method=post action=fixup.php>\n" ; 
echo '<INPUT type=hidden name=Action value=Personal_Groups>'; 
print (_("Check") . ' <INPUT type=submit name="submit" value="' . _("Personal Groups") . '"> ?'); 
print ('</form>') ; 
echo "<form name=fixup method=post action=fixup.php>\n" ; 
echo '<INPUT type=hidden name=Action value=Empty_Groups>'; 
print (_("Check") . ' <INPUT type=submit name="submit" value="' . _("Empty Groups") . '"> ?'); 
print ('</form>') ; 
$action = readKey ('Action') ; 
switch ($action) {
    case "": break ;
    case "Personal_Groups":
	$filter="(&(objectClass=lisGroup)(groupType=private))" ; 
	$want = array ('cn') ; 
	$result= ldap_search ($ldap, $base, $filter, $want);
	$entries= ldap_get_entries ($ldap, $result);
	if ($entries['count']) {
	    printf(_("There are %d lisGroups that is of type private."),$entries['count']);
	    #print (_("There is ") . $entries['count'] . " " ) ;
	    #print (_("lisGroups that is of type private")) ; 
	    if ($authenticated) {
		print ("<form name=convert_from_lisGroup method=post>") ; 
		print ("<INPUT type=hidden name=Action value='convert_from_lisGroup'>") ; 
		print ("<INPUT type=submit name=submit value='" . _("Convert from lisGroup") . "'> ") ;
		print ("</form>") ; 
		break ; 
            } else 
                $needToLogin = true ; 
	} else {
	    print (_("Could not find any lisGroups with groupType=private") . "<BR>") ;
	}
    case "move_around_the_groups":
	$filter="(&(objectClass=posixGroup)(!(memberUid=*)))" ; 
	$want = array ('cn', 'gidNumber') ; 
	$result= ldap_search ($ldap, $groupbase, $filter, $want);
	$entries= ldap_get_entries ($ldap, $result);
	$count=0 ;
	$filter = "" ;
	$want = array () ; 
	for ($i = 0 ; $i < $entries['count'] ; $i++) {
	    $filter .= "(gidNumber=" . $entries[$i]['gidnumber'][0] . ")";
	}
	unset ($entries) ; 
	if (!empty($filter)) {
	    $want = array ('gidNumber') ; 
	    $filter="(&(|" . $filter . ")(objectClass=posixAccount))" ;
	    $result=ldap_search ($ldap, $base, $filter, $want);
	    $count = ldap_count_entries ($ldap, $result) ; 
	}
        if (!$count) { 
	    print (_("Could not find any personal groups that are located under the Group OU")) ;
	    break ;
	}
        if (0 == strcmp ($action, "move_around_the_groups")) {
            $entries = ldap_get_entries ($ldap, $result) ; 
	    for ($i = 0 ; $i < $entries['count'] ; $i++) {
	        $persondn = ldap_explode_dn ($entries[$i]['dn'],0); 
		array_shift($persondn) ; 
	        $filter = '(&(gidNumber=' . 
	                  $entries[$i]['gidnumber'][0] .
	                  ')(objectClass=posixGroup))' ; 
		$result=ldap_search ($ldap, $base, $filter, $want);
		$found=ldap_first_entry ($ldap, $result) ; 
		$groupdn = ldap_explode_dn (ldap_get_dn($ldap, $found), 0) ; 
		array_shift($groupdn) ; 
		array_shift($persondn) ; 
		$personou=implode(",", $persondn) ; 
		$olddn=implode(",", $groupdn) ; 
		if (ldap_rename ($ldap, implode (",", $groupdn), $groupdn[0], implode (",", $persondn), true)) {
		    printf(_("Moved %s to %s,%s"),$olddn, $groupdn[0], $personou);
		    echo "<BR>";
		    #echo _('Moved') . " $olddn " . _('to') ." $groupdn[0],$personou<BR>\n" ; 
		} else {
		    printf(_("Failed to move %s to %s,%s"),$olddn, $groupdn[0],$personou);
		    echo "<BR>";
		    #echo _('Failed to move') . " $olddn " . _('to') ." $groupdn[0],$personou<BR>\n" ; 
		    echo _("The reason we got from the ldap server was this:") . ldap_error ($ldap) . "<BR>\n" ; 
		}
		ob_end_flush () ;
	    }
	    unset ($entries) ; 
            break ;
        }
	printf (_("There are %s personal groups in the group OU that could(should) be moved into the personal OU's"), $count );
	echo "<BR>";
	#print (_("personal groups in the group OU that could(should) ")) ; 
	#print (_("be moved into the personal OU's") . "<BR>") ;
	if ($authenticated) {
	    print ("<form name=move_groups_to_OU method=post>") ; 
	    print ("<INPUT type=hidden name=Action value='move_around_the_groups'>") ; 
	    print ("<INPUT type=submit name=Submit " . 
		     "value='" . _("move around the groups") . "'>") ; 
	    print ("</form>") ; 
	} else 
	    $needToLogin = true ; 
	break ;
    case "remove_empty_groups":
    case "Empty_Groups":
	$filter="(&(objectClass=posixGroup)(!(memberUid=*)))" ; 
	$want = array ('cn', 'gidNumber') ; 
	$result= ldap_search ($ldap, $groupbase, $filter, $want);
	$entries= ldap_get_entries ($ldap, $result);
	$count=$entries['count'] ; 
	$filter = "" ;
	$want = array () ; 
	for ($i = 0 ; $i < $entries['count'] ; $i++) {
	    $filter .= "(gidNumber=" . $entries[$i]['gidnumber'][0] . ")";
	}
	if (!empty($filter)) {
	    $want = array ('gidNumber') ; 
	    $filter="(&(|" . $filter . ")(objectClass=posixAccount))" ;
	    $result=ldap_search ($ldap, $base, $filter, $want);
	    $count = $count - ldap_count_entries ($ldap, $result) ; 
	}
        if (!$count) { 
	    print (_("Could not find any empty groups")) ;
	    break ;
	}
        if (0 == strcmp ($action, "remove_empty_groups")) {
            $want = array () ; 
	    for ($i = 0 ; $i < $entries['count'] ; $i++) {
	        $filter = '(&(gidNumber=' . 
	                  $entries[$i]['gidnumber'][0] .
	                  ')(objectClass=posixAccount))' ; 
		$result=ldap_search ($ldap, $base, $filter, $want);
		if (0 == ldap_count_entries ($ldap, $result)) ; 
		if (@ldap_delete ($ldap, $entries[$i]['dn']))
		    echo _('Removed empty group ') . 
		         $entries[$i]['dn'] . "<BR>\n" ; 
		else {
		    echo _('Failed to remove empty group ') . 
		         $entries[$i]['dn'] . "<BR>\n" ; 
		    echo _("The reason we got from the ldap server was this:") . ldap_error ($ldap) . "<BR>\n" ; 
		}
		ob_end_flush () ;
	    }
	    unset ($entries) ; 
            break ;
        }
	printf (_("There are %s empty groups."), $count); 
	if ($authenticated) {
	    print ("<form name=remove_empty_groups method=post>") ; 
	    print ("<INPUT type=hidden name=Action value='remove_empty_groups'>") ; 
	    print ("<INPUT type=submit name=Submit " . 
		     "value='" . _("Remove the empty groups") . "'>") ; 
	    print ("</form>") ; 
	} else 
	    $needToLogin = true ; 
	break ;
    case "login": 
	if (!$authenticated && 
	     isset ($_POST['admindn']) && 
	     isset ($_POST['adminpw'])) {
	    $adminUser=readKey('admindn') ;
	    $filter = '(|(&(objectClass=posixAccount)(uid=' . $adminUser . '))(&(objectClass=simpleSecurityObject)(cn=' . $adminUser . ')))' ; 
	    $want = array () ; 
	    $result = ldap_search($ldap, $base, $filter, $want);
	    $entries = ldap_get_entries ($ldap, $result); 
	    $admindn = $entries[0]['dn'] ; 
	    $adminpw=readKey('adminpw') ;
	    $bind = @ldap_bind ($ldap, $admindn, $adminpw); 
	    if ($bind) {
		$key = $_SESSION['key'] ;
		$xorstring= xorstring ($key, $adminpw); 
		setcookie ('Authenticated', 'True') ;
		setcookie ('admindn', $admindn) ;
		setcookie ('xorstring', $xorstring) ;
		break ; 
	    }
	}
	print ('<H2>' . _("You need to login before changing/adding anything") . '</H2>') ; 
	print ('<form method=post name=askauth>') ; 
	print (_('Login name:') . '<BR>') ; 
	print ('<input type=text name=admindn><BR>') ; 
	print (_('Login password:') . '<BR>') ;
	print ('<input type=password name=adminpw><BR>') ;
	print ('<input type=submit name=Action value=login>') ;
	print ('<input type=reset name=reset value=Reset>') ;
	print ('</form>') ; 
	break ;
    default:
	echo "Function not implemented (yet). This is som debug info:" ;
	debug ($_POST);
	break ;
}

ldap_close ($ldap); 
if ($needToLogin)  {
    print ("<form name=need_to_login method=post>") ; 
    print ('<BR>' . _("You need to") . ' <input Type=submit name=Action value=login>') ; 
    print ('</form>') ; 
}

echo "    </body>\n" ; 
echo "</html>\n" ; 
?>
