Name: mod_auth_shadow
Version: 2.1
Release: 1
Source: ftp://mod-auth-shadow.sourceforge.net/pub/mod-auth-shadow/%{name}-%{version}.tar.gz
License: GPL
Group: System Environment/Daemons
Summary: An Apache module for authentication using /etc/shadow
BuildRoot: /var/tmp/%{name}-rpmroot
%description

When performing this task one encounters one fundamental
difficulty: The /etc/shadow file is supposed to be
read/writeable only by root.  However, the webserver is
supposed to run under a non-root user, such as "nobody".

mod_auth_shadow addresses this difficulty by opening a pipe
to an suid root program, validate, which does the actual
validation.  When there is a failure, validate writes an
error message to the system log, and waits three seconds
before exiting.

%prep
%setup

%build
gcc -o validate validate.c -lcrypt
make all

%install
mkdir -p $RPM_BUILD_ROOT/usr/{sbin,lib/httpd/modules}
install -s validate $RPM_BUILD_ROOT/usr/sbin/
install .libs/mod_auth_shadow.so $RPM_BUILD_ROOT/usr/lib/httpd/modules

%post
( echo 'LoadModule auth_shadow_module  /usr/lib/httpd/modules/mod_auth_shadow.so'
  ) >>/etc/httpd/conf/httpd.conf

%preun
perl -ni -le 'print unless /mod_auth_shadow/' /etc/httpd/conf/httpd.conf

%changelog
* Mon Sep 26 2005 Brian Duggan <bduggan@matatu.org>
    - version 2.1
    - auth_shadow_valid_user now DECLINEs for AuthShadow off
    - uses apxs instead of apxs2 by default

* Mon Jan 6 2003 Bernard du Breuil <bernard.l.dubreuil@erdc.usace.army.mil>
  - version 2.0
    port to apache 2 API
    reentrant versions of functions

* Tue Nov 7 2000 Brian Duggan <bduggan@oven.com>
  - version 1.3
    added check for user's primary group id = group id with require group directive
    removed explicit restriction that validate.c be suid root.

* Mon Oct 30 2000 Brian Duggan <bduggan@oven.com>
  - version 1.2
    Added support for require user and require group directives.
    Changed error reporting to use ap_error_log instead of printing
    to stderr.

* Mon Oct 2 2000 Brian Duggan <bduggan@oven.com>
  - version 1.1
  Closed fd's after dup2(2), added stuff to validate.h

* Wed Sep 27 2000 Brian Duggan <bduggan@oven.com> 
  - version 1.0
    Added AuthShadow directive, and a few small sanity checks.

* Tue Sep 19 2000 Brian Duggan <bduggan@oven.com>
  - version 0.81: added DECLINED returns unless realm is AuthShadow

* Thu Sep 14 2000 Bennett Todd <bet@rahul.net>
  - Initial wrap

%files
%defattr(-,root,root)
%attr(4755,root,root) /usr/sbin/validate
/usr/lib/httpd/modules/*
%doc CHANGES INSTALL README makefile
