/* This file is part of libccc
 *
 * AUTHORS
 *     Sven Herzberg  <herzi@gnome-de.org>
 *
 * Copyright (C) 2007  Sven Herzberg
 *
 * This work is provided "as is"; redistribution and modification
 * in whole or in part, in any medium, physical or electronic is
 * permitted without restriction.
 *
 * This work is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * In no event shall the authors or contributors be liable for any
 * direct, indirect, incidental, special, exemplary, or consequential
 * damages (including, but not limited to, procurement of substitute
 * goods or services; loss of use, data, or profits; or business
 * interruption) however caused and on any theory of liability, whether
 * in contract, strict liability, or tort (including negligence or
 * otherwise) arising in any way out of the use of this software, even
 * if advised of the possibility of such damage.
 */

#ifndef G_TYPE_PRIVATE_DEMO_H
#define G_TYPE_PRIVATE_DEMO_H

#include <glib-object.h>

G_BEGIN_DECLS

typedef struct _GPrivateDemo        GPrivateDemo;
typedef struct _GPrivateDemoPrivate GPrivateDemoPrivate;
typedef struct _GPrivateDemoClass   GPrivateDemoClass;

#define G_TYPE_PRIVATE_DEMO         (g_private_demo_get_type ())
#define G_PRIVATE_DEMO(i)           (G_TYPE_CHECK_INSTANCE_CAST ((i), G_TYPE_PRIVATE_DEMO, GPrivateDemo))
#define G_PRIVATE_DEMO_CLASS(c)     (G_TYPE_CHECK_CLASS_CAST ((c), G_TYPE_PRIVATE_DEMO, GPrivateDemo))
#define G_IS_PRIVATE_DEMO(i)        (G_TYPE_CHECK_INSTANCE_TYPE ((i), G_TYPE_PRIVATE_DEMO))
#define G_IS_PRIVATE_DEMO_CLASS(c)  (G_TYPE_CHECK_CLASS_TYPE ((c), G_TYPE_PRIVATE_DEMO))
#define G_PRIVATE_DEMO_GET_CLASS(i) (G_TYPE_INSTANCE_GET_PRIVATE ((c), G_TYPE_PRIVATE_DEMO, GTypePrivateDemoClass))

GType g_private_demo_get_type (void);

struct _GPrivateDemo {
	GObject              base_instance;
	GPrivateDemoPrivate* _private;
};

struct _GPrivateDemoClass {
	GObjectClass base_class;
};

G_END_DECLS

#endif /* !G_TYPE_PRIVATE_DEMO_H */
