/* This file is part of libccc
 *
 * AUTHORS
 *     Sven Herzberg  <herzi@gnome-de.org>
 *
 * Copyright (C) 2007  Sven Herzberg
 *
 * This work is provided "as is"; redistribution and modification
 * in whole or in part, in any medium, physical or electronic is
 * permitted without restriction.
 *
 * This work is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * In no event shall the authors or contributors be liable for any
 * direct, indirect, incidental, special, exemplary, or consequential
 * damages (including, but not limited to, procurement of substitute
 * goods or services; loss of use, data, or profits; or business
 * interruption) however caused and on any theory of liability, whether
 * in contract, strict liability, or tort (including negligence or
 * otherwise) arising in any way out of the use of this software, even
 * if advised of the possibility of such damage.
 */

#include "s-item.h"

#include <ccc/cc-brush-color.h>
#include <ccc/cc-camera.h>
#include <ccc/cc-circle.h>
#include <ccc/cc-text.h>

static CcItemClass* item_class = NULL;
static CcItemClass* text_class = NULL;

static void
setup (void)
{
	item_class = g_type_class_ref (CC_TYPE_ITEM);
	text_class = g_type_class_ref (CC_TYPE_TEXT);
}

static void
teardown (void)
{
	g_type_class_unref (item_class);
	item_class = NULL;
	g_type_class_unref (text_class);
	text_class = NULL;
}

START_TEST(test_initial_size)
{
	fail_unless (item_class->view_data_size != 0);
	fail_unless (text_class->view_data_size != 0);
}
END_TEST

START_TEST(test_camera)
{
	CcItem* item   = g_object_ref_sink (cc_item_new ());
	CcItem* demo   = cc_text_new ("Sliff Sloff Slubb");
	CcItem* camera = cc_camera_new_root (demo);
	cc_item_append (item, demo);
	cc_item_append (item, camera);
	g_object_unref (item);
}
END_TEST

// FIXME: test_mem_alignment

TCase*
tcase_item_view_data (void)
{
	TCase* self = tcase_create ("view-related data");
	tcase_add_checked_fixture (self, setup, teardown);
	tcase_add_test (self, test_initial_size);
	tcase_add_test (self, test_camera);
	return self;
}

