/***************************************************************************
                           cbz.cpp  -  description
                             -------------------
    begin                : Wed May 15 2002
    copyright            : (C) 2002-2004 by Mathias Kster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>

#define BZ_NO_STDIO
#include <bzlib.h>

#include <dclib/core/cbytearray.h>

#include "cbz.h"

#define MAX_BUFFER_LEN	536870912	// 512MiB max memory

/** */
CBZ::CBZ()
{
}

/** */
CBZ::~CBZ()
{
}

/** */
bool CBZ::Compress( CByteArray * src, CByteArray * dst )
{
	bool err = FALSE;
	int i;
	unsigned int inlen,outlen;
	char * buffer = 0;

	// sanity check
	if ( (!src) || (!dst) )
		return err;

	inlen  = src->Size();
	outlen = src->Size();

	dst->SetSize(0);

	while(TRUE)
	{
		outlen *= 2;
		
		// check for max memory
		if ( outlen > MAX_BUFFER_LEN )
		{
			printf("CBZ::Compress: max mem reached\n");			
			break;
		}
		
		// free buffer and try again
		if ( buffer )
			free(buffer);
		
		buffer = (char*) malloc(outlen);

		// sanity check
		if ( !buffer )
		{
			printf("CBZ::Compress: malloc failed\n");
			break;
		}
		
		i = BZ2_bzBuffToBuffCompress( buffer, &outlen, (char*)src->Data(), inlen, 9, 0, 0);

		// check result
		if ( i == BZ_OK )
		{
			dst->Append( (const unsigned char*)buffer, outlen );
			err = TRUE;
			break;
		}
		else if ( i == BZ_OUTBUFF_FULL )
		{
			// nothing, try again
		}
	}

	// cleanup memory 
	if ( buffer )
		free(buffer);

	return err;
}

/** */
bool CBZ::Decompress( CByteArray * src, CByteArray * dst )
{
	bool err = FALSE;
	int i;
	unsigned int inlen,outlen;
	char * buffer = 0;

	if ( (!src) || (!dst) )
		return err;

	inlen  = src->Size();
	outlen = src->Size();

	dst->SetSize(0);

	while(TRUE)
	{
		if ( outlen < (50 * 1024 * 1024) )
		{
			outlen *= 10;
		}
		else
		{
			outlen += (50 * 1024 * 1024);
		}
		
		// check for max memory
		if ( outlen > MAX_BUFFER_LEN )
		{
			printf("CBZ::Decompress: max mem reached\n");			
			break;
		}

		if(buffer)
			free(buffer);
		buffer = (char*) malloc(outlen);

		i = BZ2_bzBuffToBuffDecompress( buffer, &outlen, (char*)src->Data(), inlen, 0, 0);

		if( i == BZ_OK )
		{
			dst->Append( (const unsigned char*)buffer, outlen );
			err = TRUE;
			break;
		}
		else if ( i == BZ_OUTBUFF_FULL )
		{
			// nothing, try again
		}
		else
		{
			// another decompression error
			printf("CBZ::Decompress: failed with %d\n",i);			
			break;
		}
	}

	// cleanup memory 	
	if (buffer)
		free(buffer);

	return err;
}
