/**
 * @file libgalago-gtk/galago-gtk-service-list.h
 *       Service list widget
 *
 * @Copyright (C) 2005-2006 Christian Hammond.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */
#ifndef _GALAGO_GTK_SERVICE_LIST_H_
#define _GALAGO_GTK_SERVICE_LIST_H_

typedef struct _GalagoGtkServiceList      GalagoGtkServiceList;
typedef struct _GalagoGtkServiceListClass GalagoGtkServiceListClass;
typedef struct _GalagoGtkServiceListPriv  GalagoGtkServiceListPriv;

#include <libgalago/galago.h>
#include <gtk/gtktreeview.h>

#define GALAGO_GTK_TYPE_SERVICE_LIST (galago_gtk_service_list_get_type())
#define GALAGO_GTK_SERVICE_LIST(obj) \
		(G_TYPE_CHECK_INSTANCE_CAST((obj), GALAGO_GTK_TYPE_SERVICE_LIST, GalagoGtkServiceList))
#define GALAGO_GTK_SERVICE_LIST_CLASS(klass) \
		(G_TYPE_CHECK_CLASS_CAST((klass), GALAGO_GTK_TYPE_SERVICE_LIST, GalagoGtkServiceListClass))
#define GALAGO_GTK_IS_SERVICE_LIST(obj) \
		(G_TYPE_CHECK_INSTANCE_TYPE((obj), GALAGO_GTK_TYPE_SERVICE_LIST))
#define GALAGO_GTK_IS_SERVICE_LIST_CLASS(klass) \
		(G_TYPE_CHECK_CLASS_TYPE((klass), GALAGO_GTK_TYPE_SERVICE_LIST))
#define GALAGO_GTK_SERVICE_LIST_GET_CLASS(obj) \
		(G_TYPE_INSTANCE_GET_CLASS ((obj), GALAGO_GTK_TYPE_SERVICE_LIST, GalagoGtkServiceListClass))

typedef enum
{
	GALAGO_GTK_SERVICE_LIST_ITEM_UNSET = -1,
	GALAGO_GTK_SERVICE_LIST_ITEM_PEOPLE,
	GALAGO_GTK_SERVICE_LIST_ITEM_ALL_CONTACTS,
	GALAGO_GTK_SERVICE_LIST_ITEM_SERVICE

} GalagoGtkServiceListItemType;

struct _GalagoGtkServiceList
{
	GtkTreeView parent_object;

	GalagoGtkServiceListPriv *priv;

	void (*gtk_reserved1)(void);
	void (*gtk_reserved2)(void);
	void (*gtk_reserved3)(void);
	void (*gtk_reserved4)(void);
};

struct _GalagoGtkServiceListClass
{
	GtkTreeViewClass parent_class;

	/* Signals */
	void (*selection_changed)(GalagoGtkServiceList *service_list);
	void (*service_activated)(GalagoGtkServiceList *service_list,
							  GalagoGtkServiceListItemType type,
							  GalagoService *service);

	void (*gtk_reserved1)(void);
	void (*gtk_reserved2)(void);
	void (*gtk_reserved3)(void);
	void (*gtk_reserved4)(void);
};

G_BEGIN_DECLS

GType galago_gtk_service_list_get_type(void);

GtkWidget *galago_gtk_service_list_new(void);

void galago_gtk_service_list_set_show_people(GalagoGtkServiceList *list,
											 gboolean show_people);
void galago_gtk_service_list_set_show_all_contacts(GalagoGtkServiceList *list,
												   gboolean show_all_contacts);
void galago_gtk_service_list_set_service(GalagoGtkServiceList *list,
										 GalagoService *service);
void galago_gtk_service_list_set_item_type(GalagoGtkServiceList *list,
										   GalagoGtkServiceListItemType type);
void galago_gtk_service_list_set_valid_services(GalagoGtkServiceList *list,
												GList *services);

GalagoGtkServiceListItemType galago_gtk_service_list_get_item_type(
	const GalagoGtkServiceList *list);
GalagoService *galago_gtk_service_list_get_service(
	const GalagoGtkServiceList *list);

G_END_DECLS

#endif /* _GALAGO_GTK_SERVICE_LIST_H */
