# -*- mode: python -*-

%pythoncode %{
#--- end of code generated by swig ---

import libxml2

FORMAT_ENCRYPTED   = 0
FORMAT_UNENCRYPTED = 1

class Context(geier_context):
    """
    Implements a higher-level layer for libgeier's geier_context.

    """
    def validate(self, data, format=FORMAT_ENCRYPTED):
         """
         Check whether the XML data is valid according to the
         schema.

         'data' may be either a string or a libxml2.xmlDoc()
         'format' specifies the inpute data format. Set one of
           - encrypted (default)
           - unencrypted

         Please note: 'encrypted' is default, but not yet supported by the
         underlying libgeier.
         """
         if format == FORMAT_ENCRYPTED:
             raise NotImplementedError('validate(..., format_encrypted). Sorry')
         if isinstance(data, basestring):
             res = _geier._validate_text(self, format, data)
         else:
             res = _geier._validate(self, format, data._o)
         return not res # inverse logic


    def sign(self, data, softpse_filename, pincode):
         """
         Sign the XML data.
         
         'data' may be either a string or a libxml2.xmlDoc()
         'softpse_filename' is ...., 'pincode' the matching pincode.
         """
         if isinstance(data, basestring):
             res = _geier._dsig_sign_text(self, data,
                                          softpse_filename, pincode)
         else:
             res = _geier._dsig_sign(self, data._o,
                                     softpse_filename, pincode)
         return res


    def send(self, data, crypt=False):
         """
         Send Elster data and return response.
         
         'data' may be either a string or a libxml2.xmlDoc() If 'crypt'
         is true, data will be send encrypted and result will be
         decrypted.
         """
         if isinstance(data, basestring):
             res = _geier._send_text(self, data)
             errMsg = _geier._get_clearing_error_text(self, res)
         else:
             res = _geier._send(self, data._o)
             print `res`
             if res:
                 res = libxml2.xmlDoc(res)
             print `res`
             errMsg = _geier._get_clearing_error(self, res)
         return res, errMsg


    def as_html(self, data):
         """
         Convert the XML dadta into a HTML text.

         This is done by processing the official style-sheet on the data.

         'data' may be either a string or a libxml2.xmlDoc()
         """
         if isinstance(data, basestring):
             res = _geier._xsltify_text(self, data)
         else:
             res = _geier._xsltify(self, data._o)
             if res:
                 res = libxml2.xmlDoc(res)
         return res


import atexit
_geier._init(0)
atexit.register(_geier._exit)

%}
