#!/bin/bash
#
# Copyright (C) 2006 Hartmut Goebel <h.goebel@goebel-consult.de>
# Licence: GPL, see www.taxbird.de
#

progname=$(basename $0)
infile="$1"

cat <<EOF
//
// DO NOT EDIT THIS FILE
// This file has been created by $progname and will be overwritten
//

// strip 'GEIER_' prefix from erorr codes'
EOF
grep -E '^#define GEIER_ERROR' "$infile" | \
while read define sym value ; do
    echo "%rename(${sym/GEIER_}) $sym;"
done

echo
echo '// avoid importing functions into the python module'
grep -E 'geier_.+\(' "$infile" | \
while read result sym rest ; do
    new=${sym#*geier_}
    new=${new%%(*}
    sym=geier_${new}
    echo "%rename(_${new}) $sym;"
done

