/******************************************************************************************************************************************
 ccombobox.h

 CClass						CClass
 |--CSerialized					|--CSerialized
    |--CMetaModule				   |--CMetaModule
       |--CObject				      |--CObjectListener
          |--CComponent				         |
             |--CControl				 |
             |  |--CWidget				 |--CWidgetListener
             |     |--CComboBox				    |--CComboBoxListener
	     |        |--CComboBoxEntry			       |--CComboBoxEntryListener
	     |--CComboBoxItem

 CComboBoxEntry ==> { CComboBoxItem }
		      |==> { CItemFieldValue  ( CItemFieldValueString [at least one requiered], CItemFieldValuePixbuf ) }

 N.B. Only the m_FieldValue member of the CItemFieldValue classes is handled in the mapped model.
******************************************************************************************************************************************/

#ifndef __CCOMBOBOXENTRY_H__
#define __CCOMBOBOXENTRY_H__

#include "ccombobox.h"

//-----------------------------------------------------------------------------------------------------------------------------------------
//  CComboBoxEntryListener class
//-----------------------------------------------------------------------------------------------------------------------------------------
class CComboBoxEntryListener : public CComboBoxListener
{
	// instanciation section
	public :

		CComboBoxEntryListener		();
		virtual ~CComboBoxEntryListener	() =0;

	// comboboxentry specifics
	public :
		
		// called when the inSender combobox entry text is going to be modified with the specified ioString at the given ioPosition
                virtual void                    OnEntryQueryInsert   	(CObject *inSender, CString &ioString, UInt16 &ioPosition,
                                                                	 Bool &ioAccept)						{ }

                // called when the inSender combobox entry text is about to be deleted between the specified indices
                virtual void                    OnEntryQueryDelete  	(CObject *inSender, UInt16 &ioStart, UInt16 &ioEnd,
                                                                	 Bool &ioAccept)						{ }

                // called when the inSender combobox entry text has been modified
                virtual void                    OnEntryChange        	(CObject *inSender)						{ }

		// called when the inSender combobox entry text editing is done
		virtual void			OnEntryEditingDone	(CObject *inSender)						{ }

		// called when the inSender combobox entry is about to append an item following a key validation, if the model is the
		// the simpliest one i.e. just one string item field value, the ioItem will be proposed (you could delete or replace it 
		// as well), for other models, you will have to instanciate the ioItem and fill in the pointer if you want the process
		// to automatically handle its owner affectation; change the insertion index as needed too (-1 for append specification)
		virtual void			OnQueryAppendItem	(CObject *inSender, CComboBoxItem *&ioItem, 
									 const CString &inNewString, SInt32 &ioIndex)			{ }

		// metaclass association
		SECTION_GENERIC_METACLASS;
};

// metaclass and class tag declaration
DECLARE_GENERIC_METACLASS ('_cbe', CComboBoxEntryListener, CComboBoxListener);

//-----------------------------------------------------------------------------------------------------------------------------------------
// CComboBoxEntry class
//-----------------------------------------------------------------------------------------------------------------------------------------
class CComboBoxEntry : public CComboBox
{
	// instanciation section
	public :

		CComboBoxEntry			(CContainer *inOwner=NULL, const CMetaClasses &inModel=_IFVString_, THROWABLE
						 const CComboBoxEntryListener *inListener=NULL);
		virtual ~CComboBoxEntry		();

	// protected requests handling
	protected :

		// gtk widget instanciation and initialization
		virtual GtkWidget *		PerformWidgetInstanciate	();
		virtual void			PerformWidgetInitialize		();

	// cobject redefinition
	protected :

		// listener affectation, must be derived from CComboBoxEntryListener
		virtual const CMetaClass *	ListenerMustBe			() const;

	// ccombobox redefinitions
	public :

		// ccombox items field values model affectation
		virtual Bool			SetModel			(const CMetaClasses &inModel);

	// ccomboboxentry specifics
	public :

		// actual text displayed in the entry part of the combobox
		virtual CString			GetText				() const;

	// protected section
	protected :

		static void                     OnEntryQueryInsert		(GtkEditable *, gchar *, gint, gint *, gpointer);
                static void                     OnEntryQueryDelete		(GtkEditable *, gint, gint, gpointer);
                static void                     OnEntryChange			(GtkEditable *, gpointer);
		static void			OnEntryEditingDone		(GtkCellEditable *, gpointer);
		static gboolean                 OnKeyPress                      (GtkWidget *, GdkEventKey *, gpointer);

		// metaclass association
		SECTION_DYNAMIC_METACLASS;
};

// metaclass and class tag declaration
DECLARE_DYNAMIC_METACLASS ('cbxe', CComboBoxEntry, CComboBox);

#endif


