/*******************************************************************************************************************************************
 chpaned.h
 
 CClass					CClass
 |--CSerialized				|--CSerialized
    |--CMetaModule			   |--CMetaModule
       |--CObject			      |--CObjectListener
          |--CComponent			         |
	     |--CControl			 |
	        |--CWidget			 |--CWidgetListener
		   |--CContainer
		      |--CLayout
			 |--CPaned
			    |--CHPaned

 Horizontal paned definition.
*******************************************************************************************************************************************/

#ifndef __CHPANED_H__
#define __CHPANED_H__

#include "cpaned.h"

//-----------------------------------------------------------------------------------------------------------------------------------------
// CHPaned class
//-----------------------------------------------------------------------------------------------------------------------------------------
class CHPaned : public CPaned
{
	// instanciation section
	public :

		CHPaned			(CContainer *inOwner=NULL, const CWidgetListener *inListener=NULL);
		virtual ~CHPaned	();

	// gtk widget instanciation request handler
	protected :

		// allocate the gtk horizontal paned
		virtual GtkWidget *	PerformWidgetInstanciate	();

	// CLayout redefinition
	public :

		// get the potential drop index from specified relative point and given drop candidate
		virtual SInt16		GetDropIndexAtPoint		(const TPoint &inRelativePoint, const CControl *inCandidate) const;

		// metaclass association
		SECTION_DYNAMIC_METACLASS;
};

// metaclass and class tag declaration
DECLARE_DYNAMIC_METACLASS ('hpnd', CHPaned, CPaned);

#endif
