/*******************************************************************************************************************************************
 ccheckbutton.c
*******************************************************************************************************************************************/

#include "ccheckbutton.h"

//-----------------------------------------------------------------------------------------------------------------------------------------
// metaclass code resolution
//-----------------------------------------------------------------------------------------------------------------------------------------
RESOLVE_DYNAMIC_METACLASS (CCheckButton);

//-----------------------------------------------------------------------------------------------------------------------------------------
// constructor
//-----------------------------------------------------------------------------------------------------------------------------------------
CCheckButton::CCheckButton  (CContainer *inOwner, const CButtonListener *inListener)
	     :CToggleButton (NULL, inListener)
{
	// launch the gtkol instanciation process if the owner is specified
	if (inOwner != NULL) SetOwner (inOwner);
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// destructor
//-----------------------------------------------------------------------------------------------------------------------------------------
CCheckButton::~CCheckButton ()
{
	// widget deletion coherence requested
	CWidget::DestroyWidget (this);
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// gtk widget instanciation
//-----------------------------------------------------------------------------------------------------------------------------------------
GtkWidget * CCheckButton::PerformWidgetInstanciate ()
{
	return ::gtk_check_button_new ();
}


