/*******************************************************************************************************************************************
 cfontbutton.c
*******************************************************************************************************************************************/

#include "cfontbutton.h"

//-----------------------------------------------------------------------------------------------------------------------------------------
// metaclass code resolution
//-----------------------------------------------------------------------------------------------------------------------------------------
RESOLVE_GENERIC_METACLASS (CFontButtonListener);

//-----------------------------------------------------------------------------------------------------------------------------------------
// constructor
//-----------------------------------------------------------------------------------------------------------------------------------------
CFontButtonListener::CFontButtonListener ()
{ }

//-----------------------------------------------------------------------------------------------------------------------------------------
// destructor
//-----------------------------------------------------------------------------------------------------------------------------------------
CFontButtonListener::~CFontButtonListener ()
{ }

//-----------------------------------------------------------------------------------------------------------------------------------------
// OnSetFont
//-----------------------------------------------------------------------------------------------------------------------------------------
void CFontButton::OnSetFont (GtkFontButton *inGtkFontButton, gpointer inData)
{
	// retreive our gtkol instance
	CFontButton *inFontButton = reinterpret_cast <CFontButton *> (inData);

	// pointer check and notification emission
	if (inFontButton != NULL && inFontButton -> GetListener() != NULL)
	{
		// get the font name
		CString inFontName (::gtk_font_button_get_font_name(inGtkFontButton));

		// send the notification
		static_cast <CFontButtonListener *> (inFontButton -> GetListener()) -> OnSetFont (inFontButton, inFontName);
	}
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// metaclass code resolution
//-----------------------------------------------------------------------------------------------------------------------------------------
RESOLVE_DYNAMIC_METACLASS (CFontButton);

//-----------------------------------------------------------------------------------------------------------------------------------------
// constructor
//-----------------------------------------------------------------------------------------------------------------------------------------
CFontButton::CFontButton (CContainer *inOwner, const CFontButtonListener *inListener)
	    :CButton	 (NULL, inListener)
{
	// set this instance owner and launch the gtk instanciation process
	if (inOwner != NULL) SetOwner (inOwner);
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// destructor
//-----------------------------------------------------------------------------------------------------------------------------------------
CFontButton::~CFontButton ()
{
	// deletion coherence requested
	CWidget::DestroyWidget (this);
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// gtk widget instanciation
//-----------------------------------------------------------------------------------------------------------------------------------------
GtkWidget * CFontButton::PerformWidgetInstanciate ()
{
	return ::gtk_font_button_new ();
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// gtk widget initialization
//-----------------------------------------------------------------------------------------------------------------------------------------
void CFontButton::PerformWidgetInitialize ()
{
	// get our gtk widget
	GtkWidget *inGtkWidget (GetGtkWidget());

	// pointer check
	if (inGtkWidget == NULL) return;

	// specific signal connection
	::g_signal_connect (G_OBJECT(inGtkWidget), "font-set", G_CALLBACK(CFontButton::OnSetFont), this);

	// generic call
	CButton::PerformWidgetInitialize ();

	// caption / dialog title
	SetCaption (CString("Font Chooser"));
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// expected listener
//-----------------------------------------------------------------------------------------------------------------------------------------
const CMetaClass * CFontButton::ListenerMustBe () const
{
	return __metaclass(CFontButtonListener);
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// dialog title affectation
//-----------------------------------------------------------------------------------------------------------------------------------------
void CFontButton::SetCaption (const CString &inTitle)
{
	// get our gtk widget
	GtkWidget *inGtkWidget (GetGtkWidget());

	// pointer check
	if (inGtkWidget == NULL) return;

	// dialog title affectation
	::gtk_font_button_set_title (GTK_FONT_BUTTON(inGtkWidget), inTitle.Get());
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// dialog title access
//-----------------------------------------------------------------------------------------------------------------------------------------
CString CFontButton::GetCaption () const
{
	// get our gtk widget
	GtkWidget *inGtkWidget (GetGtkWidget());

	// ok, retreive the associated dialog title
	return inGtkWidget != NULL ? ::gtk_font_button_get_title (GTK_FONT_BUTTON(inGtkWidget)) : CString();
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// font name		
//-----------------------------------------------------------------------------------------------------------------------------------------
bool CFontButton::SetFontName (const CString &inFontName)
{
	// get our gtk widget
	GtkWidget *inGtkWidget (GetGtkWidget());

	// ok, retreive the associated dialog title
	return inGtkWidget != NULL ? ::gtk_font_button_set_font_name (GTK_FONT_BUTTON(inGtkWidget), inFontName.Get()) : false;
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// font name
//-----------------------------------------------------------------------------------------------------------------------------------------
CString CFontButton::GetFontName () const
{
	// get our gtk widget
	GtkWidget *inGtkWidget (GetGtkWidget());

	// ok, retreive the associated dialog title
	return inGtkWidget != NULL ? CString(::gtk_font_button_get_font_name (GTK_FONT_BUTTON(inGtkWidget))) : CString("Sans 12");
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// show font style
//-----------------------------------------------------------------------------------------------------------------------------------------
void CFontButton::SetShowStyle (const bool inShowStyle)
{
	// get our gtk widget
	GtkWidget *inGtkWidget (GetGtkWidget());

	// pointer check
	if (inGtkWidget == NULL) return;

	// set the property
	::gtk_font_button_set_show_style (GTK_FONT_BUTTON(inGtkWidget), inShowStyle);
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// show font style
//-----------------------------------------------------------------------------------------------------------------------------------------
bool CFontButton::GetShowStyle () const
{
	// get our gtk widget
	GtkWidget *inGtkWidget (GetGtkWidget());

	// ok
	return inGtkWidget != NULL ? ::gtk_font_button_get_show_style (GTK_FONT_BUTTON(inGtkWidget)) : false;
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// show size
//-----------------------------------------------------------------------------------------------------------------------------------------
void CFontButton::SetShowSize (const bool inShowSize)
{
	// get our gtk widget
	GtkWidget *inGtkWidget (GetGtkWidget());

	// pointer check
	if (inGtkWidget == NULL) return;

	// set the property
	::gtk_font_button_set_show_size (GTK_FONT_BUTTON(inGtkWidget), inShowSize);
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// show size
//-----------------------------------------------------------------------------------------------------------------------------------------
bool CFontButton::GetShowSize () const
{
	// get our gtk widget
	GtkWidget *inGtkWidget (GetGtkWidget());

	// ok
	return inGtkWidget != NULL ? ::gtk_font_button_get_show_size (GTK_FONT_BUTTON(inGtkWidget)) : false;
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// use font
//-----------------------------------------------------------------------------------------------------------------------------------------
void CFontButton::SetUseFont (const bool inUseFont)
{
	// get our gtk widget
	GtkWidget *inGtkWidget (GetGtkWidget());

	// pointer check
	if (inGtkWidget == NULL) return;

	// ok
	::gtk_font_button_set_use_font (GTK_FONT_BUTTON(inGtkWidget), inUseFont);
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// use font
//-----------------------------------------------------------------------------------------------------------------------------------------
bool CFontButton::GetUseFont () const
{
	// get our gtk widget
	GtkWidget *inGtkWidget (GetGtkWidget());

	// ok
	return inGtkWidget != NULL ? ::gtk_font_button_get_use_font (GTK_FONT_BUTTON(inGtkWidget)) : false;
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// use size
//-----------------------------------------------------------------------------------------------------------------------------------------
void CFontButton::SetUseSize (const bool inUseSize)
{
	// get our gtk widget
	GtkWidget *inGtkWidget (GetGtkWidget());

	// pointer check
	if (inGtkWidget == NULL) return;

	// ok
	::gtk_font_button_set_use_size (GTK_FONT_BUTTON(inGtkWidget), inUseSize);
}

//-----------------------------------------------------------------------------------------------------------------------------------------
//use size
//-----------------------------------------------------------------------------------------------------------------------------------------
bool CFontButton::GetUseSize () const
{
	// get our gtk widget
	GtkWidget *inGtkWidget (GetGtkWidget());

	// ok
	return inGtkWidget != NULL ? ::gtk_font_button_get_use_size (GTK_FONT_BUTTON(inGtkWidget)) : false;
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// serialization
//-----------------------------------------------------------------------------------------------------------------------------------------
void CFontButton::Serialize (CXMLElementNode *&ioXMLElementNode, const int inMode) THROWABLE
{
	// generic call
	CButton::Serialize (ioXMLElementNode, inMode);

	// request analyse
	switch (inMode)
	{
		// xml dump
		case XML_WRITE :
		{
			// instanciate a new xml element under the current one
			CXMLElement *newXMLElement = new CXMLElement (ioXMLElementNode, XML_FONT_BUTTON_ELEMENT);

			// add the attributes
			newXMLElement -> AddAttribute (XML_FONT_BUTTON_ATTR_FONT_NAME,  GetFontName());
			newXMLElement -> AddAttribute (XML_FONT_BUTTON_ATTR_SHOW_STYLE, CString(GetShowStyle()?"true":"false"));
			newXMLElement -> AddAttribute (XML_FONT_BUTTON_ATTR_SHOW_SIZE,  CString(GetShowSize ()?"true":"false"));
			newXMLElement -> AddAttribute (XML_FONT_BUTTON_ATTR_USE_FONT,   CString(GetUseFont  ()?"true":"false"));
			newXMLElement -> AddAttribute (XML_FONT_BUTTON_ATTR_USE_SIZE,   CString(GetUseSize  ()?"true":"false"));

			// modify the input output pointer so that the overwritten serialization process continues under this element
			ioXMLElementNode = newXMLElement -> GetXMLElementNode ();
		}
		break;

		// xml load
		case XML_READ :
		{
			// get the child node this serialization process is interested in
			CXMLElementNode *inXMLNode = ::xml_node_get_child (ioXMLElementNode, XML_FONT_BUTTON_ELEMENT);

			// check we got the expected node
			if (inXMLNode == NULL)
				throw new CException (CString("CFontButton::Serialize, specified xml node is not a \"") + 
							      XML_FONT_BUTTON_ELEMENT + CString("\" element one."), __exception(XMLPARSE));

			// modify the in/out element node pointer so that the serialization process will continue under the cbutton node
			ioXMLElementNode = inXMLNode;

			// retreive the attributes and set it
			SetFontName  (::xml_node_get_attribute (inXMLNode, XML_FONT_BUTTON_ATTR_FONT_NAME ).GetValue());
			SetShowStyle (::xml_node_get_attribute (inXMLNode, XML_FONT_BUTTON_ATTR_SHOW_STYLE).GetValue().ToBool());
			SetShowSize  (::xml_node_get_attribute (inXMLNode, XML_FONT_BUTTON_ATTR_SHOW_SIZE ).GetValue().ToBool());
			SetUseFont   (::xml_node_get_attribute (inXMLNode, XML_FONT_BUTTON_ATTR_USE_FONT  ).GetValue().ToBool());
			SetUseSize   (::xml_node_get_attribute (inXMLNode, XML_FONT_BUTTON_ATTR_USE_SIZE  ).GetValue().ToBool());
		}
		break;
	}
}


