/**
 * GUI Commands
 * Copyright 2005 Andrew Pietsch
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * $Id: ExpansionGroupMember.java,v 1.2 2006/02/26 00:59:05 pietschy Exp $
 */
package org.pietschy.command;

/**
 * @author andrewp
 * @version $Revision: 1.2 $
 */
public interface
ExpansionGroupMember
extends GroupMember
{

   String getName();

   void add(GroupMember member);

   void remove(GroupMember member);

   int
   size();

   GroupMember getMemberFor(Command command);

   void clear();

   boolean isSeparatorBefore();

   void setSeparatorBefore(boolean separatorBefore);

   boolean isSeparatorAfter();

   void setSeparatorAfter(boolean separatorAfter);

   boolean isEmpty();
}
