/*
 * ipod_private_constants.h
 *
 * Duane Maxwell
 * (c) 2005 by Linspire Inc
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTIBILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#ifndef __IPOD_PRIVATE_CONSTANTS_H__
#define __IPOD_PRIVATE_CONSTANTS_H__

#ifdef __cplusplus
extern "C" {
#endif

//
// iTunesDB database atom types
//
#define IPOD_ATOM_MHBD 0x6d686264
#define IPOD_ATOM_MHSD 0x6d687364
#define IPOD_ATOM_MHLT 0x6d686c74
#define IPOD_ATOM_MHIT 0x6d686974
#define IPOD_ATOM_MHOD 0x6d686f64
#define IPOD_ATOM_MHLP 0x6d686c70
#define IPOD_ATOM_MHYP 0x6d687970
#define IPOD_ATOM_MHIP 0x6d686970

// iTunesEQPresets database atom types
#define IPOD_ATOM_MQED 0x6d716564
#define IPOD_ATOM_PQED 0x70716564

// smart playlist rule field types

enum {
	IPOD_ATOM_SMART_FIELD_TYPE_TITLE = 0x2,
	IPOD_ATOM_SMART_FIELD_TYPE_ALBUM = 0x3,
	IPOD_ATOM_SMART_FIELD_TYPE_ARTIST = 0x4,
	IPOD_ATOM_SMART_FIELD_TYPE_BITRATE = 0x5,
	IPOD_ATOM_SMART_FIELD_TYPE_SAMPLERATE = 0x6,
	IPOD_ATOM_SMART_FIELD_TYPE_YEAR = 0x7,
	IPOD_ATOM_SMART_FIELD_TYPE_GENRE = 0x8,
	IPOD_ATOM_SMART_FIELD_TYPE_KIND = 0x9,
	IPOD_ATOM_SMART_FIELD_TYPE_DATEMODIFIED = 0xa,
	IPOD_ATOM_SMART_FIELD_TYPE_TRACKNUM = 0xb,
	IPOD_ATOM_SMART_FIELD_TYPE_SIZE = 0xc,
	IPOD_ATOM_SMART_FIELD_TYPE_DURATION = 0xd,
	IPOD_ATOM_SMART_FIELD_TYPE_COMMENT = 0xe,
	IPOD_ATOM_SMART_FIELD_TYPE_DATEADDED = 0x10,
	IPOD_ATOM_SMART_FIELD_TYPE_COMPOSER = 0x12,
	IPOD_ATOM_SMART_FIELD_TYPE_PLAYCOUNT = 0x16,
	IPOD_ATOM_SMART_FIELD_TYPE_LASTPLAYED = 0x17,
	IPOD_ATOM_SMART_FIELD_TYPE_DISCNUM = 0x18,
	IPOD_ATOM_SMART_FIELD_TYPE_RATING = 0x19,
	IPOD_ATOM_SMART_FIELD_TYPE_COMPILATION = 0x1f,
	IPOD_ATOM_SMART_FIELD_TYPE_BPM = 0x23,
	IPOD_ATOM_SMART_FIELD_TYPE_GROUPING = 0x27,
	IPOD_ATOM_SMART_FIELD_TYPE_PLAYLIST = 0x28
};

// smart playlist rule action types
enum {
	IPOD_ATOM_SMART_ACTION_IS = 0,
	IPOD_ATOM_SMART_ACTION_CONTAINS = 1,
	IPOD_ATOM_SMART_ACTION_BEGINSWITH = 2,
	IPOD_ATOM_SMART_ACTION_ENDSWITH = 3,
	IPOD_ATOM_SMART_ACTION_GREATERTHAN = 4,
	IPOD_ATOM_SMART_ACTION_GREATERTHANOREQUALTO = 5,
	IPOD_ATOM_SMART_ACTION_LESSTHAN = 6,
	IPOD_ATOM_SMART_ACTION_LESSTHANOREQUALTO = 7,
	IPOD_ATOM_SMART_ACTION_INRANGE = 8,
	IPOD_ATOM_SMART_ACTION_INLAST = 9
};

//
// constant representing "today" (2dae, get it?) in smart playlist rules
//
#define IPOD_ATOM_TODAY 0x2dae2dae2dae2dae

#ifdef __cplusplus
};
#endif

#endif
