/*
 * Decompiled with CFR 0.152.
 */
package com.michaelbaranov.microba.jgrpah.birdview;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import org.jgraph.JGraph;
import org.jgraph.event.GraphModelEvent;
import org.jgraph.event.GraphModelListener;
import org.jgraph.graph.GraphLayoutCache;

public class Birdview
extends JPanel {
    public static final Color PAN_RECT_COLOR = Color.black;
    public static final Color BACKGROUND_COLOR = UIManager.getColor("Panel.background");
    private JGraph displayGraph;
    private JScrollPane peerScroller;
    private JGraph peerGraph;
    private Rectangle2D paintRect;
    private Rectangle2D panRect;
    private double scale = 1.0;
    private ScrollerListener scrollerListener = new ScrollerListener();
    private SelfMouseListener selfMouseListener = new SelfMouseListener();
    private GraphPropertyChangeListener graphPropertyChangeListener = new GraphPropertyChangeListener();

    public Birdview() {
        this.displayGraph = new JGraph();
        this.displayGraph.setEnabled(false);
        this.displayGraph.setAntiAliased(true);
        this.displayGraph.addMouseListener((MouseListener)this.selfMouseListener);
        this.displayGraph.addMouseMotionListener((MouseMotionListener)this.selfMouseListener);
        this.setLayout(null);
        this.addComponentListener(new SelfResizeListener());
        this.add((Component)this.displayGraph);
    }

    public void setTrackingFor(JGraph graph, JScrollPane scroller) {
        if (this.peerGraph != null) {
            this.peerGraph.getModel().removeGraphModelListener((GraphModelListener)this.scrollerListener);
            this.peerGraph.removePropertyChangeListener((PropertyChangeListener)this.graphPropertyChangeListener);
        }
        this.peerGraph = graph;
        if (this.peerGraph != null) {
            this.peerGraph.getModel().addGraphModelListener((GraphModelListener)this.scrollerListener);
            this.peerGraph.addPropertyChangeListener((PropertyChangeListener)this.graphPropertyChangeListener);
            this.displayGraph.setGraphLayoutCache(this.peerGraph.getGraphLayoutCache());
        } else {
            this.displayGraph.setGraphLayoutCache(new GraphLayoutCache());
        }
        if (this.peerScroller != null) {
            this.peerScroller.getHorizontalScrollBar().removeAdjustmentListener(this.scrollerListener);
            this.peerScroller.getVerticalScrollBar().removeAdjustmentListener(this.scrollerListener);
        }
        this.peerScroller = scroller;
        if (this.peerScroller != null) {
            this.peerScroller.getHorizontalScrollBar().addAdjustmentListener(this.scrollerListener);
            this.peerScroller.getVerticalScrollBar().addAdjustmentListener(this.scrollerListener);
        }
        this.update();
        this.repaint();
    }

    private void update() {
        if (this.peerScroller != null) {
            Dimension viewSize = this.peerScroller.getViewport().getViewSize();
            double viewAspect = viewSize.getHeight() / viewSize.getWidth();
            Dimension panelSize = this.getSize();
            double panelAspect = panelSize.getHeight() / panelSize.getWidth();
            if (panelAspect < viewAspect) {
                double desiredPanelWidth = panelSize.getHeight() / viewAspect;
                double blankWidth = panelSize.getWidth() - desiredPanelWidth;
                double gap = blankWidth / 2.0;
                this.paintRect = new Rectangle2D.Double(gap, 0.0, desiredPanelWidth, panelSize.height);
                this.scale = panelSize.getHeight() / viewSize.getHeight();
                this.scale *= this.peerGraph.getScale();
            } else {
                double desiredPanelHeight = panelSize.getWidth() * viewAspect;
                double blankHeight = panelSize.getHeight() - desiredPanelHeight;
                double gap = blankHeight / 2.0;
                this.paintRect = new Rectangle2D.Double(0.0, gap, panelSize.getWidth(), desiredPanelHeight);
                this.scale = panelSize.getWidth() / viewSize.getWidth();
                this.scale *= this.peerGraph.getScale();
            }
            Rectangle viewRect = this.peerScroller.getViewport().getViewRect();
            double shiftX = viewRect.getX() / viewSize.getWidth();
            double shiftY = viewRect.getY() / viewSize.getHeight();
            double sizeX = viewRect.getWidth() / viewSize.getWidth();
            double sizeY = viewRect.getHeight() / viewSize.getHeight();
            this.panRect = new Rectangle2D.Double(this.paintRect.getX() + this.paintRect.getWidth() * shiftX, this.paintRect.getY() + this.paintRect.getHeight() * shiftY, this.paintRect.getWidth() * sizeX, this.paintRect.getHeight() * sizeY);
        } else {
            this.panRect = null;
            this.paintRect = null;
            this.scale = 1.0;
        }
    }

    private void panRectTo(Point point) {
        Dimension viewSize = this.peerScroller.getViewport().getViewSize();
        Rectangle viewRect = this.peerScroller.getViewport().getViewRect();
        double panHalfWidth = this.panRect.getWidth() / 2.0;
        double panHalfHeight = this.panRect.getHeight() / 2.0;
        Point2D.Double panOrigin = new Point2D.Double((double)point.x - panHalfWidth, (double)point.y - panHalfHeight);
        double xk = ((Point2D)panOrigin).getX() / this.paintRect.getWidth();
        double yk = ((Point2D)panOrigin).getY() / this.paintRect.getHeight();
        Point viewPos = new Point((int)(viewSize.getWidth() * xk), (int)(viewSize.getHeight() * yk));
        if (viewPos.x < 0) {
            viewPos.x = 0;
        }
        if (viewPos.y < 0) {
            viewPos.y = 0;
        }
        int wd = viewPos.x + viewRect.width - viewSize.width;
        int hd = viewPos.y + viewRect.height - viewSize.height;
        if (wd > 0) {
            viewPos.x -= wd;
        }
        if (hd > 0) {
            viewPos.y -= hd;
        }
        this.peerScroller.getViewport().setViewPosition(viewPos);
        this.update();
        this.repaint();
    }

    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(BACKGROUND_COLOR);
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.peerGraph != null) {
            this.displayGraph.setBounds(this.paintRect.getBounds());
            this.displayGraph.setScale(this.scale);
            this.displayGraph.setBackground(this.peerGraph.getBackground());
            this.paintChildren(g);
        }
        if (this.panRect != null) {
            g2.setColor(PAN_RECT_COLOR);
            g2.draw(this.panRect.getBounds());
        }
    }

    private class GraphPropertyChangeListener
    implements PropertyChangeListener {
        private GraphPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if ("scale".equals(evt.getPropertyName())) {
                Birdview.this.update();
                Birdview.this.repaint();
            }
        }
    }

    private class SelfMouseListener
    implements MouseListener,
    MouseMotionListener {
        private SelfMouseListener() {
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
            if (Birdview.this.paintRect != null) {
                Birdview.this.panRectTo(e.getPoint());
            }
        }

        public void mouseDragged(MouseEvent e) {
            if (Birdview.this.paintRect != null) {
                Birdview.this.panRectTo(e.getPoint());
            }
        }

        public void mouseMoved(MouseEvent e) {
        }
    }

    private class SelfResizeListener
    implements ComponentListener {
        private SelfResizeListener() {
        }

        public void componentHidden(ComponentEvent e) {
        }

        public void componentMoved(ComponentEvent e) {
        }

        public void componentResized(ComponentEvent e) {
            Birdview.this.update();
            Birdview.this.repaint();
        }

        public void componentShown(ComponentEvent e) {
            Birdview.this.update();
            Birdview.this.repaint();
        }
    }

    private class ScrollerListener
    implements AdjustmentListener,
    GraphModelListener {
        private ScrollerListener() {
        }

        public void adjustmentValueChanged(AdjustmentEvent e) {
            Birdview.this.update();
            Birdview.this.repaint();
        }

        public void graphChanged(GraphModelEvent e) {
            Birdview.this.update();
            Birdview.this.repaint();
        }
    }
}

