# Web::Interface::ModRuby
# Copyright(c) 2002 MoonWolf <moonwolf@moonwolf.com>
require 'web/interface/basic'

module Web
  module Interface
    class ModRuby < Basic
      EOL = "\r\n"
      def initialize(opt={})
        @opt       = opt
        @eof       = false
      end
      attr_accessor :eof
      
      # W͂RequestgݗĂ
      def request(arg={})
        return nil if @eof
        @eof = true
        req = Web::Request.new
        ap = Apache.request
        
        #
        req.request_id      = ap.subprocess_env['UNIQUE_ID'] || Web::Common::unique_id
        req.method          = ap.request_method
        req.query_string    = ap.args
        req.path_info       = ap.path_info
        req.script_name     = ap.uri.chomp(ap.path_info)
        req.host            = ap.hostname
        req.remote_addr     = ap.connection.remote_ip
        req.remote_host     = ap.connection.remote_host || req.remote_addr
        req.remote_ident    = ap.subprocess_env['REMOTE_IDENT']
        req.remote_user     = ap.user
        req.server_name     = ap.server_name
        req.server_port     = ap.server_port
        req.server_protocol = ap.protocol
        req.path_translated = ap.subprocess_env['PATH_TRANSLATED']
        
        # header
        ap.headers_in.each {|key,value|
          req.header[key] = value
        }
        
        # cookie
        if cookie = req.header['COOKIE']
          req.cookies.parse(cookie, req)
        end
        
        
        ## param
        # QUERY_STRING
        parse_query(req.query_string, req.query)
        
        ## body
        case req.method
        when 'GET'
          # body
          req.body = nil
        when 'POST'
          ## form
          case req.header['CONTENT-TYPE']
          when /^multipart\/form-data\s*;\s*boundary="?(.*)"?/
            boundary=$1
            parse_multipart(ap, boundary, req.form)
          when /^application\/x-www-form-urlencoded/
            parse_query(ap.read.to_s, req.form)
          else
            req.body = ap.read
          end
        end
        get_session_id req
        req
      end # ModRuby#request

      def response(req, rsp)
        super
        ap = Apache.request
        # wb_o
        ap.status_line = rsp.status
        rsp.header.each {|key,value|
          case key
          when 'content-type'
            ap.content_type = value.first
          when 'content-encoding'
            ap.content_encoding = value.first
          when 'content-language'
            ap.content_languages = value
          else
            field = key.split('-').collect! {|i| i.capitalize }.join('-')
            ap.headers_out[field] = value.join(',')
          end
        }
        setcookie = ''
        rsp.cookies.each {|key,cookie_ary|
          cookie_ary.each {|cookie|
            ap.headers_out.add 'Set-Cookie', cookie.to_response_header
          }
        }
        #
        ap.send_http_header
        ap.write rsp.body
        req.cleanup
      end # ModRuby#response
    end # ModRuby
  end # Interface
end # Web
