/*
 *  Jajuk
 *  Copyright (C) 2006 bflorat
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *  $Revision: 1.4 $
 */

package org.qdwizard;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.ResourceBundle;

import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

/**
 *  Problem state buttons panel
 *
 * @author     Bertrand Florat
 * @created    1 may 2006
 */
class ActionsPanel extends JPanel {

    private static final long serialVersionUID = 1L;

	/**Problem text area*/
    JLabel jlProblem;
    
    JButton jbPrevious;
    JButton jbNext;
    JButton jbFinish;
    JButton jbCancel;
    
    ResourceBundle bundle;


    
    /**Associated action listener*/
    ActionListener al;

    /**
     * @param al associated action listener
     */
    public ActionsPanel(ActionListener al,Locale locale) {
        //set locale
        try
        {
            bundle = ResourceBundle.getBundle("qdwizard", locale);
        }
        catch (Exception e)
        {
            System.err.println("unable to find resource bundle qdwizard.properties for locale " +locale+
                    " in classpath");
            e.printStackTrace();
        }
        //Problem panel
        jlProblem = new JLabel();
        jlProblem.setForeground(Color.RED);
        jlProblem.setFont(new Font("Dialog",Font.BOLD,12)); //$NON-NLS-1$

        //Action buttons
        JPanel jpButtons = new JPanel();
        jpButtons.setLayout(new BoxLayout(jpButtons,BoxLayout.X_AXIS));
        Dimension dimButtons = new Dimension(150,20);
        jbPrevious = new JButton("< "+getMessage("Previous"));
        jbPrevious.setPreferredSize(dimButtons);
        jbPrevious.addActionListener(al);
        jbPrevious.setActionCommand("Prev"); //$NON-NLS-1$

        jbNext = new JButton("> "+getMessage("Next"));
        jbNext.addActionListener(al);
        jbNext.setActionCommand("Next"); //$NON-NLS-1$
        jbNext.setPreferredSize(dimButtons);

        jbFinish = new JButton(getMessage("Finish"));
        jbFinish.addActionListener(al);
        jbFinish.setActionCommand("Finish"); //$NON-NLS-1$
        jbFinish.setPreferredSize(dimButtons);

        jbCancel = new JButton(getMessage("Cancel"));
        jbCancel.addActionListener(al);
        jbCancel.setActionCommand("Cancel"); //$NON-NLS-1$
        jbCancel.setPreferredSize(dimButtons);

        jpButtons.add(Box.createHorizontalStrut(10)); //$NON-NLS-1$
        jpButtons.add(Box.createHorizontalGlue()); //$NON-NLS-1$
        jpButtons.add(jbPrevious); //$NON-NLS-1$
        jpButtons.add(Box.createHorizontalStrut(5)); //$NON-NLS-1$
        jpButtons.add(jbNext); //$NON-NLS-1$
        jpButtons.add(Box.createHorizontalStrut(10)); //$NON-NLS-1$
        jpButtons.add(jbFinish); //$NON-NLS-1$
        jpButtons.add(Box.createHorizontalStrut(20)); //$NON-NLS-1$
        jpButtons.add(jbCancel); //$NON-NLS-1$
        jpButtons.add(Box.createHorizontalStrut(10)); //$NON-NLS-1$
        jpButtons.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0));

        //Main panel
        setLayout(new GridLayout(2,1));
        add(jlProblem); //$NON-NLS-1$
        add(jpButtons); //$NON-NLS-1$
    }
    
    /**
     * Set buttons states
     * @param bNext
     * @param bFinish
     */
    void setState(boolean bPrevious,boolean bNext,boolean bFinish){
       jbPrevious.setEnabled(bPrevious);
       jbFinish.setEnabled(bFinish);
       jbNext.setEnabled(bNext);
    }
    
    void setProblem(String problem){
    	String sProblem = problem;
        //Add a space before message
        if (sProblem != null){
            sProblem = "  "+sProblem;
        }
        jlProblem.setText(sProblem);
        if (sProblem != null && !"".equals(sProblem)){ //$NON-NLS-1$
            jlProblem.setBorder(BorderFactory.createMatteBorder(1,0,0,0,Color.DARK_GRAY));    
        }
        else{
            jlProblem.setBorder(null);
        }
    }
    
    /**
     * I18n utility
     * @param key
     * @return
     */
    private String getMessage(String key){

        try
        {
           return bundle.getString(key);
        }
        catch(Exception e)
        {
            System.err.println("missing resource "+key);
            e.printStackTrace();
            return key;          //don't fail on missing resource or null bundle, return the given key instead
        }
    }
    
  
}
