// This is a roxen module. (c) Martin Baehr 1997

// The form module. 
// parses the <form> container to save it's contents
// for later use by programs to evaluate the input

//  This code is (c) 1996-1997 Martin Baehr, and can be used, modified and
//  redistributed freely under the terms of the GNU General Public License,
//  version 2.
//  This code comes on a AS-IS basis, with NO WARRANTY OF ANY KIND, either
//  implicit or explicit. Use at your own risk.
//  You can modify this code as you wish, but in this case please
//  - state that you changed the code in the modified version
//  - do not remove my name from it
//  - send me a copy of the modified version or a patch, so that
//    I can include it in the 'official' release.
//  If you find this code useful, please e-mail me. It would definitely
//  boost my ego :)
//  
//  For risks and side-effects please read the code or ask your local 
//  unix or roxen-guru.

string cvs_version = "$Id: form.pike,v 1.0 1997/11/14 mb Exp $";
#include <simulate.h>
#include <module.h> 
inherit "module"; 
inherit "roxenlib"; 

int loaded;

void create()
{
  defvar("location", "/form/", "Mountpoint", TYPE_LOCATION|VAR_MORE,
         "The URL-prefix for the form actions.");
  defvar("program_location", "../local/modules", "Program search path", TYPE_DIR,
         "The directory where your form-handling programs are stored");
}

void start(int num, object configuration)  // number and config object sent as argument
{
  loaded=1;
}

array register_module() 
{
 string s="";
  
  if(loaded) {
    string q = query_location();
    if(sizeof(q) && q[0] == '/') q = q[1..];
    s = "<br>see <a target=form href='"+ 
      my_configuration()->query("MyWorldLocation")+q+"'>here</a> for an example.<br>";
  }

  return({ 
    MODULE_PARSER|MODULE_LOCATION, 
      "Form", 
      "The form module parses forms to find out what variables " 
      "are defined, so that when the form-output is processed "
      "we not only know which values are set, but also which "
      "values have been possible<BR>"
      "also, hidden variables will be completely removed, and therefore "
      "<em>really</em> hidden\n\n<p>"
      "when the form is submitted a user-specified program is run, "
      "that receives the parsed data for manipulation.<br>"
      "programs are selected by setting the <tt>program</tt> argument "
      "in the <tt>&lt;form&gt;</tt> tag:<br>"
      "<tt>&lt;form method=post <b>program=showdata</b>&gt;</tt><br>"
      "tags without a <tt>program</tt> argument will be ignored.<br>"
      "programs are normaly cached, this is problematic while you are "
      "developping. you can turn off caching, by setting the <tt>no_cache</tt> "
      "argument:<br>"
      "<tt>&lt;form method=post <b>no_cache</b> program=showdata&gt;</tt><br><br>"
      "programs are called via the function <tt>main(mapping res, object id)</tt> "
      "<tt>main()</tt> takes two arguments:<br>"
      "a mapping with the form's data and an object with roxen's resource-id.<br>"
      " it may return anything a module may return (see "
      "<a href=http://www.roxen.com/documentation/challenger1.2/Kap13.html#modreturn>the manual</a>)<br> "
      "the mapping has the following structure:<br>"
      "<tt>res->form</tt> contains an array containing each form-tag in "
      "it's original position with all its arguments,<br>"
      "<tt>res->data</tt> cointains a mapping with all values selectable "
      "by their names (<tt>res->data->somevariable = ({({\"value1\"})({\"description1\"})}</tt>),"
      "<br><tt>res->variables</tt> contains the same data as "
      "<tt>id->variables</tt>, except that they are split in arrays "
      "so that they have the same format as <tt>res->data</tt>"
      "<br><tt>res->arguments</tt> contains the arguments of the"
      "<tt>&lt;form&gt;</tt> tag itself.<p>"
      "the easiestest way to figure out how the data-structure "
      "looks like, is to create a form and use it with the "
      "program <b>showdata</b><br>"+s,
      0, 
      1, 
  }); 
} 

#define  regexp(_) (Regexp(_)->match)

string quote(string in)
{
  return MIME.encode_base64(in, 1);
} 

string unquote(string out)
{
  return MIME.decode_base64(out);
} 


string itag_input(string tag, mapping arguments, mapping res)
{
  mapping m=([]);
  array data=({});

  if (arguments->_parsed)
    return 0;

  m->tag=tag;      
  m->arguments=arguments+([]);
  res->form += ({m});
  if(res->data[arguments->name])
  {
    data = res->data[arguments->name];
    data += ({({arguments->value})});
    res->data[arguments->name] = data;
  }
  else
    res->data[arguments->name] = ({({arguments->value})});
   
  arguments->_parsed="true"; 
  if (arguments->type=="hidden")
    return "";
  else
    return(make_tag(tag, arguments));
}

string itag_remove_parsed(string tag, mapping arguments, mapping res)
{

  if (!arguments->_parsed)
    return 0;
  arguments -= (["_parsed":"true"]);
  return(make_tag(tag, arguments));
}

string icontainer_remove_parsed(string container, 
                         mapping arguments, 
                         string contents,
                         mapping res)
{
  if (!arguments->_parsed)
    return 0;

  arguments -= (["_parsed":"true"]);
  return (make_container(container, arguments, contents));
}

string icontainer_option(string container,
                         mapping arguments,
                         string contents,
                         mapping opt)
{
  mapping m=([]);

  if (arguments->_parsed)
    return 0;

  m->container=container;
  m->arguments=arguments;
  m->contents=contents;
  opt->opt += ({m});
  opt->value += ({ ((arguments->value?({arguments->value}):({}))+({contents}) ) });

  perror(sprintf("form: option: opt: %d\n", sizeof(opt->opt)));
  if (arguments->type=="hidden")
    return "";
  else
    return (make_container(container, arguments+(["_parsed":"true"]), contents));
}

string icontainer_select(string container, 
                         mapping arguments, 
                         string contents,
                         mapping res)
{
  mapping m=([]);
  mapping opt=([]);
  array data = ({});
  opt->opt = ({});
  opt->value = ({});

  if (arguments->_parsed)
    return 0;

  contents = parse_html(contents, ([]), ([ "option":icontainer_option]), opt);
  m->container=container;
  m->arguments=arguments;
  m->opt=opt->opt;
  res->form += ({m});

  if(res->data[arguments->name])
  {
    data = res->data[arguments->name];
    data += opt->value;
    res->data[arguments->name] = data;
  }
  else
    res->data[arguments->name] = opt->value;
 
  return (make_container(container, arguments+(["_parsed":"true"]), contents));
}

string icontainer_textarea(string container,
                           mapping arguments,
                           string contents,
                           mapping res)
{
  mapping m=([]);

  if (arguments->_parsed)
    return 0;

  m->container=container;
  m->arguments=arguments;
  m->contents=contents;
  res->form += ({m});
  return (make_container(container, arguments+(["_parsed":"true"]), contents));
}


/* A container gets the contents as the third 
* argument. Example: <body Bar=Gazonk>Hi!</body> --> 
* container_body("body", (["bar":"Gazonk"]), 
* "Hi!", ...); 
* Note the lowercasing of Bar. 
*/ 
string container_form(string tag_name, 
		     mapping arguments, 
		     string contents, 
		     object request_id, 
		     mapping defines) 
{ 
  mapping(string:mixed) res=([]);
  res->form=({});
  res->data=([]);
  string path;

  if (arguments->_parsed)
    return 0;
  if (!arguments["program"])
    return 0;

  res->arguments = arguments+([]);
  arguments->_parsed="true";

  contents = parse_html(contents, ([ "input":itag_input ]), ([ "textarea":icontainer_textarea, "select":icontainer_select ]), res);
  // parsing adds a _parsed argument, which gets in our way when we
  // try to rxml_parse again...
  //contents = parse_html(contents, ([ "input":itag_remove_parsed ]), ([ "textarea":icontainer_remove_parsed, "select":icontainer_remove_parsed ]), res);
 

  path = request_id->raw_url;
  //perror("perror:"+path+"\n");
  //  path = request_id->not_query;
  //  perror("perror:"+path+"\n");

  arguments->action=query("location") + quote(encode_value(res));


  return(make_container("form", arguments, contents));
} 

mapping query_container_callers() 
{ 
  return (["form":container_form]); 
} 

mapping find_file(string f, object id)
{   

  program Form_Handler;
  object form_handler;
  mapping res;
  array a;
  int i;
  

  if (sizeof(f)) 
  {
    f = unquote(f);
    res = decode_value(f);
  } 
  else
  {
    string out= "<source><FORM METHOD=get program=showdata>\n"
"<input type=text name=yname value='your name'>\n"
"<select name=place>\n"
"<option value=park>sch&ouml;nbrunn</option>\n"
"<option value=street>k&auml;rntner stra&szlig;e</option>\n"
"<option type=hidden value=river>donau</option>\n"
"<option>wien</option>\n"
"</select>\n"
"<input type=submit name=action value=select>\n"
"</form>\n"
"</source>\n";
    return http_string_answer(parse_rxml(out, id), "text/html");
  }

  a=indices(id->variables);

  res->variables = ([]);

  for(i=0; i<sizeof(a); i++)
  {
    res->variables[a[i]] = map_array(id->variables[a[i]]/"\000",lambda(mixed x){ return ({x}); });
  }

  if(res->arguments->no_cache)
    Form_Handler = compile_file(query("program_location")+res->arguments["program"]+".pike");
  else
    Form_Handler = (program)(query("program_location")+res->arguments["program"]);
  form_handler = Form_Handler();
  return form_handler->main(res, id);

}

