/*
 * Description:
 *   This is a roxen module.
 *   Gives a <path> tag which displays a clickable path.
 *
 * Copyright: GPL
 *
 * Authors:
 *   Matthew Brookes <matt@broadcom.ie> & Bill Welliver <hww3@riverweb.com>
 *
 * Bugs:
 *   Probably! (Carsberg? Definitely!)
 *
 * To Do:
 *   <gtext> support could use some cleaning up
       (but then so could the whole thing!) 
 *   Browser reload overide .pathname cache
 *     (or maybe "nocache" option a la <insert> would be easier?
 *   <gtext> args can't be quoted
 *   .pathmagic files for <gtext> status bar text (maybe :^)
 *   Suggestions anyone?
 *
 * History:
 *   0.1.4 1998/05/05 First release. Does the basics	            (matt)
 *   0.1.5 1998/06/02 Added arg "skip" for f.vandijk	            (matt)
 *   0.1.6 1998/06/08 Added arg "rootname" for f.vandijk            (matt)
 *   0.2   1998/06/10 Capitalization and Alternate text w/ caching  (hww3)
 *   0.3   1998/06/11 Version 0.1.6 (matt) & 0.2 (hww3) merged      (matt)
 *   0.3.1 1998/06/11 Spaces moved from separator to config default (matt)
 *   0.3.2 1998/06/11 Bug fix for skip                              (chris)
 *   0.4.0 1998/06/12 Quick & dirty <gtext> support                 (matt)
 *   0.4.1 1998/06/15 Small bug in gtext support fixed              (matt)
 *   0.4.2 1998/06/16 Prestate support for Thomas Koester           (matt)
 *   0.4.3 1998/06/18 Module start time added to status info        (matt)
 *   0.4.4 1998/06/18 Removed newline after separator               (matt)
 *
 */


constant cvs_version = "$Id: path.pike,v 0.4.4 1998/06/18 17:00:00 matt Exp $";
constant thread_safe=1;

#include <module.h>
inherit "module";
inherit "roxenlib";

string tagname;
int usecount;
mapping cache=([]);
string starttime = ctime(time());

void create()
{
  defvar( "tagname", "path", "Tag name", TYPE_STRING, 
	  "Name of the tag\n"
	);

  defvar( "timeout", "3600", "Cache Timeout", TYPE_STRING, 
	  "Number of seconds for .pathname cache timeout.\n"
           "<P>The file .pathname in a directory can contain a string \n"
           "to be used in place of the directory name.\n"
           "<BR><I>(You will have to wait [timeout] seconds for\n"
           "changes to take effect.)</I>\n"
	);

  defvar( "separator", " -> ", "Default separator", TYPE_STRING, 
          "Can be overridden by separator=\"string\" argument.<P>\n"
           "Example:<br>\n"
	   "<pre>&lt;html&gt;\n"
	   "[&lt;path separator=\"][\"&gt;]\n"
	   "&lt;/html&gt;</pre>\n"
	   "Might give:<P>\n"
           "[<u><font color=\"blue\">home</u></font>] "
           "[<u><font color=\"blue\">dir1</u></font>] "
           "[<u><font color=\"blue\">dir2</u></font>]\n"
      );

  defvar( "rootname", "home", "Default root name", TYPE_STRING, 
	  "Default name of root level link, instead of \"/\"<BR>\n"
           "Can be overridden by rootname=\"string\" argument.\n"
      );

  defvar( "gtargs", "scale=0.6", "Default &lt;gtext&gt; options", TYPE_STRING, 
	  "Default options if gtext is used.\n"
           "Can be overridden by gtext=\"gtext options\""
	);

}

array register_module()
{
  return( ({ MODULE_PARSER, 
	     "Path tag",
	     "Config interface style URL location thing!<P>"
              "Adds a new tag &lt;path&gt; which displays the path "
              "part of the current URL, split into clickable links. "
              "Put it at the top of all your pages to aid navigation. "
              "(Using &lt;insert&gt; or the tagbuilder module makes this easy!)"
	      "<P>Syntax: <I>&lt;path [separator=\"string\"] "
	      "[rootname=\"string\"] [skip=n] [capitalize] "
              "[gtext[=\"gtext options\"]] [magic]&gt;</I><P>",
	     0,
             1 }) );
}

string status()
{
   return "Called " + usecount + " times since " + starttime;
}

// the tag
string tag_path( string tag, mapping args, object id, object file, mapping defines )
{
   string part;
   string out="";
   string path="";
   string gtargs="";
   string separator;
   int skip;
   string rootname;

   // read separator from tag or config   
   if(!(separator = args->separator))
      separator = query("separator");

   // read top level to include from tag or default to all
   if(!(skip = (int) args->skip))
      skip = 0;

   // read rootname from tag or config
   if(!(rootname = args->rootname))
      rootname = query("rootname");

   if(!(gtargs = args->gtext))
      gtargs =  query("gtargs");

   // split path/file part of URL into an array "parts"
   array (string) parts = id->not_query / "/";
   array (string) tmp;
   mixed t;
   string a = (sizeof(id->prestate)?"apre":"a");

   for(int i=0; i < sizeof(parts)-1; i++)
   {
      part = parts[i];  
      path += part + "/"; // rebuild the path part of the URL

      if(cache[path] && cache[path]->timeout > time())
          part=cache[path]->text; // Use the cached text for pathpart.
      else	// Either we don't have it or the cache timed out.
      {
         cache[path]=([]);
	 cache[path]->timeout=time() + (int)query("timeout");  
	 t=id->conf->real_file(path+".pathname", id);
//       perror(t+"\n");

	 if(t)
         {
	    cache[path]->text=Stdio.read_file(t)-"\n";
//		perror(cache[path]->text+"\n");
	    part=cache[path]->text;
	 }
	  else
  	    cache[path]->text=part; 
      }

      if(part == "") part = rootname;

      // Build the result
      if(i >= skip)
      {
         out += (args->gtext&&args->magic?"":("<" + a + " href=\"" +
                                              path + "\">")) +
         (args->gtext?("<gtext " + gtargs + 
         (args->magic?(" magic href=\"" + path + "\""):"") +
         ">"):"") +
	 (args->capitalize?capitalize(part):part) +
         (args->gtext?"</gtext>":"") +
         (args->gtext&&args->magic?"":"</" + a + ">");

         if(i < sizeof(parts) - 2)
            out += separator;
      }
   }
  
   usecount++ ;
   return out ;
}


void start() // read the definitions from the config interface
{
tagname = query("tagname");
return;
}


mapping query_tag_callers()
{
   return ([ tagname : tag_path ]);
}
