#!/usr/local/bin/pike
//
// $Id: popdrop.pike,v 1.9 2000/11/13 05:50:37 kiwi Exp $
//
// Fetchmail "Clone" with backend SQL
//
//
// Format of the SQL database
//
// CREATE TABLE popdrop (
//	id int(15) not null default '0' auto_increment,
//	popuser varchar(250) not null,
//	poppass varchar(250) not null,
//	popserv varchar(250) not null,
//	emailto varchar(250) not null,
//	primary key(id));
//

#define THREADS 50	// Nb de threads
#define SMTPTHREADS 50	// Nb maxi of SMTPthreads

import Thread;
inherit .POP3 : Pop3;
inherit .popsql : PopSql; 

// Constants
constant version     = ("$Revision: 1.9 $" / " ")[1];
constant sqldatabase = "mysql://kiwi@localhost/popdrop";
constant sqltable    = "popdrop";
constant smtpserver  = "127.0.0.1";
constant postmaster  = "postmaster@isdnet.net";

// global variables
int gthr=1;		// Threads in this program
int smtpthr=1;		// Threaded smtp client

// Cvs version
string cvsversion()
{
 return "PopDrop, version "+version+" - (C)Copyright 2000 - Xavier Beaudouin & Emile Heitor.";
}

// Grouik de Protocols.SMTP
string parse_addr(string|int addr)
{
    if (intp(addr)) return postmaster;
    array(string|int) tokens = replace(MIME.tokenize(addr), '@', "@");

    int i;
    tokens = tokens[search(tokens, '<') + 1..];

    if ((i = search(tokens, '>')) != -1) {
      tokens = tokens[..i-1];
    }
    return tokens*"";
}

void smtpsend(string smtpserver, string frommsg, string emailto, array(string) message)
{
 Protocols.SMTP.client(smtpserver)->send_message(parse_addr(frommsg),
                      ({ emailto }), (message*"\n"));
}

void getpop(string popuser, string poppass, string popserv, string emailto, void|int terse)
{

  object baf = Pop3::client(popserv);
  array(string) message;
  array(mixed) status;
  int nbmessages=0, verb=1;

  if (terse)
   verb=0;
  
  if (verb)
    write("Check mail for : "+popuser+"@"+popserv+" for "+emailto+"\n");
  if(baf->doconnect())
  {
    if (verb)
      write("Couldn't connect to "+popserv+"\n");
    return;
  } 
  status = baf->login(popuser,poppass);
  if ( status[0] != 0)
   {
     if (verb)
       write("User/Password fails...\n");
     baf->quit();
     return;
   }
  nbmessages=(baf->stat())[0];
  if (nbmessages == 0) { baf->quit(); return; }
  for (int i=1; i<(nbmessages+1); i++)
  {
    int where, flag=0;
    string messagebody, frommsg;

    message = baf->body(i);
    where = search((message*"\n"), "\nFrom: ");
    foreach(message, string ligne)
    {
      int wherefrom = search(ligne, "From: ", 0);
      if ((wherefrom != -1)&& (flag==0))
      {
        frommsg = ligne - "\r";
	frommsg = frommsg - "From: ";
	flag=1;
      }
    }
    if (verb) 
      Tools.Install.ProgressBar((nbmessages-i)+"/"+nbmessages+" mail"+(((nbmessages-i)>1)?"s":""),1,nbmessages)->update(i);
    #if constant(thread_create)
    if(smtpthr)
    {
      if (sizeof(all_threads()) >= (THREADS+SMTPTHREADS))
      {
        while(sizeof(all_threads()) >= (THREADS+SMTPTHREADS))
	{
	  sleep(1);
	}
        gthr = sizeof(all_threads());
      }
      thread_create(smtpsend,smtpserver,frommsg,emailto,message);
      gthr++;
    }
    else
    #endif
      smtpsend(smtpserver,frommsg,emailto,message);
    baf->dele(i);
  }
  baf->quit();
  if (verb)
    write("\n");
}

void help()
{
  write(cvsversion());
  write("\n\nSyntax:\n");
  write("   popdrop [-v] [-s] [-V] [-h] [-S]\n");
  write("\n  With:\n");
  write(" -v : verbose\n");
  write(" -s : single thread / no-thread mode\n");
  write(" -V : version\n");
  write(" -h : help\n");
  write(" -S : single thread / no-thread SMTP client.\n");
}
  
void wait4thr(int verb, int smtptr)
{
 #if constant(thread_create)
  if (verb) write("Waiting for threads...");
  int allthr = sizeof(all_threads());
  int nbthr = allthr;
  while(nbthr > 1)
  {
    if (verb && !smtpthr)
      Tools.Install.ProgressBar(nbthr + " threads",1,allthr)->update(allthr-nbthr);
    if (verb && smtpthr)
      write("\rWaiting for threads...%-13s   ",(string)sizeof(all_threads()));
    nbthr = sizeof(all_threads());
    sleep(1);
  }
  if (verb) write("\n");
 #endif
}

void launchthr(string popuser, string poppass, string popserv, string emailto, int verb)
{
 #if constant(thread_create)
  if (verb)
   write("Checking mail for "+popuser+"@"+popserv+" for "+emailto+"\n");
  thread_create(getpop,popuser,poppass,popserv,emailto,1); 
 #endif
}

void main(int argc, array argv)
{
  array(array(string)) listmails;	// list of pop3 login/pass/srv
  // flags
  int verb=0;	// verbose
  int nothr=0;	// no thread

  if (argc > 1)
   foreach(argv, string flag)
   {
    switch (flag)
    {
      case "-v": verb=1; break;
      case "-s": nothr=1; break;
      case "-V": write(cvsversion()+"\n"); return;
      case "-S": smtpthr=0; break;
      case "-h":
      case "-H":
      case "--help": help(); return;
    }
   }

   if (verb||nothr) write(cvsversion()+"\n");

  listmails=PopSql::getuser(sqldatabase,sqltable);

  foreach(listmails, array(string) foo)
  {
   #if constant(thread_create)
   if (nothr)
     getpop(foo[0],foo[1],foo[2],foo[3]);
   else
   if(gthr < THREADS)
   { 
     launchthr(foo[0],foo[1],foo[2],foo[3],verb);
     gthr++;
   }
   else
   {
     wait4thr(verb,smtpthr);
     launchthr(foo[0],foo[1],foo[2],foo[3],verb);
     gthr=1;
   }
   #else
   getpop(foo[0],foo[1],foo[2],foo[3]);
   #endif
  }

  #if constant(thread_create)
  if (!nothr) wait4thr(verb,smtpthr);
  else 
   if (smtpthr) wait4thr(1,smtpthr);
  #endif
}
