// This is a roxen(.com) module for easy pressrelease handling

string cvs_version = "$Id: pressrelease-add.pike,v 1.1 2000/08/02 18:26:24 han Exp $";

#include <module.h>

inherit "module";
inherit "roxenlib";


string print_htmlhead(){
  // add html head
  return  "<html>\n<head>\n<title>" 
    + "Pressrelease:" 
    + "</title>\n</head>\n"
    + "<BODY BGCOLOR=\"white\">";
}

string print_htmlbot(){
  // add html bottom
  return "<HR>"
    + "<A HREF=\""
    + query_location()
    + "/new\">new pressrelease</A>"
    + " "
    + "<A HREF=\""
    + query("viewurl")
    + "/listnews\">list pressreleases</A>"
    +"\n\n</body></html>\n";
  
}

void create()
{

  defvar("mountpoint", "/add_new_pressrelease/", "Mount point", TYPE_LOCATION, 
	 "Press.rel. module location in filesystem.");

  defvar("viewurl", "/press/", "View URL", TYPE_STRING, 
	 "Press.rel. VIEW module location in the WWW.");

  defvar("addtitle", "Add new pressrelease for Foobar AB", "Title @ addpage", TYPE_STRING, 
	 "Title at the add new pressrelease page.");

  defvar("pagetemplate", "/home/www/pressrel/templates/pressrel1.html", "Template for pressreleases", TYPE_STRING, 
	 "Template for pressreleases, should be absolute path.");

  defvar("pageoutputdir", "/home/www/pressrel/releases/", "Output dir for Pressreleases", TYPE_STRING, 
	 "Output dir for Pressreleases, should be absolute path.");

}

mixed *register_module()
{
  return ({ 
    MODULE_LOCATION,
    "Pressrelease-add", 
    "This module adds an easy way to handle site pressreleases",
    "Add (with preview) and show (delete manually for now)",
  });
}

string query_location() { return query("mountpoint"); }

int my_time() {  return time(1); }


mapping find_file( string requestedFile , object id)
{
  
  string htmlPage="";


  // ##################### NEW #########################
  if( requestedFile == "new" || requestedFile == "new/" ){

    htmlPage += actionNew( id );


    // ##################### PREVIEW #########################
  }else if( requestedFile == "preview"){

    htmlPage += actionPreview( id );


    // ##################### EDIT #########################
  }else if( requestedFile == "edit" || requestedFile == "edit/" ){
    
    htmlPage += actionEdit( id );


    // ##################### SAVE #########################
  }else if( requestedFile == "save"){

    htmlPage += actionSave( id );

    // ##################### ELSE #########################
  }else{

    htmlPage += print_htmlhead();
    // add content
    htmlPage += "<H1>ELSE STATEMENT ...</H1>\n"  
      + "<B><H2>h2 header</H2></B>\n";
    htmlPage += print_htmlbot();

  }


  // ##################### RETURN #########################  
  return http_string_answer( htmlPage );
  
}

string query_name()
{
  return query("mountpoint")+" ("+ctime(my_time())[11..15]+")";
}

string actionNew( object id ){

  string htmloutput = print_htmlhead();

  htmloutput += "<H1>" + query("addtitle") + "</H1>\n"
    + "<form method=POST action=" + query_location() + "preview>\n"
    + "<BR>\n"
    + "Title:<BR>\n" 
    + "<input name=title type=text size=40 maxlength=40>\n"
    + "<BR>\n"
    + "Text:(no htmltags!)<BR>\n"
    + "<textarea name=text rows=20 cols=80></textarea>\n"
    + "<BR>\n"
    + "<input type=\"reset\"  value=\"Reset\">\n"
    + "<input type=\"submit\" value=\"Preview\">\n"
    + "</form>\n";
  
  //"preview target=preview.window>\n"
  
  htmloutput += print_htmlbot();

  return htmloutput;

}

string actionPreview( object id ){


  string title = id->variables->title;
  string text = id->variables->text;


  // replcae the \n in the text input
  string text2 = replace( text, "\n", "<BR>");
  string text2 = replace( text2 , "\r", "");

  string htmloutput = print_page(title, text2 );

  htmloutput += "<HR>"
    + "<form method=POST action=" + query_location() + "save>\n"
    + "<input name=title type=hidden value=\"" + title + "\">\n"
    + "<input name=text type=hidden value=\"" + text + "\">\n"
    + "<H2>Observe SAVE is FINAL !!</H2>"
    + "<input type=\"submit\" value=\"Save\">\n"
    + "</form>\n";


  htmloutput += "<form method=POST action=" + query_location() + "edit>\n"
    + "<input name=title type=hidden value=\"" + title + "\">\n"
    + "<input name=text type=hidden value=\"" + text + "\">\n"
    + "<input type=\"submit\" value=\"Edit\">\n"
    + "</form>\n"
    + "<HR>\n";

  return htmloutput;
}



string actionEdit( object id ){

  string title = id->variables->title;
  string text = id->variables->text;

  // replcae the \n in the text input
  //    string text = replace( text, "\n", "");
  // string text = replace( text , "\r", "");

  //    string textLine1 = replace( text, "\n", "<BR>");

  string htmloutput = print_htmlhead();

  htmloutput += "<H1>" + query("addtitle") + "</H1>\n"
    + "<form method=POST action=" + query_location() + "preview>\n"
    + "<BR>\n"
    + "Title:<BR>\n" 
    + "<input name=title type=text size=40 maxlength=40 value=\"" + title + "\">\n"
    + "<BR>\n"
    + "Text:(no htmltags!)<BR>\n"
    + "<textarea name=text rows=20 cols=80 >\n" + text + "\n</textarea>\n"
    + "<BR>\n"
    + "<input type=\"reset\" value=\"Reset\">\n"
    + "<input type=\"submit\" value=\"Preview\">\n"
    + "</form>\n";

  htmloutput += print_htmlbot();

  return htmloutput;
}

string actionSave( object id ){

  string title = id->variables->title;
  string text = id->variables->text;

  // replcae the \n in the text input
  string text2 = replace( text, "\r", "<BR>");

  //    string htmloutput = print_page(title, text2 );

  // create file object
  object htmlFile = Stdio.File();

  string filePath = query("pageoutputdir");
  string mangledTitle = getFilename( title );
  string fileName = filePath + "/" + mangledTitle + ".html";

  string htmloutput = print_htmlhead();

    
  //    string fileName = "/tmp/outputfile.html";

  //    if ((!(from_file->open(from, "r"))) ||

  // open the output file for writing
  if( htmlFile->open( fileName, "w") ) {
    htmloutput += "<P><B>File already exists: " + fileName + "</B>";
    write("File already exists" + fileName );
    htmlFile->close();
  }else if( htmlFile->open( fileName, "cw") ) {
    //      htmlFile->write( htmloutput );
    htmlFile->write("<title>\n" + title + "\n</title>\n");
    htmlFile->write("\n<text>\n" + text + "\n</text>\n");
    htmlFile->close();

    htmloutput += "<P><B>Sucsess, write to output file:" + fileName + "</B>";
    write("Sucsess, write to" + fileName + "\n");
    //      update5list(filePath, fileName);
  }else{
    htmloutput += "<P><B>Couldn't open output file:" + fileName + "</B>";
    write("Couldn't open " + fileName +"\n");
  }

  htmloutput += print_htmlbot();
    
  return htmloutput;
}


// takes a title and a text and puts them in the template and returns it as a string.
string print_page(string title, string text){

  string page="";

  // file name
  string fileName = query("pagetemplate");

  // create file object
  object htmlFile = Stdio.File();

  //Stdio.File htmlFile;
  string htmlStage0;

  // open the template file and
  // read the whole file in to a string
  if( htmlFile->open( fileName, "r") ) {
    htmlStage0 = htmlFile->read();
    htmlFile->close();
  }else{
    write("Couldn't open " + fileName );
    htmlStage0 = "Couldn't open " + fileName;
  }

  // replcae the title tag in the html template
  string htmlStage1 = replace( htmlStage0, "<!--title-->" , title );

  // replcae the text tag in the html template    
  string htmlStage2 = replace( htmlStage1, "<!--text-->" , text);

  page += htmlStage2;
    
  return page;

}

string getFilename( string title ){

  mapping ton = localtime(time()); 

  int year  = ton["year"] + 1900; 
  int month = ton["mon"]  + 1; 
  int day   = ton["wday"] + 1;
  int hour  = ton["hour"];
  int min   = ton["min"];
  int sec   = ton["sec"];

  string dotm = year + "-" + month + "-" + day + "_" + hour + ":" + min + ":" + sec;
  
  return "pressrelease-title-" + dotm;

}

