/*
 * This C file has been generated by smidump 0.4.3.
 * It is intended to be used with the NET-SNMP library.
 *
 * This C file is derived from the IF-MIB module.
 *
 * $Id: if-mib-mgr-stub.c 1672 2004-08-09 14:56:17Z strauss $
 */

#include <stdlib.h>

#include <ucd-snmp/asn1.h>
#include <ucd-snmp/snmp.h>
#include <ucd-snmp/snmp_api.h>
#include <ucd-snmp/snmp_client.h>

#include "if-mib.h"

static oid ifNumber[] = {1, 3, 6, 1, 2, 1, 2, 1};
static oid ifIndex[] = {1, 3, 6, 1, 2, 1, 2, 2, 1, 1};
static oid ifDescr[] = {1, 3, 6, 1, 2, 1, 2, 2, 1, 2};
static oid ifType[] = {1, 3, 6, 1, 2, 1, 2, 2, 1, 3};
static oid ifMtu[] = {1, 3, 6, 1, 2, 1, 2, 2, 1, 4};
static oid ifSpeed[] = {1, 3, 6, 1, 2, 1, 2, 2, 1, 5};
static oid ifPhysAddress[] = {1, 3, 6, 1, 2, 1, 2, 2, 1, 6};
static oid ifAdminStatus[] = {1, 3, 6, 1, 2, 1, 2, 2, 1, 7};
static oid ifOperStatus[] = {1, 3, 6, 1, 2, 1, 2, 2, 1, 8};
static oid ifLastChange[] = {1, 3, 6, 1, 2, 1, 2, 2, 1, 9};
static oid ifInOctets[] = {1, 3, 6, 1, 2, 1, 2, 2, 1, 10};
static oid ifInUcastPkts[] = {1, 3, 6, 1, 2, 1, 2, 2, 1, 11};
static oid ifInNUcastPkts[] = {1, 3, 6, 1, 2, 1, 2, 2, 1, 12};
static oid ifInDiscards[] = {1, 3, 6, 1, 2, 1, 2, 2, 1, 13};
static oid ifInErrors[] = {1, 3, 6, 1, 2, 1, 2, 2, 1, 14};
static oid ifInUnknownProtos[] = {1, 3, 6, 1, 2, 1, 2, 2, 1, 15};
static oid ifOutOctets[] = {1, 3, 6, 1, 2, 1, 2, 2, 1, 16};
static oid ifOutUcastPkts[] = {1, 3, 6, 1, 2, 1, 2, 2, 1, 17};
static oid ifOutNUcastPkts[] = {1, 3, 6, 1, 2, 1, 2, 2, 1, 18};
static oid ifOutDiscards[] = {1, 3, 6, 1, 2, 1, 2, 2, 1, 19};
static oid ifOutErrors[] = {1, 3, 6, 1, 2, 1, 2, 2, 1, 20};
static oid ifOutQLen[] = {1, 3, 6, 1, 2, 1, 2, 2, 1, 21};
static oid ifSpecific[] = {1, 3, 6, 1, 2, 1, 2, 2, 1, 22};
static oid ifName[] = {1, 3, 6, 1, 2, 1, 31, 1, 1, 1, 1};
static oid ifInMulticastPkts[] = {1, 3, 6, 1, 2, 1, 31, 1, 1, 1, 2};
static oid ifInBroadcastPkts[] = {1, 3, 6, 1, 2, 1, 31, 1, 1, 1, 3};
static oid ifOutMulticastPkts[] = {1, 3, 6, 1, 2, 1, 31, 1, 1, 1, 4};
static oid ifOutBroadcastPkts[] = {1, 3, 6, 1, 2, 1, 31, 1, 1, 1, 5};
static oid ifHCInOctets[] = {1, 3, 6, 1, 2, 1, 31, 1, 1, 1, 6};
static oid ifHCInUcastPkts[] = {1, 3, 6, 1, 2, 1, 31, 1, 1, 1, 7};
static oid ifHCInMulticastPkts[] = {1, 3, 6, 1, 2, 1, 31, 1, 1, 1, 8};
static oid ifHCInBroadcastPkts[] = {1, 3, 6, 1, 2, 1, 31, 1, 1, 1, 9};
static oid ifHCOutOctets[] = {1, 3, 6, 1, 2, 1, 31, 1, 1, 1, 10};
static oid ifHCOutUcastPkts[] = {1, 3, 6, 1, 2, 1, 31, 1, 1, 1, 11};
static oid ifHCOutMulticastPkts[] = {1, 3, 6, 1, 2, 1, 31, 1, 1, 1, 12};
static oid ifHCOutBroadcastPkts[] = {1, 3, 6, 1, 2, 1, 31, 1, 1, 1, 13};
static oid ifLinkUpDownTrapEnable[] = {1, 3, 6, 1, 2, 1, 31, 1, 1, 1, 14};
static oid ifHighSpeed[] = {1, 3, 6, 1, 2, 1, 31, 1, 1, 1, 15};
static oid ifPromiscuousMode[] = {1, 3, 6, 1, 2, 1, 31, 1, 1, 1, 16};
static oid ifConnectorPresent[] = {1, 3, 6, 1, 2, 1, 31, 1, 1, 1, 17};
static oid ifAlias[] = {1, 3, 6, 1, 2, 1, 31, 1, 1, 1, 18};
static oid ifCounterDiscontinuityTime[] = {1, 3, 6, 1, 2, 1, 31, 1, 1, 1, 19};
static oid ifStackHigherLayer[] = {1, 3, 6, 1, 2, 1, 31, 1, 2, 1, 1};
static oid ifStackLowerLayer[] = {1, 3, 6, 1, 2, 1, 31, 1, 2, 1, 2};
static oid ifStackStatus[] = {1, 3, 6, 1, 2, 1, 31, 1, 2, 1, 3};
static oid ifTestId[] = {1, 3, 6, 1, 2, 1, 31, 1, 3, 1, 1};
static oid ifTestStatus[] = {1, 3, 6, 1, 2, 1, 31, 1, 3, 1, 2};
static oid ifTestType[] = {1, 3, 6, 1, 2, 1, 31, 1, 3, 1, 3};
static oid ifTestResult[] = {1, 3, 6, 1, 2, 1, 31, 1, 3, 1, 4};
static oid ifTestCode[] = {1, 3, 6, 1, 2, 1, 31, 1, 3, 1, 5};
static oid ifTestOwner[] = {1, 3, 6, 1, 2, 1, 31, 1, 3, 1, 6};
static oid ifRcvAddressAddress[] = {1, 3, 6, 1, 2, 1, 31, 1, 4, 1, 1};
static oid ifRcvAddressStatus[] = {1, 3, 6, 1, 2, 1, 31, 1, 4, 1, 2};
static oid ifRcvAddressType[] = {1, 3, 6, 1, 2, 1, 31, 1, 4, 1, 3};
static oid ifTableLastChange[] = {1, 3, 6, 1, 2, 1, 31, 1, 5};
static oid ifStackLastChange[] = {1, 3, 6, 1, 2, 1, 31, 1, 6};

int if_mib_mgr_get_interfaces(struct snmp_session *s, interfaces_t **interfaces)
{
    struct snmp_session *peer;
    struct snmp_pdu *request, *response;
    struct variable_list *vars;
    int status;

    request = snmp_pdu_create(SNMP_MSG_GETNEXT);
    snmp_add_null_var(request, ifNumber, sizeof(ifNumber)/sizeof(oid));

    peer = snmp_open(s);
    if (!peer) {
        return -1;
    }

    status = snmp_synch_response(peer, request, &response);
    if (status != STAT_SUCCESS) {
        if (response) snmp_free_pdu(response);
        snmp_close(peer);
        return -2;
    }

    *interfaces = (interfaces_t *) malloc(sizeof(interfaces_t));
    if (! *interfaces) {
        if (response) snmp_free_pdu(response);
        snmp_close(peer);
        return -4;
    }

    for (vars = response->variables; vars; vars = vars->next_variable) {
        if (vars->name_length > sizeof(ifNumber)/sizeof(oid)
            && memcmp(vars->name, ifNumber, sizeof(ifNumber)) == 0) {
            (*interfaces)->__ifNumber = *vars->val.integer;
            (*interfaces)->ifNumber = &((*interfaces)->__ifNumber);
        }
    }

    if (response) snmp_free_pdu(response);

    if (snmp_close(peer) == 0) {
        return -5;
    }

    return 0;
}

int if_mib_mgr_get_ifEntry(struct snmp_session *s, ifEntry_t **ifEntry)
{
    struct snmp_session *peer;
    struct snmp_pdu *request, *response;
    struct variable_list *vars;
    int status;

    request = snmp_pdu_create(SNMP_MSG_GETNEXT);
    snmp_add_null_var(request, ifIndex, sizeof(ifIndex)/sizeof(oid));
    snmp_add_null_var(request, ifDescr, sizeof(ifDescr)/sizeof(oid));
    snmp_add_null_var(request, ifType, sizeof(ifType)/sizeof(oid));
    snmp_add_null_var(request, ifMtu, sizeof(ifMtu)/sizeof(oid));
    snmp_add_null_var(request, ifSpeed, sizeof(ifSpeed)/sizeof(oid));
    snmp_add_null_var(request, ifPhysAddress, sizeof(ifPhysAddress)/sizeof(oid));
    snmp_add_null_var(request, ifAdminStatus, sizeof(ifAdminStatus)/sizeof(oid));
    snmp_add_null_var(request, ifOperStatus, sizeof(ifOperStatus)/sizeof(oid));
    snmp_add_null_var(request, ifLastChange, sizeof(ifLastChange)/sizeof(oid));
    snmp_add_null_var(request, ifInOctets, sizeof(ifInOctets)/sizeof(oid));
    snmp_add_null_var(request, ifInUcastPkts, sizeof(ifInUcastPkts)/sizeof(oid));
    snmp_add_null_var(request, ifInNUcastPkts, sizeof(ifInNUcastPkts)/sizeof(oid));
    snmp_add_null_var(request, ifInDiscards, sizeof(ifInDiscards)/sizeof(oid));
    snmp_add_null_var(request, ifInErrors, sizeof(ifInErrors)/sizeof(oid));
    snmp_add_null_var(request, ifInUnknownProtos, sizeof(ifInUnknownProtos)/sizeof(oid));
    snmp_add_null_var(request, ifOutOctets, sizeof(ifOutOctets)/sizeof(oid));
    snmp_add_null_var(request, ifOutUcastPkts, sizeof(ifOutUcastPkts)/sizeof(oid));
    snmp_add_null_var(request, ifOutNUcastPkts, sizeof(ifOutNUcastPkts)/sizeof(oid));
    snmp_add_null_var(request, ifOutDiscards, sizeof(ifOutDiscards)/sizeof(oid));
    snmp_add_null_var(request, ifOutErrors, sizeof(ifOutErrors)/sizeof(oid));
    snmp_add_null_var(request, ifOutQLen, sizeof(ifOutQLen)/sizeof(oid));
    snmp_add_null_var(request, ifSpecific, sizeof(ifSpecific)/sizeof(oid));

    peer = snmp_open(s);
    if (!peer) {
        return -1;
    }

    status = snmp_synch_response(peer, request, &response);
    if (status != STAT_SUCCESS) {
        if (response) snmp_free_pdu(response);
        snmp_close(peer);
        return -2;
    }

    *ifEntry = (ifEntry_t *) malloc(sizeof(ifEntry_t));
    if (! *ifEntry) {
        if (response) snmp_free_pdu(response);
        snmp_close(peer);
        return -4;
    }

    for (vars = response->variables; vars; vars = vars->next_variable) {
        if (vars->name_length > sizeof(ifIndex)/sizeof(oid)
            && memcmp(vars->name, ifIndex, sizeof(ifIndex)) == 0) {
            (*ifEntry)->__ifIndex = *vars->val.integer;
            (*ifEntry)->ifIndex = &((*ifEntry)->__ifIndex);
        }
        if (vars->name_length > sizeof(ifDescr)/sizeof(oid)
            && memcmp(vars->name, ifDescr, sizeof(ifDescr)) == 0) {
            memcpy((*ifEntry)->__ifDescr, vars->val.string, vars->val_len);
            (*ifEntry)->_ifDescrLength = vars->val_len;
            (*ifEntry)->ifDescr = (*ifEntry)->__ifDescr;
        }
        if (vars->name_length > sizeof(ifType)/sizeof(oid)
            && memcmp(vars->name, ifType, sizeof(ifType)) == 0) {
            (*ifEntry)->__ifType = *vars->val.integer;
            (*ifEntry)->ifType = &((*ifEntry)->__ifType);
        }
        if (vars->name_length > sizeof(ifMtu)/sizeof(oid)
            && memcmp(vars->name, ifMtu, sizeof(ifMtu)) == 0) {
            (*ifEntry)->__ifMtu = *vars->val.integer;
            (*ifEntry)->ifMtu = &((*ifEntry)->__ifMtu);
        }
        if (vars->name_length > sizeof(ifSpeed)/sizeof(oid)
            && memcmp(vars->name, ifSpeed, sizeof(ifSpeed)) == 0) {
            (*ifEntry)->__ifSpeed = *vars->val.integer;
            (*ifEntry)->ifSpeed = &((*ifEntry)->__ifSpeed);
        }
        if (vars->name_length > sizeof(ifPhysAddress)/sizeof(oid)
            && memcmp(vars->name, ifPhysAddress, sizeof(ifPhysAddress)) == 0) {
            memcpy((*ifEntry)->__ifPhysAddress, vars->val.string, vars->val_len);
            (*ifEntry)->_ifPhysAddressLength = vars->val_len;
            (*ifEntry)->ifPhysAddress = (*ifEntry)->__ifPhysAddress;
        }
        if (vars->name_length > sizeof(ifAdminStatus)/sizeof(oid)
            && memcmp(vars->name, ifAdminStatus, sizeof(ifAdminStatus)) == 0) {
            (*ifEntry)->__ifAdminStatus = *vars->val.integer;
            (*ifEntry)->ifAdminStatus = &((*ifEntry)->__ifAdminStatus);
        }
        if (vars->name_length > sizeof(ifOperStatus)/sizeof(oid)
            && memcmp(vars->name, ifOperStatus, sizeof(ifOperStatus)) == 0) {
            (*ifEntry)->__ifOperStatus = *vars->val.integer;
            (*ifEntry)->ifOperStatus = &((*ifEntry)->__ifOperStatus);
        }
        if (vars->name_length > sizeof(ifLastChange)/sizeof(oid)
            && memcmp(vars->name, ifLastChange, sizeof(ifLastChange)) == 0) {
            (*ifEntry)->__ifLastChange = *vars->val.integer;
            (*ifEntry)->ifLastChange = &((*ifEntry)->__ifLastChange);
        }
        if (vars->name_length > sizeof(ifInOctets)/sizeof(oid)
            && memcmp(vars->name, ifInOctets, sizeof(ifInOctets)) == 0) {
            (*ifEntry)->__ifInOctets = *vars->val.integer;
            (*ifEntry)->ifInOctets = &((*ifEntry)->__ifInOctets);
        }
        if (vars->name_length > sizeof(ifInUcastPkts)/sizeof(oid)
            && memcmp(vars->name, ifInUcastPkts, sizeof(ifInUcastPkts)) == 0) {
            (*ifEntry)->__ifInUcastPkts = *vars->val.integer;
            (*ifEntry)->ifInUcastPkts = &((*ifEntry)->__ifInUcastPkts);
        }
        if (vars->name_length > sizeof(ifInNUcastPkts)/sizeof(oid)
            && memcmp(vars->name, ifInNUcastPkts, sizeof(ifInNUcastPkts)) == 0) {
            (*ifEntry)->__ifInNUcastPkts = *vars->val.integer;
            (*ifEntry)->ifInNUcastPkts = &((*ifEntry)->__ifInNUcastPkts);
        }
        if (vars->name_length > sizeof(ifInDiscards)/sizeof(oid)
            && memcmp(vars->name, ifInDiscards, sizeof(ifInDiscards)) == 0) {
            (*ifEntry)->__ifInDiscards = *vars->val.integer;
            (*ifEntry)->ifInDiscards = &((*ifEntry)->__ifInDiscards);
        }
        if (vars->name_length > sizeof(ifInErrors)/sizeof(oid)
            && memcmp(vars->name, ifInErrors, sizeof(ifInErrors)) == 0) {
            (*ifEntry)->__ifInErrors = *vars->val.integer;
            (*ifEntry)->ifInErrors = &((*ifEntry)->__ifInErrors);
        }
        if (vars->name_length > sizeof(ifInUnknownProtos)/sizeof(oid)
            && memcmp(vars->name, ifInUnknownProtos, sizeof(ifInUnknownProtos)) == 0) {
            (*ifEntry)->__ifInUnknownProtos = *vars->val.integer;
            (*ifEntry)->ifInUnknownProtos = &((*ifEntry)->__ifInUnknownProtos);
        }
        if (vars->name_length > sizeof(ifOutOctets)/sizeof(oid)
            && memcmp(vars->name, ifOutOctets, sizeof(ifOutOctets)) == 0) {
            (*ifEntry)->__ifOutOctets = *vars->val.integer;
            (*ifEntry)->ifOutOctets = &((*ifEntry)->__ifOutOctets);
        }
        if (vars->name_length > sizeof(ifOutUcastPkts)/sizeof(oid)
            && memcmp(vars->name, ifOutUcastPkts, sizeof(ifOutUcastPkts)) == 0) {
            (*ifEntry)->__ifOutUcastPkts = *vars->val.integer;
            (*ifEntry)->ifOutUcastPkts = &((*ifEntry)->__ifOutUcastPkts);
        }
        if (vars->name_length > sizeof(ifOutNUcastPkts)/sizeof(oid)
            && memcmp(vars->name, ifOutNUcastPkts, sizeof(ifOutNUcastPkts)) == 0) {
            (*ifEntry)->__ifOutNUcastPkts = *vars->val.integer;
            (*ifEntry)->ifOutNUcastPkts = &((*ifEntry)->__ifOutNUcastPkts);
        }
        if (vars->name_length > sizeof(ifOutDiscards)/sizeof(oid)
            && memcmp(vars->name, ifOutDiscards, sizeof(ifOutDiscards)) == 0) {
            (*ifEntry)->__ifOutDiscards = *vars->val.integer;
            (*ifEntry)->ifOutDiscards = &((*ifEntry)->__ifOutDiscards);
        }
        if (vars->name_length > sizeof(ifOutErrors)/sizeof(oid)
            && memcmp(vars->name, ifOutErrors, sizeof(ifOutErrors)) == 0) {
            (*ifEntry)->__ifOutErrors = *vars->val.integer;
            (*ifEntry)->ifOutErrors = &((*ifEntry)->__ifOutErrors);
        }
        if (vars->name_length > sizeof(ifOutQLen)/sizeof(oid)
            && memcmp(vars->name, ifOutQLen, sizeof(ifOutQLen)) == 0) {
            (*ifEntry)->__ifOutQLen = *vars->val.integer;
            (*ifEntry)->ifOutQLen = &((*ifEntry)->__ifOutQLen);
        }
        if (vars->name_length > sizeof(ifSpecific)/sizeof(oid)
            && memcmp(vars->name, ifSpecific, sizeof(ifSpecific)) == 0) {
        }
    }

    if (response) snmp_free_pdu(response);

    if (snmp_close(peer) == 0) {
        return -5;
    }

    return 0;
}

int if_mib_mgr_get_ifMIBObjects(struct snmp_session *s, ifMIBObjects_t **ifMIBObjects)
{
    struct snmp_session *peer;
    struct snmp_pdu *request, *response;
    struct variable_list *vars;
    int status;

    request = snmp_pdu_create(SNMP_MSG_GETNEXT);
    snmp_add_null_var(request, ifTableLastChange, sizeof(ifTableLastChange)/sizeof(oid));
    snmp_add_null_var(request, ifStackLastChange, sizeof(ifStackLastChange)/sizeof(oid));

    peer = snmp_open(s);
    if (!peer) {
        return -1;
    }

    status = snmp_synch_response(peer, request, &response);
    if (status != STAT_SUCCESS) {
        if (response) snmp_free_pdu(response);
        snmp_close(peer);
        return -2;
    }

    *ifMIBObjects = (ifMIBObjects_t *) malloc(sizeof(ifMIBObjects_t));
    if (! *ifMIBObjects) {
        if (response) snmp_free_pdu(response);
        snmp_close(peer);
        return -4;
    }

    for (vars = response->variables; vars; vars = vars->next_variable) {
        if (vars->name_length > sizeof(ifTableLastChange)/sizeof(oid)
            && memcmp(vars->name, ifTableLastChange, sizeof(ifTableLastChange)) == 0) {
            (*ifMIBObjects)->__ifTableLastChange = *vars->val.integer;
            (*ifMIBObjects)->ifTableLastChange = &((*ifMIBObjects)->__ifTableLastChange);
        }
        if (vars->name_length > sizeof(ifStackLastChange)/sizeof(oid)
            && memcmp(vars->name, ifStackLastChange, sizeof(ifStackLastChange)) == 0) {
            (*ifMIBObjects)->__ifStackLastChange = *vars->val.integer;
            (*ifMIBObjects)->ifStackLastChange = &((*ifMIBObjects)->__ifStackLastChange);
        }
    }

    if (response) snmp_free_pdu(response);

    if (snmp_close(peer) == 0) {
        return -5;
    }

    return 0;
}

int if_mib_mgr_get_ifXEntry(struct snmp_session *s, ifXEntry_t **ifXEntry)
{
    struct snmp_session *peer;
    struct snmp_pdu *request, *response;
    struct variable_list *vars;
    int status;

    request = snmp_pdu_create(SNMP_MSG_GETNEXT);
    snmp_add_null_var(request, ifName, sizeof(ifName)/sizeof(oid));
    snmp_add_null_var(request, ifInMulticastPkts, sizeof(ifInMulticastPkts)/sizeof(oid));
    snmp_add_null_var(request, ifInBroadcastPkts, sizeof(ifInBroadcastPkts)/sizeof(oid));
    snmp_add_null_var(request, ifOutMulticastPkts, sizeof(ifOutMulticastPkts)/sizeof(oid));
    snmp_add_null_var(request, ifOutBroadcastPkts, sizeof(ifOutBroadcastPkts)/sizeof(oid));
    snmp_add_null_var(request, ifHCInOctets, sizeof(ifHCInOctets)/sizeof(oid));
    snmp_add_null_var(request, ifHCInUcastPkts, sizeof(ifHCInUcastPkts)/sizeof(oid));
    snmp_add_null_var(request, ifHCInMulticastPkts, sizeof(ifHCInMulticastPkts)/sizeof(oid));
    snmp_add_null_var(request, ifHCInBroadcastPkts, sizeof(ifHCInBroadcastPkts)/sizeof(oid));
    snmp_add_null_var(request, ifHCOutOctets, sizeof(ifHCOutOctets)/sizeof(oid));
    snmp_add_null_var(request, ifHCOutUcastPkts, sizeof(ifHCOutUcastPkts)/sizeof(oid));
    snmp_add_null_var(request, ifHCOutMulticastPkts, sizeof(ifHCOutMulticastPkts)/sizeof(oid));
    snmp_add_null_var(request, ifHCOutBroadcastPkts, sizeof(ifHCOutBroadcastPkts)/sizeof(oid));
    snmp_add_null_var(request, ifLinkUpDownTrapEnable, sizeof(ifLinkUpDownTrapEnable)/sizeof(oid));
    snmp_add_null_var(request, ifHighSpeed, sizeof(ifHighSpeed)/sizeof(oid));
    snmp_add_null_var(request, ifPromiscuousMode, sizeof(ifPromiscuousMode)/sizeof(oid));
    snmp_add_null_var(request, ifConnectorPresent, sizeof(ifConnectorPresent)/sizeof(oid));
    snmp_add_null_var(request, ifAlias, sizeof(ifAlias)/sizeof(oid));
    snmp_add_null_var(request, ifCounterDiscontinuityTime, sizeof(ifCounterDiscontinuityTime)/sizeof(oid));

    peer = snmp_open(s);
    if (!peer) {
        return -1;
    }

    status = snmp_synch_response(peer, request, &response);
    if (status != STAT_SUCCESS) {
        if (response) snmp_free_pdu(response);
        snmp_close(peer);
        return -2;
    }

    *ifXEntry = (ifXEntry_t *) malloc(sizeof(ifXEntry_t));
    if (! *ifXEntry) {
        if (response) snmp_free_pdu(response);
        snmp_close(peer);
        return -4;
    }

    for (vars = response->variables; vars; vars = vars->next_variable) {
        if (vars->name_length > sizeof(ifName)/sizeof(oid)
            && memcmp(vars->name, ifName, sizeof(ifName)) == 0) {
            memcpy((*ifXEntry)->__ifName, vars->val.string, vars->val_len);
            (*ifXEntry)->_ifNameLength = vars->val_len;
            (*ifXEntry)->ifName = (*ifXEntry)->__ifName;
        }
        if (vars->name_length > sizeof(ifInMulticastPkts)/sizeof(oid)
            && memcmp(vars->name, ifInMulticastPkts, sizeof(ifInMulticastPkts)) == 0) {
            (*ifXEntry)->__ifInMulticastPkts = *vars->val.integer;
            (*ifXEntry)->ifInMulticastPkts = &((*ifXEntry)->__ifInMulticastPkts);
        }
        if (vars->name_length > sizeof(ifInBroadcastPkts)/sizeof(oid)
            && memcmp(vars->name, ifInBroadcastPkts, sizeof(ifInBroadcastPkts)) == 0) {
            (*ifXEntry)->__ifInBroadcastPkts = *vars->val.integer;
            (*ifXEntry)->ifInBroadcastPkts = &((*ifXEntry)->__ifInBroadcastPkts);
        }
        if (vars->name_length > sizeof(ifOutMulticastPkts)/sizeof(oid)
            && memcmp(vars->name, ifOutMulticastPkts, sizeof(ifOutMulticastPkts)) == 0) {
            (*ifXEntry)->__ifOutMulticastPkts = *vars->val.integer;
            (*ifXEntry)->ifOutMulticastPkts = &((*ifXEntry)->__ifOutMulticastPkts);
        }
        if (vars->name_length > sizeof(ifOutBroadcastPkts)/sizeof(oid)
            && memcmp(vars->name, ifOutBroadcastPkts, sizeof(ifOutBroadcastPkts)) == 0) {
            (*ifXEntry)->__ifOutBroadcastPkts = *vars->val.integer;
            (*ifXEntry)->ifOutBroadcastPkts = &((*ifXEntry)->__ifOutBroadcastPkts);
        }
        if (vars->name_length > sizeof(ifHCInOctets)/sizeof(oid)
            && memcmp(vars->name, ifHCInOctets, sizeof(ifHCInOctets)) == 0) {
        }
        if (vars->name_length > sizeof(ifHCInUcastPkts)/sizeof(oid)
            && memcmp(vars->name, ifHCInUcastPkts, sizeof(ifHCInUcastPkts)) == 0) {
        }
        if (vars->name_length > sizeof(ifHCInMulticastPkts)/sizeof(oid)
            && memcmp(vars->name, ifHCInMulticastPkts, sizeof(ifHCInMulticastPkts)) == 0) {
        }
        if (vars->name_length > sizeof(ifHCInBroadcastPkts)/sizeof(oid)
            && memcmp(vars->name, ifHCInBroadcastPkts, sizeof(ifHCInBroadcastPkts)) == 0) {
        }
        if (vars->name_length > sizeof(ifHCOutOctets)/sizeof(oid)
            && memcmp(vars->name, ifHCOutOctets, sizeof(ifHCOutOctets)) == 0) {
        }
        if (vars->name_length > sizeof(ifHCOutUcastPkts)/sizeof(oid)
            && memcmp(vars->name, ifHCOutUcastPkts, sizeof(ifHCOutUcastPkts)) == 0) {
        }
        if (vars->name_length > sizeof(ifHCOutMulticastPkts)/sizeof(oid)
            && memcmp(vars->name, ifHCOutMulticastPkts, sizeof(ifHCOutMulticastPkts)) == 0) {
        }
        if (vars->name_length > sizeof(ifHCOutBroadcastPkts)/sizeof(oid)
            && memcmp(vars->name, ifHCOutBroadcastPkts, sizeof(ifHCOutBroadcastPkts)) == 0) {
        }
        if (vars->name_length > sizeof(ifLinkUpDownTrapEnable)/sizeof(oid)
            && memcmp(vars->name, ifLinkUpDownTrapEnable, sizeof(ifLinkUpDownTrapEnable)) == 0) {
            (*ifXEntry)->__ifLinkUpDownTrapEnable = *vars->val.integer;
            (*ifXEntry)->ifLinkUpDownTrapEnable = &((*ifXEntry)->__ifLinkUpDownTrapEnable);
        }
        if (vars->name_length > sizeof(ifHighSpeed)/sizeof(oid)
            && memcmp(vars->name, ifHighSpeed, sizeof(ifHighSpeed)) == 0) {
            (*ifXEntry)->__ifHighSpeed = *vars->val.integer;
            (*ifXEntry)->ifHighSpeed = &((*ifXEntry)->__ifHighSpeed);
        }
        if (vars->name_length > sizeof(ifPromiscuousMode)/sizeof(oid)
            && memcmp(vars->name, ifPromiscuousMode, sizeof(ifPromiscuousMode)) == 0) {
            (*ifXEntry)->__ifPromiscuousMode = *vars->val.integer;
            (*ifXEntry)->ifPromiscuousMode = &((*ifXEntry)->__ifPromiscuousMode);
        }
        if (vars->name_length > sizeof(ifConnectorPresent)/sizeof(oid)
            && memcmp(vars->name, ifConnectorPresent, sizeof(ifConnectorPresent)) == 0) {
            (*ifXEntry)->__ifConnectorPresent = *vars->val.integer;
            (*ifXEntry)->ifConnectorPresent = &((*ifXEntry)->__ifConnectorPresent);
        }
        if (vars->name_length > sizeof(ifAlias)/sizeof(oid)
            && memcmp(vars->name, ifAlias, sizeof(ifAlias)) == 0) {
            memcpy((*ifXEntry)->__ifAlias, vars->val.string, vars->val_len);
            (*ifXEntry)->_ifAliasLength = vars->val_len;
            (*ifXEntry)->ifAlias = (*ifXEntry)->__ifAlias;
        }
        if (vars->name_length > sizeof(ifCounterDiscontinuityTime)/sizeof(oid)
            && memcmp(vars->name, ifCounterDiscontinuityTime, sizeof(ifCounterDiscontinuityTime)) == 0) {
            (*ifXEntry)->__ifCounterDiscontinuityTime = *vars->val.integer;
            (*ifXEntry)->ifCounterDiscontinuityTime = &((*ifXEntry)->__ifCounterDiscontinuityTime);
        }
    }

    if (response) snmp_free_pdu(response);

    if (snmp_close(peer) == 0) {
        return -5;
    }

    return 0;
}

int if_mib_mgr_get_ifStackEntry(struct snmp_session *s, ifStackEntry_t **ifStackEntry)
{
    struct snmp_session *peer;
    struct snmp_pdu *request, *response;
    struct variable_list *vars;
    int status;

    request = snmp_pdu_create(SNMP_MSG_GETNEXT);
    snmp_add_null_var(request, ifStackStatus, sizeof(ifStackStatus)/sizeof(oid));

    peer = snmp_open(s);
    if (!peer) {
        return -1;
    }

    status = snmp_synch_response(peer, request, &response);
    if (status != STAT_SUCCESS) {
        if (response) snmp_free_pdu(response);
        snmp_close(peer);
        return -2;
    }

    *ifStackEntry = (ifStackEntry_t *) malloc(sizeof(ifStackEntry_t));
    if (! *ifStackEntry) {
        if (response) snmp_free_pdu(response);
        snmp_close(peer);
        return -4;
    }

    for (vars = response->variables; vars; vars = vars->next_variable) {
        if (vars->name_length > sizeof(ifStackStatus)/sizeof(oid)
            && memcmp(vars->name, ifStackStatus, sizeof(ifStackStatus)) == 0) {
            (*ifStackEntry)->__ifStackStatus = *vars->val.integer;
            (*ifStackEntry)->ifStackStatus = &((*ifStackEntry)->__ifStackStatus);
        }
    }

    if (response) snmp_free_pdu(response);

    if (snmp_close(peer) == 0) {
        return -5;
    }

    return 0;
}

int if_mib_mgr_get_ifTestEntry(struct snmp_session *s, ifTestEntry_t **ifTestEntry)
{
    struct snmp_session *peer;
    struct snmp_pdu *request, *response;
    struct variable_list *vars;
    int status;

    request = snmp_pdu_create(SNMP_MSG_GETNEXT);
    snmp_add_null_var(request, ifTestId, sizeof(ifTestId)/sizeof(oid));
    snmp_add_null_var(request, ifTestStatus, sizeof(ifTestStatus)/sizeof(oid));
    snmp_add_null_var(request, ifTestType, sizeof(ifTestType)/sizeof(oid));
    snmp_add_null_var(request, ifTestResult, sizeof(ifTestResult)/sizeof(oid));
    snmp_add_null_var(request, ifTestCode, sizeof(ifTestCode)/sizeof(oid));
    snmp_add_null_var(request, ifTestOwner, sizeof(ifTestOwner)/sizeof(oid));

    peer = snmp_open(s);
    if (!peer) {
        return -1;
    }

    status = snmp_synch_response(peer, request, &response);
    if (status != STAT_SUCCESS) {
        if (response) snmp_free_pdu(response);
        snmp_close(peer);
        return -2;
    }

    *ifTestEntry = (ifTestEntry_t *) malloc(sizeof(ifTestEntry_t));
    if (! *ifTestEntry) {
        if (response) snmp_free_pdu(response);
        snmp_close(peer);
        return -4;
    }

    for (vars = response->variables; vars; vars = vars->next_variable) {
        if (vars->name_length > sizeof(ifTestId)/sizeof(oid)
            && memcmp(vars->name, ifTestId, sizeof(ifTestId)) == 0) {
            (*ifTestEntry)->__ifTestId = *vars->val.integer;
            (*ifTestEntry)->ifTestId = &((*ifTestEntry)->__ifTestId);
        }
        if (vars->name_length > sizeof(ifTestStatus)/sizeof(oid)
            && memcmp(vars->name, ifTestStatus, sizeof(ifTestStatus)) == 0) {
            (*ifTestEntry)->__ifTestStatus = *vars->val.integer;
            (*ifTestEntry)->ifTestStatus = &((*ifTestEntry)->__ifTestStatus);
        }
        if (vars->name_length > sizeof(ifTestType)/sizeof(oid)
            && memcmp(vars->name, ifTestType, sizeof(ifTestType)) == 0) {
        }
        if (vars->name_length > sizeof(ifTestResult)/sizeof(oid)
            && memcmp(vars->name, ifTestResult, sizeof(ifTestResult)) == 0) {
            (*ifTestEntry)->__ifTestResult = *vars->val.integer;
            (*ifTestEntry)->ifTestResult = &((*ifTestEntry)->__ifTestResult);
        }
        if (vars->name_length > sizeof(ifTestCode)/sizeof(oid)
            && memcmp(vars->name, ifTestCode, sizeof(ifTestCode)) == 0) {
        }
        if (vars->name_length > sizeof(ifTestOwner)/sizeof(oid)
            && memcmp(vars->name, ifTestOwner, sizeof(ifTestOwner)) == 0) {
            memcpy((*ifTestEntry)->__ifTestOwner, vars->val.string, vars->val_len);
            (*ifTestEntry)->_ifTestOwnerLength = vars->val_len;
            (*ifTestEntry)->ifTestOwner = (*ifTestEntry)->__ifTestOwner;
        }
    }

    if (response) snmp_free_pdu(response);

    if (snmp_close(peer) == 0) {
        return -5;
    }

    return 0;
}

int if_mib_mgr_get_ifRcvAddressEntry(struct snmp_session *s, ifRcvAddressEntry_t **ifRcvAddressEntry)
{
    struct snmp_session *peer;
    struct snmp_pdu *request, *response;
    struct variable_list *vars;
    int status;

    request = snmp_pdu_create(SNMP_MSG_GETNEXT);
    snmp_add_null_var(request, ifRcvAddressStatus, sizeof(ifRcvAddressStatus)/sizeof(oid));
    snmp_add_null_var(request, ifRcvAddressType, sizeof(ifRcvAddressType)/sizeof(oid));

    peer = snmp_open(s);
    if (!peer) {
        return -1;
    }

    status = snmp_synch_response(peer, request, &response);
    if (status != STAT_SUCCESS) {
        if (response) snmp_free_pdu(response);
        snmp_close(peer);
        return -2;
    }

    *ifRcvAddressEntry = (ifRcvAddressEntry_t *) malloc(sizeof(ifRcvAddressEntry_t));
    if (! *ifRcvAddressEntry) {
        if (response) snmp_free_pdu(response);
        snmp_close(peer);
        return -4;
    }

    for (vars = response->variables; vars; vars = vars->next_variable) {
        if (vars->name_length > sizeof(ifRcvAddressStatus)/sizeof(oid)
            && memcmp(vars->name, ifRcvAddressStatus, sizeof(ifRcvAddressStatus)) == 0) {
            (*ifRcvAddressEntry)->__ifRcvAddressStatus = *vars->val.integer;
            (*ifRcvAddressEntry)->ifRcvAddressStatus = &((*ifRcvAddressEntry)->__ifRcvAddressStatus);
        }
        if (vars->name_length > sizeof(ifRcvAddressType)/sizeof(oid)
            && memcmp(vars->name, ifRcvAddressType, sizeof(ifRcvAddressType)) == 0) {
            (*ifRcvAddressEntry)->__ifRcvAddressType = *vars->val.integer;
            (*ifRcvAddressEntry)->ifRcvAddressType = &((*ifRcvAddressEntry)->__ifRcvAddressType);
        }
    }

    if (response) snmp_free_pdu(response);

    if (snmp_close(peer) == 0) {
        return -5;
    }

    return 0;
}


