#ifndef __SYS_SPE_H
#define __SYS_SPE_H

#include <sys/syscall.h>
#include <unistd.h>

#ifndef __NR_spe_run
#define __NR_spe_run 278
#endif

#ifndef __NR_spe_create
#define __NR_spe_create 279
#endif

#define SPU_CREATE_EVENTS_ENABLED 0x0001
#define SPU_CREATE_GANG 0x0002

#define SPU_CREATE_NOSCHED 0x0004
#define SPU_CREATE_ISOLATE 0x0008

static inline int spe_run(int fd, unsigned int *npc, unsigned int *status)
{
	return syscall(__NR_spe_run, fd, npc, status);
}

static inline int spe_create(const char * path, int flags, mode_t mode)
{
	return syscall(__NR_spe_create, path, flags, mode);
}

#endif
